/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import nxt.Nxt;
import nxt.account.Account;
import nxt.account.HoldingType;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildChainSnapshot;
import nxt.migration.HoldingMigrateBlockEventHandler;
import nxt.migration.MigrationMonitor;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Logger;

public class ChildChainLoader {
    public static final String CHILD_CHAIN_LOAD_HEIGHT_PROPERTY_PREFIX = "ChildChainLoad";
    public static final long CHILD_CHAIN_LOAD_SETTER_ACCOUNT = Convert.parseAccountId("ARDOR-XNBG-5TB4-SC4R-B73ZW");

    static void init() {
        MigrationMonitor.init();
        Nxt.getBlockchainProcessor().addListener(new HoldingMigrateBlockEventHandler(new ChildChainSnapshot()), BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        Account.addPropertyListener(new AccountPropertyEventHandler(), Account.Event.SET_PROPERTY);
    }

    public static void enableChildChainLoading(ChildChain childChain, int n, int n2) {
        MigrationMonitor.enableMigration(0L, HoldingType.COIN, childChain, n, n2);
    }

    private static class AccountPropertyEventHandler
    implements Listener<Account.AccountProperty> {
        private AccountPropertyEventHandler() {
        }

        @Override
        public void notify(Account.AccountProperty accountProperty) {
            int n;
            int n2;
            if (accountProperty.getSetterId() != CHILD_CHAIN_LOAD_SETTER_ACCOUNT) {
                return;
            }
            if (accountProperty.getSetterId() != accountProperty.getRecipientId()) {
                return;
            }
            if (!accountProperty.getProperty().startsWith(ChildChainLoader.CHILD_CHAIN_LOAD_HEIGHT_PROPERTY_PREFIX)) {
                return;
            }
            try {
                n2 = Integer.parseInt(accountProperty.getValue());
                n = Integer.parseInt(accountProperty.getProperty().substring(ChildChainLoader.CHILD_CHAIN_LOAD_HEIGHT_PROPERTY_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                Logger.logDebugMessage("Invalid height or child chain id", numberFormatException);
                return;
            }
            ChildChain childChain = ChildChain.getChildChain(n);
            if (childChain == null) {
                Logger.logDebugMessage(String.format("Invalid child chain id %d", n));
                return;
            }
            MigrationMonitor.scheduleMigration(childChain, n2);
        }
    }
}

