/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountRestrictions;
import nxt.blockchain.Appendix;
import nxt.blockchain.AppendixParsers;
import nxt.blockchain.Attachment;
import nxt.blockchain.BlockDb;
import nxt.blockchain.BlockImpl;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.Chain;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.crypto.Crypto;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.JSON;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public abstract class TransactionImpl
implements Transaction {
    private final short deadline;
    private volatile byte[] senderPublicKey;
    private final long recipientId;
    private final long amount;
    private final TransactionType type;
    private final int ecBlockHeight;
    private final long ecBlockId;
    private final byte version;
    private final int timestamp;
    final Attachment.AbstractAttachment attachment;
    private final List<Appendix.AbstractAppendix> appendages;
    private final int appendagesSize;
    private final PrunablePlainMessageAppendix prunablePlainMessage;
    private final PrunableEncryptedMessageAppendix prunableEncryptedMessage;
    private volatile int height;
    private volatile long blockId;
    private volatile BlockImpl block;
    private volatile int blockTimestamp;
    private volatile short index;
    private volatile long id;
    private volatile String stringId;
    private volatile long senderId;
    private volatile byte[] fullHash;
    volatile byte[] bytes = null;
    volatile byte[] prunableBytes = null;
    private volatile boolean hasValidSignature = false;
    private static final int SIGNATURE_OFFSET = 69;

    TransactionImpl(BuilderImpl builderImpl) {
        this.timestamp = builderImpl.timestamp;
        this.deadline = builderImpl.deadline;
        this.senderPublicKey = builderImpl.senderPublicKey;
        this.recipientId = builderImpl.recipientId;
        this.amount = builderImpl.amount;
        this.type = builderImpl.type;
        this.attachment = (Attachment.AbstractAttachment)builderImpl.appendageList.get(0);
        this.appendages = Collections.unmodifiableList(builderImpl.appendageList);
        this.appendagesSize = builderImpl.appendagesSize;
        this.version = builderImpl.version;
        this.blockId = builderImpl.blockId;
        this.height = builderImpl.height;
        this.index = builderImpl.index;
        this.id = builderImpl.id;
        this.senderId = builderImpl.senderId;
        this.blockTimestamp = builderImpl.blockTimestamp;
        this.fullHash = builderImpl.fullHash;
        this.ecBlockHeight = builderImpl.ecBlockHeight;
        this.ecBlockId = builderImpl.ecBlockId;
        PrunablePlainMessageAppendix prunablePlainMessageAppendix = null;
        PrunableEncryptedMessageAppendix prunableEncryptedMessageAppendix = null;
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            switch (abstractAppendix.getAppendixType()) {
                case 8: {
                    prunablePlainMessageAppendix = (PrunablePlainMessageAppendix)abstractAppendix;
                    break;
                }
                case 16: {
                    prunableEncryptedMessageAppendix = (PrunableEncryptedMessageAppendix)abstractAppendix;
                }
            }
        }
        this.prunablePlainMessage = prunablePlainMessageAppendix;
        this.prunableEncryptedMessage = prunableEncryptedMessageAppendix;
    }

    @Override
    public short getDeadline() {
        return this.deadline;
    }

    @Override
    public byte[] getSenderPublicKey() {
        if (this.senderPublicKey == null) {
            this.senderPublicKey = Account.getPublicKey(this.senderId);
        }
        return this.senderPublicKey;
    }

    @Override
    public long getRecipientId() {
        return this.recipientId;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    void setHeight(int n) {
        this.height = n;
    }

    @Override
    public TransactionType getType() {
        return this.type;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public long getBlockId() {
        return this.blockId;
    }

    @Override
    public BlockImpl getBlock() {
        if (this.block == null && this.blockId != 0L) {
            this.block = BlockchainImpl.getInstance().getBlock(this.blockId);
        }
        return this.block;
    }

    void setBlock(BlockImpl blockImpl) {
        this.block = blockImpl;
        this.blockId = blockImpl.getId();
        this.height = blockImpl.getHeight();
        this.blockTimestamp = blockImpl.getTimestamp();
    }

    void unsetBlock() {
        this.block = null;
        this.blockId = 0L;
        this.blockTimestamp = -1;
    }

    @Override
    public short getIndex() {
        if (this.index == -1) {
            throw new IllegalStateException("Transaction index has not been set");
        }
        return this.index;
    }

    void setIndex(int n) {
        this.index = (short)n;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getBlockTimestamp() {
        return this.blockTimestamp;
    }

    @Override
    public int getExpiration() {
        return this.timestamp + this.deadline * 60;
    }

    @Override
    public PrunablePlainMessageAppendix getPrunablePlainMessage() {
        if (this.prunablePlainMessage != null) {
            this.prunablePlainMessage.loadPrunable(this);
        }
        return this.prunablePlainMessage;
    }

    boolean hasPrunablePlainMessage() {
        return this.prunablePlainMessage != null;
    }

    @Override
    public PrunableEncryptedMessageAppendix getPrunableEncryptedMessage() {
        if (this.prunableEncryptedMessage != null) {
            this.prunableEncryptedMessage.loadPrunable(this);
        }
        return this.prunableEncryptedMessage;
    }

    boolean hasPrunableEncryptedMessage() {
        return this.prunableEncryptedMessage != null;
    }

    @Override
    public Attachment.AbstractAttachment getAttachment() {
        this.attachment.loadPrunable(this);
        return this.attachment;
    }

    public List<Appendix.AbstractAppendix> getAppendages() {
        return this.getAppendages(false);
    }

    public List<Appendix.AbstractAppendix> getAppendages(boolean bl) {
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            abstractAppendix.loadPrunable(this, bl);
        }
        return this.appendages;
    }

    public List<Appendix> getAppendages(Filter<Appendix> filter, boolean bl) {
        ArrayList<Appendix> arrayList = new ArrayList<Appendix>();
        this.appendages.forEach(abstractAppendix -> {
            if (filter.ok((Appendix)abstractAppendix)) {
                abstractAppendix.loadPrunable(this, bl);
                arrayList.add((Appendix)abstractAppendix);
            }
        });
        return arrayList;
    }

    List<Appendix.AbstractAppendix> appendages() {
        return this.appendages;
    }

    @Override
    public final long getId() {
        if (this.id == 0L) {
            if (this.getSignature() == null) {
                throw new IllegalStateException("Transaction is not signed yet");
            }
            byte[] byArray = this.zeroSignature(this.getBytes());
            byte[] byArray2 = Crypto.sha256().digest(this.getSignature());
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update(byArray);
            this.fullHash = messageDigest.digest(byArray2);
            BigInteger bigInteger = new BigInteger(1, new byte[]{this.fullHash[7], this.fullHash[6], this.fullHash[5], this.fullHash[4], this.fullHash[3], this.fullHash[2], this.fullHash[1], this.fullHash[0]});
            this.id = bigInteger.longValue();
            this.stringId = this.getChain().getId() + ":" + Convert.toHexString(this.getFullHash());
        }
        return this.id;
    }

    @Override
    public final String getStringId() {
        if (this.stringId == null) {
            this.getId();
            if (this.stringId == null) {
                this.stringId = this.getChain().getId() + ":" + Convert.toHexString(this.getFullHash());
            }
        }
        return this.stringId;
    }

    @Override
    public final byte[] getFullHash() {
        if (this.fullHash == null) {
            this.getId();
        }
        return this.fullHash;
    }

    @Override
    public final long getSenderId() {
        if (this.senderId == 0L) {
            this.senderId = Account.getId(this.getSenderPublicKey());
        }
        return this.senderId;
    }

    @Override
    public final byte[] getBytes() {
        return Arrays.copyOf(this.bytes(), this.bytes.length);
    }

    @Override
    public final byte[] getPrunableBytes() {
        return Arrays.copyOf(this.prunableBytes(), this.prunableBytes.length);
    }

    public final byte[] bytes() {
        if (this.bytes == null) {
            try {
                this.bytes = this.generateBytes(false).array();
            }
            catch (RuntimeException runtimeException) {
                if (this.getSignature() != null) {
                    Logger.logDebugMessage("Failed to get transaction bytes for transaction: " + JSON.toJSONString((JSONAware)this.getJSONObject()));
                }
                throw runtimeException;
            }
        }
        return this.bytes;
    }

    public final byte[] prunableBytes() {
        if (this.prunableBytes == null) {
            try {
                this.prunableBytes = this.generateBytes(true).array();
            }
            catch (RuntimeException runtimeException) {
                if (this.getSignature() != null) {
                    Logger.logDebugMessage("Failed to get transaction bytes for transaction: " + JSON.toJSONString((JSONAware)this.getJSONObject()));
                }
                throw runtimeException;
            }
        }
        return this.prunableBytes;
    }

    ByteBuffer generateBytes(boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(bl ? this.getFullSize() : this.getSize());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(this.getChain().getId());
        byteBuffer.put(this.getType().getType());
        byteBuffer.put(this.getType().getSubtype());
        byteBuffer.put(this.getVersion());
        byteBuffer.putInt(this.getTimestamp());
        byteBuffer.putShort(this.getDeadline());
        byteBuffer.put(this.getSenderPublicKey());
        byteBuffer.putLong(this.getRecipientId());
        byteBuffer.putLong(this.getAmount());
        byteBuffer.putLong(this.getFee());
        byteBuffer.put(this.getSignature() != null ? this.getSignature() : new byte[64]);
        byteBuffer.putInt(this.getECBlockHeight());
        byteBuffer.putLong(this.getECBlockId());
        this.putAppendages(byteBuffer, bl);
        return byteBuffer;
    }

    @Override
    public final byte[] getUnsignedBytes() {
        return this.zeroSignature(this.getBytes());
    }

    @Override
    public JSONObject getJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"chain", (Object)this.getChain().getId());
        jSONObject.put((Object)"type", (Object)this.type.getType());
        jSONObject.put((Object)"subtype", (Object)this.type.getSubtype());
        jSONObject.put((Object)"timestamp", (Object)this.timestamp);
        jSONObject.put((Object)"deadline", (Object)this.deadline);
        jSONObject.put((Object)"senderPublicKey", (Object)Convert.toHexString(this.getSenderPublicKey()));
        if (this.type.canHaveRecipient()) {
            jSONObject.put((Object)"recipient", (Object)Long.toUnsignedString(this.recipientId));
        }
        jSONObject.put((Object)"amountNQT", (Object)this.amount);
        jSONObject.put((Object)"feeNQT", (Object)this.getFee());
        jSONObject.put((Object)"ecBlockHeight", (Object)this.ecBlockHeight);
        jSONObject.put((Object)"ecBlockId", (Object)Long.toUnsignedString(this.ecBlockId));
        jSONObject.put((Object)"signature", (Object)Convert.toHexString(this.getSignature()));
        if (this.getSignature() != null) {
            jSONObject.put((Object)"fullHash", (Object)Convert.toHexString(this.getFullHash()));
        }
        JSONObject jSONObject2 = new JSONObject();
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            abstractAppendix.loadPrunable(this);
            jSONObject2.putAll((Map)abstractAppendix.getJSONObject());
        }
        if (!jSONObject2.isEmpty()) {
            jSONObject.put((Object)"attachment", (Object)jSONObject2);
        }
        jSONObject.put((Object)"version", (Object)this.version);
        return jSONObject;
    }

    @Override
    public JSONObject getPrunableAttachmentJSON() {
        JSONObject jSONObject = null;
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            if (!(abstractAppendix instanceof Appendix.Prunable)) continue;
            abstractAppendix.loadPrunable(this);
            if (jSONObject == null) {
                jSONObject = abstractAppendix.getJSONObject();
                continue;
            }
            jSONObject.putAll((Map)abstractAppendix.getJSONObject());
        }
        return jSONObject;
    }

    @Override
    public int getECBlockHeight() {
        return this.ecBlockHeight;
    }

    @Override
    public long getECBlockId() {
        return this.ecBlockId;
    }

    @Override
    public boolean verifySignature() {
        return this.checkSignature() && Account.setOrVerify(this.getSenderId(), this.getSenderPublicKey());
    }

    private boolean checkSignature() {
        if (!this.hasValidSignature) {
            byte[] byArray = this.getBytes();
            boolean bl = this.hasValidSignature = this.getSignature() != null && Crypto.verify(this.getSignature(), this.zeroSignature(byArray), this.getSenderPublicKey());
            if (!this.hasValidSignature) {
                Logger.logWarningMessage("Invalid signature for transaction bytes " + Convert.toHexString(byArray));
            }
        }
        return this.hasValidSignature;
    }

    int getSize() {
        return 149 + this.appendagesSize;
    }

    @Override
    public final int getFullSize() {
        int n = this.getSize() - this.appendagesSize;
        for (Appendix.AbstractAppendix abstractAppendix : this.getAppendages()) {
            n += abstractAppendix.getFullSize();
        }
        return n;
    }

    private byte[] zeroSignature(byte[] byArray) {
        for (int i = 69; i < 133; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    @Override
    public void validate() throws NxtException.ValidationException {
        if (this.timestamp <= 0 || this.deadline < 1 || this.getFee() < 0L || this.getFee() > 100000000000000000L || this.amount < 0L || this.amount > 100000000000000000L || this.type == null) {
            throw new NxtException.NotValidException("Invalid transaction parameters:\n type: " + this.type + ", timestamp: " + this.timestamp + ", deadline: " + this.deadline + ", fee: " + this.getFee() + ", amount: " + this.amount);
        }
        if (this.attachment == null || this.type != this.attachment.getTransactionType()) {
            throw new NxtException.NotValidException("Invalid attachment " + this.attachment + " for transaction of type " + this.type);
        }
        if (!(this.type.canHaveRecipient() || this.recipientId == 0L && this.getAmount() == 0L)) {
            throw new NxtException.NotValidException("Transactions of this type must have recipient == 0, amount == 0");
        }
        if (this.type.mustHaveRecipient() && this.recipientId == 0L) {
            throw new NxtException.NotValidException("Transactions of this type must have a valid recipient");
        }
        if (this.getSenderId() == Constants.BURN_ACCOUNT_ID) {
            throw new NxtException.NotValidException(String.format("Burn account %s not allowed to send transactions", Convert.rsAccount(this.senderId)));
        }
    }

    void validateId() throws NxtException.ValidationException {
        if (this.getId() == 0L) {
            throw new NxtException.NotValidException("Invalid transaction id 0");
        }
    }

    final void validateEcBlock() throws NxtException.ValidationException {
        if (this.ecBlockId != 0L) {
            if (Nxt.getBlockchain().getHeight() < this.ecBlockHeight) {
                throw new NxtException.NotCurrentlyValidException("ecBlockHeight " + this.ecBlockHeight + " exceeds blockchain height " + Nxt.getBlockchain().getHeight());
            }
            if (BlockDb.findBlockIdAtHeight(this.ecBlockHeight) != this.ecBlockId) {
                throw new NxtException.NotCurrentlyValidException("ecBlockHeight " + this.ecBlockHeight + " does not match ecBlockId " + Long.toUnsignedString(this.ecBlockId) + ", transaction was generated on a fork");
            }
        } else {
            throw new NxtException.NotValidException("To prevent transaction replay attacks, using ecBlockId=0 is no longer allowed.");
        }
    }

    @Override
    public final long getMinimumFeeFQT() {
        if (this.blockId != 0L) {
            return this.getMinimumFeeFQT(this.height - 1);
        }
        return this.getMinimumFeeFQT(Nxt.getBlockchain().getHeight());
    }

    long getMinimumFeeFQT(int n) {
        long l = 0L;
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages) {
            abstractAppendix.loadPrunable(this);
            if (n < abstractAppendix.getBaselineFeeHeight()) {
                return 0L;
            }
            Fee fee = abstractAppendix.getFee(this, n);
            l = Math.addExact(l, fee.getFee(this, abstractAppendix));
        }
        if (!(this.recipientId == 0L || Nxt.getBlockchainProcessor().isScanning() && n < Nxt.getBlockchainProcessor().getInitialScanHeight() - Constants.MAX_ROLLBACK || Account.hasAccount(this.recipientId, n))) {
            l += 100000000L;
        }
        return l;
    }

    abstract boolean hasAllReferencedTransactions(int var1, int var2);

    public abstract boolean attachmentIsPhased();

    public final boolean attachmentIsDuplicate(Map<TransactionType, Map<String, Integer>> map, boolean bl) {
        if (!this.attachmentIsPhased() && !bl) {
            return false;
        }
        if (bl) {
            if (AccountRestrictions.isBlockDuplicate(this, map)) {
                return true;
            }
            if (this.getType().isBlockDuplicate(this, map)) {
                return true;
            }
            if (this.attachmentIsPhased()) {
                return false;
            }
        }
        return this.getType().isDuplicate(this, map);
    }

    final boolean isUnconfirmedDuplicate(Map<TransactionType, Map<String, Integer>> map) {
        return this.getType().isUnconfirmedDuplicate(this, map);
    }

    final boolean applyUnconfirmed() {
        Account account = Account.getAccount(this.getSenderId());
        return account != null && this.getType().applyUnconfirmed(this, account);
    }

    final void undoUnconfirmed() {
        Account account = Account.getAccount(this.getSenderId());
        if (this.getAmount() == 0L && this.getFee() == 0L && account == null) {
            return;
        }
        this.getType().undoUnconfirmed(this, account);
    }

    abstract void apply();

    abstract void save(Connection var1, String var2) throws SQLException;

    abstract UnconfirmedTransaction newUnconfirmedTransaction(long var1, boolean var3);

    public static TransactionImpl parseTransaction(byte[] byArray) throws NxtException.NotValidException {
        TransactionImpl transactionImpl = TransactionImpl.newTransactionBuilder(byArray).build();
        if (transactionImpl.getSignature() != null && !transactionImpl.checkSignature()) {
            throw new NxtException.NotValidException("Invalid transaction signature for transaction " + JSON.toJSONString((JSONAware)transactionImpl.getJSONObject()));
        }
        return transactionImpl;
    }

    public static TransactionImpl parseTransaction(byte[] byArray, JSONObject jSONObject) throws NxtException.NotValidException {
        TransactionImpl transactionImpl = TransactionImpl.newTransactionBuilder(byArray, jSONObject).build();
        if (transactionImpl.getSignature() != null && !transactionImpl.checkSignature()) {
            throw new NxtException.NotValidException("Invalid transaction signature for transaction " + JSON.toJSONString((JSONAware)transactionImpl.getJSONObject()));
        }
        return transactionImpl;
    }

    static TransactionImpl loadTransaction(Chain chain, ResultSet resultSet) throws NxtException.NotValidException {
        try {
            byte by = resultSet.getByte("type");
            byte by2 = resultSet.getByte("subtype");
            int n = resultSet.getInt("timestamp");
            short s = resultSet.getShort("deadline");
            long l = resultSet.getLong("amount");
            long l2 = resultSet.getLong("fee");
            int n2 = resultSet.getInt("ec_block_height");
            long l3 = resultSet.getLong("ec_block_id");
            byte[] byArray = resultSet.getBytes("signature");
            long l4 = resultSet.getLong("block_id");
            int n3 = resultSet.getInt("height");
            long l5 = resultSet.getLong("id");
            long l6 = resultSet.getLong("sender_id");
            byte[] byArray2 = resultSet.getBytes("attachment_bytes");
            int n4 = resultSet.getInt("block_timestamp");
            byte[] byArray3 = resultSet.getBytes("full_hash");
            byte by3 = resultSet.getByte("version");
            short s2 = resultSet.getShort("transaction_index");
            ByteBuffer byteBuffer = null;
            if (byArray2 != null) {
                byteBuffer = ByteBuffer.wrap(byArray2);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            TransactionType transactionType = TransactionType.findTransactionType(by, by2);
            List<Appendix.AbstractAppendix> list = TransactionImpl.getAppendages(transactionType, byteBuffer);
            BuilderImpl builderImpl = chain.newTransactionBuilder(by3, l, l2, s, list, resultSet);
            builderImpl.timestamp(n).signature(byArray).blockId(l4).height(n3).id(l5).senderId(l6).blockTimestamp(n4).fullHash(byArray3).ecBlockHeight(n2).ecBlockId(l3).index(s2);
            if (transactionType.canHaveRecipient()) {
                long l7 = resultSet.getLong("recipient_id");
                if (!resultSet.wasNull()) {
                    builderImpl.recipientId(l7);
                }
            }
            return builderImpl.build();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static BuilderImpl newTransactionBuilder(byte[] byArray) throws NxtException.NotValidException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("newTransactionBuilder"));
        }
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n = byteBuffer.getInt();
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            byte by3 = byteBuffer.get();
            int n2 = byteBuffer.getInt();
            short s = byteBuffer.getShort();
            byte[] byArray2 = new byte[32];
            byteBuffer.get(byArray2);
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            long l3 = byteBuffer.getLong();
            byte[] byArray3 = new byte[64];
            byteBuffer.get(byArray3);
            byArray3 = Convert.emptyToNull(byArray3);
            int n3 = byteBuffer.getInt();
            long l4 = byteBuffer.getLong();
            TransactionType transactionType = TransactionType.findTransactionType(by, by2);
            if (transactionType == null) {
                throw new NxtException.NotValidException("Invalid transaction type: " + by + ", " + by2);
            }
            List<Appendix.AbstractAppendix> list = TransactionImpl.getAppendages(transactionType, byteBuffer);
            BuilderImpl builderImpl = Chain.getChain(n).newTransactionBuilder(by3, byArray2, l2, l3, s, list, byteBuffer);
            builderImpl.timestamp(n2).signature(byArray3).ecBlockHeight(n3).ecBlockId(l4);
            if (transactionType.canHaveRecipient()) {
                builderImpl.recipientId(l);
            }
            if (byteBuffer.hasRemaining()) {
                throw new NxtException.NotValidException("Transaction bytes too long, " + byteBuffer.remaining() + " extra bytes");
            }
            return builderImpl;
        }
        catch (RuntimeException | NxtException.NotValidException exception) {
            Logger.logDebugMessage("Failed to parse transaction bytes: " + Convert.toHexString(byArray));
            throw exception;
        }
    }

    public static BuilderImpl newTransactionBuilder(byte[] byArray, JSONObject jSONObject) throws NxtException.NotValidException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("newTransactionBuilder"));
        }
        BuilderImpl builderImpl = TransactionImpl.newTransactionBuilder(byArray);
        builderImpl.prunableAttachments(jSONObject);
        return builderImpl;
    }

    public static BuilderImpl newTransactionBuilder(JSONObject jSONObject) throws NxtException.NotValidException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("newTransactionBuilder"));
        }
        try {
            int n = ((Long)jSONObject.get((Object)"chain")).intValue();
            byte by = ((Long)jSONObject.get((Object)"type")).byteValue();
            byte by2 = ((Long)jSONObject.get((Object)"subtype")).byteValue();
            int n2 = ((Long)jSONObject.get((Object)"timestamp")).intValue();
            short s = ((Long)jSONObject.get((Object)"deadline")).shortValue();
            byte[] byArray = Convert.parseHexString((String)jSONObject.get((Object)"senderPublicKey"));
            long l = Convert.parseLong(jSONObject.get((Object)"amountNQT"));
            long l2 = Convert.parseLong(jSONObject.get((Object)"feeNQT"));
            byte[] byArray2 = Convert.parseHexString((String)jSONObject.get((Object)"signature"));
            byte by3 = ((Long)jSONObject.get((Object)"version")).byteValue();
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"attachment");
            int n3 = ((Long)jSONObject.get((Object)"ecBlockHeight")).intValue();
            long l3 = Convert.parseUnsignedLong((String)jSONObject.get((Object)"ecBlockId"));
            TransactionType transactionType = TransactionType.findTransactionType(by, by2);
            if (transactionType == null) {
                throw new NxtException.NotValidException("Invalid transaction type: " + by + ", " + by2);
            }
            ArrayList<Appendix.AbstractAppendix> arrayList = new ArrayList<Appendix.AbstractAppendix>();
            arrayList.add(transactionType.parseAttachment(jSONObject2));
            if (jSONObject2 != null) {
                for (Appendix.Parser parser : AppendixParsers.getParsers()) {
                    Appendix.AbstractAppendix abstractAppendix = parser.parse(jSONObject2);
                    if (abstractAppendix == null) continue;
                    arrayList.add(abstractAppendix);
                }
            }
            BuilderImpl builderImpl = Chain.getChain(n).newTransactionBuilder(by3, byArray, l, l2, s, arrayList, jSONObject);
            builderImpl.timestamp(n2).signature(byArray2).ecBlockHeight(n3).ecBlockId(l3);
            if (transactionType.canHaveRecipient()) {
                long l4 = Convert.parseUnsignedLong((String)jSONObject.get((Object)"recipient"));
                builderImpl.recipientId(l4);
            }
            return builderImpl;
        }
        catch (RuntimeException | NxtException.NotValidException exception) {
            Logger.logDebugMessage("Failed to parse transaction: " + JSON.toJSONString((JSONAware)jSONObject));
            throw exception;
        }
    }

    static List<Appendix.AbstractAppendix> getAppendages(TransactionType transactionType, ByteBuffer byteBuffer) throws NxtException.NotValidException {
        if (byteBuffer == null) {
            return Collections.singletonList(transactionType.parseAttachment(byteBuffer));
        }
        int n = byteBuffer.getInt();
        Attachment.AbstractAttachment abstractAttachment = transactionType.parseAttachment(byteBuffer);
        if (n == 0) {
            return Collections.singletonList(abstractAttachment);
        }
        ArrayList<Appendix.AbstractAppendix> arrayList = new ArrayList<Appendix.AbstractAppendix>();
        arrayList.add(abstractAttachment);
        Collection<Appendix.Parser> collection = AppendixParsers.getParsers();
        int n2 = 1;
        for (Appendix.Parser parser : collection) {
            if ((n & n2) != 0) {
                arrayList.add(parser.parse(byteBuffer));
            }
            n2 <<= 1;
        }
        return arrayList;
    }

    void putAppendages(ByteBuffer byteBuffer, boolean bl) {
        int n = 0;
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages()) {
            n |= abstractAppendix.getAppendixType();
        }
        byteBuffer.putInt(n);
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages()) {
            if (bl) {
                abstractAppendix.loadPrunable(this);
                abstractAppendix.putPrunableBytes(byteBuffer);
                continue;
            }
            abstractAppendix.putBytes(byteBuffer);
        }
    }

    public static abstract class BuilderImpl
    implements Transaction.Builder {
        private final short deadline;
        final byte[] senderPublicKey;
        private final long amount;
        private final TransactionType type;
        private final byte version;
        final long fee;
        final int chainId;
        private List<Appendix.AbstractAppendix> appendageList;
        private SortedMap<Integer, Appendix.AbstractAppendix> appendageMap;
        private int appendagesSize;
        private long recipientId;
        byte[] signature;
        private long blockId;
        private int height = Integer.MAX_VALUE;
        private long id;
        long senderId;
        private int timestamp = Integer.MAX_VALUE;
        private int blockTimestamp = -1;
        private byte[] fullHash;
        private boolean ecBlockSet = false;
        private int ecBlockHeight;
        private long ecBlockId;
        private short index = (short)-1;

        private BuilderImpl(int n, byte by, byte[] byArray, long l, long l2, short s, TransactionType transactionType) {
            this.version = by;
            this.deadline = s;
            this.senderPublicKey = byArray;
            this.amount = l;
            this.fee = l2;
            this.chainId = n;
            this.type = transactionType;
        }

        BuilderImpl(int n, byte by, byte[] byArray, long l, long l2, short s, Attachment.AbstractAttachment abstractAttachment) {
            this(n, by, byArray, l, l2, s, abstractAttachment.getTransactionType());
            this.appendageMap = new TreeMap<Integer, Appendix.AbstractAppendix>();
            this.appendageMap.put(abstractAttachment.getAppendixType(), abstractAttachment);
        }

        BuilderImpl(int n, byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list) {
            this(n, by, byArray, l, l2, s, ((Attachment)((Object)list.get(0))).getTransactionType());
            this.appendageList = list;
        }

        final void preBuild(String string, boolean bl) throws NxtException.NotValidException {
            if (this.appendageMap != null) {
                this.appendageList = new ArrayList<Appendix.AbstractAppendix>(this.appendageMap.values());
            }
            if (this.timestamp == Integer.MAX_VALUE) {
                this.timestamp = Nxt.getEpochTime();
            }
            if (!this.ecBlockSet) {
                BlockImpl blockImpl = BlockchainImpl.getInstance().getECBlock(this.timestamp);
                this.ecBlockHeight = blockImpl.getHeight();
                this.ecBlockId = blockImpl.getId();
            }
            int n = 0;
            for (Appendix appendix : this.appendageList) {
                if (string != null && appendix instanceof Appendix.Encryptable) {
                    if (bl) {
                        throw new NxtException.NotValidException("Voucher cannot contain data to encrypt");
                    }
                    ((Appendix.Encryptable)((Object)appendix)).encrypt(string);
                }
                n += appendix.getSize();
            }
            this.appendagesSize = n;
        }

        @Override
        public abstract TransactionImpl build() throws NxtException.NotValidException;

        @Override
        public abstract TransactionImpl build(String var1) throws NxtException.NotValidException;

        @Override
        public final BuilderImpl recipientId(long l) {
            this.recipientId = l;
            return this;
        }

        @Override
        public final BuilderImpl appendix(Appendix appendix) {
            if (appendix != null) {
                if (this.appendageMap == null) {
                    this.appendageMap = new TreeMap<Integer, Appendix.AbstractAppendix>();
                    this.appendageList.forEach(abstractAppendix -> this.appendageMap.put(abstractAppendix.getAppendixType(), (Appendix.AbstractAppendix)abstractAppendix));
                    this.appendageList = null;
                }
                this.appendageMap.put(appendix.getAppendixType(), (Appendix.AbstractAppendix)appendix);
            }
            return this;
        }

        @Override
        public final BuilderImpl timestamp(int n) {
            this.timestamp = n;
            return this;
        }

        @Override
        public final BuilderImpl ecBlockHeight(int n) {
            this.ecBlockHeight = n;
            this.ecBlockSet = true;
            return this;
        }

        @Override
        public final BuilderImpl ecBlockId(long l) {
            this.ecBlockId = l;
            this.ecBlockSet = true;
            return this;
        }

        final BuilderImpl id(long l) {
            this.id = l;
            return this;
        }

        final BuilderImpl signature(byte[] byArray) {
            this.signature = byArray;
            return this;
        }

        final BuilderImpl blockId(long l) {
            this.blockId = l;
            return this;
        }

        public final BuilderImpl height(int n) {
            this.height = n;
            return this;
        }

        final BuilderImpl senderId(long l) {
            this.senderId = l;
            return this;
        }

        final BuilderImpl fullHash(byte[] byArray) {
            this.fullHash = byArray;
            return this;
        }

        final BuilderImpl blockTimestamp(int n) {
            this.blockTimestamp = n;
            return this;
        }

        final BuilderImpl index(short s) {
            this.index = s;
            return this;
        }

        final TransactionType getTransactionType() {
            return this.type;
        }

        final BuilderImpl prunableAttachments(JSONObject jSONObject) throws NxtException.NotValidException {
            if (jSONObject != null) {
                for (Appendix.Parser parser : AppendixParsers.getPrunableParsers()) {
                    this.appendix(parser.parse(jSONObject));
                }
            }
            return this;
        }
    }
}

