/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Appendix;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.BlockchainProcessorImpl;
import nxt.blockchain.ChildBlockFxtTransaction;
import nxt.blockchain.ChildBlockFxtTransactionImpl;
import nxt.blockchain.ChildBlockFxtTransactionType;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.Generator;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionHome;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionProcessor;
import nxt.blockchain.TransactionType;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;
import nxt.dbschema.Db;
import nxt.peer.NetworkHandler;
import nxt.peer.NetworkMessage;
import nxt.peer.TransactionsInventory;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import nxt.util.security.BlockchainPermission;

public final class TransactionProcessorImpl
implements TransactionProcessor {
    private static final boolean enableTransactionRebroadcasting = Nxt.getBooleanProperty("nxt.enableTransactionRebroadcasting");
    private static final boolean testUnconfirmedTransactions = Nxt.getBooleanProperty("nxt.testUnconfirmedTransactions");
    private static final int maxUnconfirmedTransactions;
    private static final TransactionProcessorImpl instance;
    private static final BlockchainPermission blockchainPermission;
    private final Map<DbKey, UnconfirmedTransaction> transactionCache = new HashMap<DbKey, UnconfirmedTransaction>();
    private volatile boolean cacheInitialized = false;
    final DbKey.LongKeyFactory<UnconfirmedTransaction> unconfirmedTransactionDbKeyFactory = new DbKey.LongKeyFactory<UnconfirmedTransaction>("id"){

        @Override
        public DbKey newKey(UnconfirmedTransaction unconfirmedTransaction) {
            return unconfirmedTransaction.getDbKey();
        }
    };
    final EntityDbTable<UnconfirmedTransaction> unconfirmedTransactionTable = new EntityDbTable<UnconfirmedTransaction>("public.unconfirmed_transaction", this.unconfirmedTransactionDbKeyFactory){

        @Override
        protected UnconfirmedTransaction load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return UnconfirmedTransaction.load(resultSet);
        }

        @Override
        protected void save(Connection connection, UnconfirmedTransaction unconfirmedTransaction) throws SQLException {
            unconfirmedTransaction.save(connection);
            if (TransactionProcessorImpl.this.transactionCache.size() < maxUnconfirmedTransactions) {
                TransactionProcessorImpl.this.transactionCache.put(unconfirmedTransaction.getDbKey(), unconfirmedTransaction);
            }
        }

        @Override
        public void popOffTo(int n) {
            try (Connection connection = TransactionProcessorImpl.this.unconfirmedTransactionTable.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM unconfirmed_transaction WHERE height > ?");){
                preparedStatement.setInt(1, n);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        UnconfirmedTransaction unconfirmedTransaction = this.load(connection, resultSet, null);
                        TransactionProcessorImpl.this.waitingTransactions.add(unconfirmedTransaction);
                        TransactionProcessorImpl.this.transactionCache.remove(unconfirmedTransaction.getDbKey());
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
            super.popOffTo(n);
            TransactionProcessorImpl.this.unconfirmedDuplicates.clear();
        }

        @Override
        public void truncate() {
            super.truncate();
            this.clearCache();
        }

        @Override
        protected String defaultSort() {
            return " ORDER BY transaction_height ASC, fee_per_byte DESC, arrival_timestamp ASC, id ASC ";
        }
    };
    private final Set<TransactionImpl> broadcastedTransactions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Listeners<List<? extends Transaction>, TransactionProcessor.Event> transactionListeners = new Listeners();
    private final PriorityQueue<UnconfirmedTransaction> waitingTransactions = new PriorityQueue<UnconfirmedTransaction>((unconfirmedTransaction, unconfirmedTransaction2) -> {
        int n = Boolean.compare(unconfirmedTransaction.getType() == ChildBlockFxtTransactionType.INSTANCE, unconfirmedTransaction2.getType() == ChildBlockFxtTransactionType.INSTANCE);
        if (n != 0) {
            return n;
        }
        n = Boolean.compare(unconfirmedTransaction2.getChain() != FxtChain.FXT, unconfirmedTransaction.getChain() != FxtChain.FXT);
        if (n != 0) {
            return n;
        }
        n = Integer.compare(unconfirmedTransaction2.getHeight(), unconfirmedTransaction.getHeight());
        if (n != 0) {
            return n;
        }
        if (unconfirmedTransaction.getChain() == FxtChain.FXT && unconfirmedTransaction2.getChain() == FxtChain.FXT && (n = Long.compare(unconfirmedTransaction.getFee(), unconfirmedTransaction2.getFee())) != 0) {
            return n;
        }
        n = Boolean.compare(unconfirmedTransaction.isBundled(), unconfirmedTransaction2.isBundled());
        if (n != 0) {
            return n;
        }
        n = Boolean.compare(unconfirmedTransaction2.getReferencedTransactionId() != null, unconfirmedTransaction.getReferencedTransactionId() != null);
        if (n != 0) {
            return n;
        }
        n = Long.compare(unconfirmedTransaction2.getArrivalTimestamp(), unconfirmedTransaction.getArrivalTimestamp());
        if (n != 0) {
            return n;
        }
        return Long.compare(unconfirmedTransaction2.getId(), unconfirmedTransaction.getId());
    }){

        @Override
        public boolean add(UnconfirmedTransaction unconfirmedTransaction) {
            if (!super.add(unconfirmedTransaction)) {
                return false;
            }
            if (this.size() > maxUnconfirmedTransactions) {
                UnconfirmedTransaction unconfirmedTransaction2 = (UnconfirmedTransaction)this.remove();
                Logger.logDebugMessage("Dropped unconfirmed transaction " + unconfirmedTransaction2.getStringId());
            }
            return true;
        }
    };
    private final Map<TransactionType, Map<String, Integer>> unconfirmedDuplicates = new HashMap<TransactionType, Map<String, Integer>>();
    private final Runnable removeUnconfirmedTransactionsThread = () -> {
        block28: {
            try {
                try {
                    if (Nxt.getBlockchainProcessor().isDownloading() && !testUnconfirmedTransactions) {
                        return;
                    }
                    ArrayList<UnconfirmedTransaction> arrayList = new ArrayList<UnconfirmedTransaction>();
                    Throwable object2 = null;
                    try (Iterator<UnconfirmedTransaction> iterator = this.unconfirmedTransactionTable.getManyBy((DbClause)new DbClause.IntClause("expiration", DbClause.Op.LT, Nxt.getEpochTime()), 0, -1, "");){
                        while (((DbIterator)iterator).hasNext()) {
                            arrayList.add((UnconfirmedTransaction)((DbIterator)iterator).next());
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throw throwable;
                    }
                    if (arrayList.size() <= 0) break block28;
                    BlockchainImpl.getInstance().writeLock();
                    try {
                        try {
                            Db.db.beginTransaction();
                            for (UnconfirmedTransaction unconfirmedTransaction : arrayList) {
                                this.removeUnconfirmedTransaction(unconfirmedTransaction.getTransaction());
                            }
                            Db.db.commitTransaction();
                        }
                        catch (Exception exception) {
                            Logger.logErrorMessage(exception.toString(), exception);
                            Db.db.rollbackTransaction();
                            throw exception;
                        }
                        finally {
                            Db.db.endTransaction();
                        }
                    }
                    finally {
                        BlockchainImpl.getInstance().writeUnlock();
                    }
                }
                catch (Exception exception) {
                    Logger.logMessage("Error removing unconfirmed transactions", exception);
                }
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString());
                throwable.printStackTrace();
                System.exit(1);
            }
        }
    };
    private final Runnable rebroadcastTransactionsThread = () -> {
        try {
            try {
                if (Nxt.getBlockchainProcessor().isDownloading() && !testUnconfirmedTransactions) {
                    return;
                }
                ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
                int n = Nxt.getEpochTime();
                for (TransactionImpl transactionImpl : this.broadcastedTransactions) {
                    if (transactionImpl.getExpiration() < n || transactionImpl.getChain().getTransactionHome().hasTransaction(transactionImpl)) {
                        this.broadcastedTransactions.remove(transactionImpl);
                        continue;
                    }
                    if (transactionImpl.getTimestamp() >= n - 30) continue;
                    arrayList.add(transactionImpl);
                    if (arrayList.size() < 10) continue;
                    TransactionsInventory.cacheTransactions(arrayList);
                    NetworkHandler.broadcastMessage(new NetworkMessage.TransactionsInventoryMessage(arrayList));
                    arrayList.clear();
                }
                if (arrayList.size() > 0) {
                    TransactionsInventory.cacheTransactions(arrayList);
                    NetworkHandler.broadcastMessage(new NetworkMessage.TransactionsInventoryMessage(arrayList));
                }
            }
            catch (Exception exception) {
                Logger.logMessage("Error in transaction re-broadcasting thread", exception);
            }
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
    };
    private final Runnable processWaitingTransactionsThread = () -> {
        try {
            try {
                if (Nxt.getBlockchainProcessor().isDownloading() && !testUnconfirmedTransactions) {
                    return;
                }
                this.processWaitingTransactions();
            }
            catch (Exception exception) {
                Logger.logMessage("Error processing waiting transactions", exception);
            }
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
    };
    private static final Comparator<Transaction> peerTransactionComparator;
    private static final Comparator<UnconfirmedTransaction> cachedUnconfirmedTransactionComparator;

    public static TransactionProcessorImpl getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(blockchainPermission);
        }
        return instance;
    }

    public static void init() {
    }

    private TransactionProcessorImpl() {
        if (!Constants.isLightClient) {
            if (!Constants.isOffline) {
                ThreadPool.scheduleThread("RebroadcastTransactions", this.rebroadcastTransactionsThread, 23);
            }
            ThreadPool.scheduleThread("RemoveUnconfirmedTransactions", this.removeUnconfirmedTransactionsThread, 20);
            ThreadPool.scheduleThread("ProcessWaitingTransactions", this.processWaitingTransactionsThread, 1);
        }
    }

    @Override
    public boolean addListener(Listener<List<? extends Transaction>> listener, TransactionProcessor.Event event) {
        return this.transactionListeners.addListener(listener, event);
    }

    @Override
    public boolean removeListener(Listener<List<? extends Transaction>> listener, TransactionProcessor.Event event) {
        return this.transactionListeners.removeListener(listener, event);
    }

    public void notifyListeners(List<? extends Transaction> list, TransactionProcessor.Event event) {
        this.transactionListeners.notify(list, event);
    }

    public DbIterator<UnconfirmedTransaction> getAllUnconfirmedTransactions() {
        return this.unconfirmedTransactionTable.getAll(0, -1);
    }

    public DbIterator<UnconfirmedTransaction> getAllUnconfirmedTransactions(int n, int n2) {
        return this.unconfirmedTransactionTable.getAll(n, n2);
    }

    public DbIterator<UnconfirmedTransaction> getAllUnconfirmedTransactions(String string) {
        return this.unconfirmedTransactionTable.getAll(0, -1, string);
    }

    public DbIterator<UnconfirmedTransaction> getAllUnconfirmedTransactions(int n, int n2, String string) {
        return this.unconfirmedTransactionTable.getAll(n, n2, string);
    }

    public DbIterator<UnconfirmedTransaction> getUnconfirmedFxtTransactions() {
        return this.unconfirmedTransactionTable.getManyBy((DbClause)new DbClause.IntClause("chain_id", FxtChain.FXT.getId()), 0, -1, " ORDER BY transaction_height ASC, fee DESC, arrival_timestamp ASC, id ASC ");
    }

    public DbIterator<UnconfirmedTransaction> getUnconfirmedChildTransactions(ChildChain childChain) {
        return this.unconfirmedTransactionTable.getManyBy((DbClause)new DbClause.IntClause("chain_id", childChain.getId()), 0, -1, " ORDER BY transaction_height ASC, fee_per_byte DESC, arrival_timestamp ASC, id ASC ");
    }

    @Override
    public UnconfirmedTransaction getUnconfirmedTransaction(long l) {
        DbKey dbKey = this.unconfirmedTransactionDbKeyFactory.newKey(l);
        return this.getUnconfirmedTransaction(dbKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnconfirmedTransaction getUnconfirmedTransaction(DbKey dbKey) {
        Nxt.getBlockchain().readLock();
        try {
            UnconfirmedTransaction unconfirmedTransaction = this.transactionCache.get(dbKey);
            if (unconfirmedTransaction != null) {
                UnconfirmedTransaction unconfirmedTransaction2 = unconfirmedTransaction;
                return unconfirmedTransaction2;
            }
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
        return this.unconfirmedTransactionTable.get(dbKey);
    }

    @Override
    public List<Long> getAllUnconfirmedTransactionIds() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Connection connection = this.unconfirmedTransactionTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT id FROM unconfirmed_transaction");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return arrayList;
    }

    @Override
    public UnconfirmedTransaction[] getAllWaitingTransactions() {
        UnconfirmedTransaction[] unconfirmedTransactionArray;
        BlockchainImpl.getInstance().readLock();
        try {
            unconfirmedTransactionArray = this.waitingTransactions.toArray(new UnconfirmedTransaction[this.waitingTransactions.size()]);
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
        Arrays.sort(unconfirmedTransactionArray, this.waitingTransactions.comparator());
        return unconfirmedTransactionArray;
    }

    public Collection<UnconfirmedTransaction> getWaitingTransactions() {
        return Collections.unmodifiableCollection(this.waitingTransactions);
    }

    public TransactionImpl[] getAllBroadcastedTransactions() {
        BlockchainImpl.getInstance().readLock();
        try {
            TransactionImpl[] transactionImplArray = this.broadcastedTransactions.toArray(new TransactionImpl[this.broadcastedTransactions.size()]);
            return transactionImplArray;
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(Transaction transaction) throws NxtException.ValidationException {
        BlockchainImpl.getInstance().writeLock();
        try {
            if (transaction.getChain().getTransactionHome().hasTransaction(transaction)) {
                Logger.logMessage("Transaction " + transaction.getStringId() + " already in blockchain, will not broadcast again");
                return;
            }
            DbKey dbKey = this.unconfirmedTransactionDbKeyFactory.newKey(transaction.getId());
            if (this.getUnconfirmedTransaction(dbKey) != null) {
                if (enableTransactionRebroadcasting) {
                    this.broadcastedTransactions.add((TransactionImpl)transaction);
                    Logger.logMessage("Transaction " + transaction.getStringId() + " already in unconfirmed pool, will re-broadcast");
                } else {
                    Logger.logMessage("Transaction " + transaction.getStringId() + " already in unconfirmed pool, will not broadcast again");
                }
                return;
            }
            transaction.validate();
            UnconfirmedTransaction unconfirmedTransaction = ((TransactionImpl)transaction).newUnconfirmedTransaction(System.currentTimeMillis(), false);
            boolean bl = BlockchainProcessorImpl.getInstance().isProcessingBlock();
            if (bl) {
                this.waitingTransactions.add(unconfirmedTransaction);
                this.broadcastedTransactions.add((TransactionImpl)transaction);
                Logger.logDebugMessage("Will broadcast new transaction later " + transaction.getStringId());
            } else {
                Set<ChildBlockFxtTransactionImpl> set = this.processTransaction(unconfirmedTransaction);
                Logger.logDebugMessage(String.format("Accepted new transaction %s on chain %s", Convert.toHexString(transaction.getFullHash()), transaction.getChain().getName()));
                this.removeUnconfirmedTransactions(set);
                List<Transaction> list = Collections.singletonList(transaction);
                TransactionsInventory.cacheTransactions(list);
                NetworkHandler.broadcastMessage(new NetworkMessage.TransactionsInventoryMessage(list));
                this.transactionListeners.notify(list, TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
                if (enableTransactionRebroadcasting) {
                    this.broadcastedTransactions.add((TransactionImpl)transaction);
                }
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    @Override
    public void broadcastLater(Transaction transaction) {
        this.broadcastedTransactions.add((TransactionImpl)transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearUnconfirmedTransactions() {
        BlockchainImpl.getInstance().writeLock();
        try {
            ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
            try {
                Db.db.beginTransaction();
                try (DbIterator<UnconfirmedTransaction> dbIterator = this.getAllUnconfirmedTransactions();){
                    for (UnconfirmedTransaction unconfirmedTransaction : dbIterator) {
                        unconfirmedTransaction.getTransaction().undoUnconfirmed();
                        arrayList.add(unconfirmedTransaction.getTransaction());
                    }
                }
                this.unconfirmedTransactionTable.truncate();
                Db.db.commitTransaction();
            }
            catch (Exception exception) {
                Logger.logErrorMessage(exception.toString(), exception);
                Db.db.rollbackTransaction();
                throw exception;
            }
            finally {
                Db.db.endTransaction();
            }
            this.unconfirmedDuplicates.clear();
            this.waitingTransactions.clear();
            this.broadcastedTransactions.clear();
            this.transactionCache.clear();
            if (!arrayList.isEmpty()) {
                this.transactionListeners.notify(arrayList, TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS);
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requeueAllUnconfirmedTransactions() {
        BlockchainImpl.getInstance().writeLock();
        try {
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    this.requeueAllUnconfirmedTransactions();
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Logger.logErrorMessage(exception.toString(), exception);
                    Db.db.rollbackTransaction();
                    throw exception;
                }
                finally {
                    Db.db.endTransaction();
                }
                return;
            }
            ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
            try (DbIterator<UnconfirmedTransaction> dbIterator = this.getAllUnconfirmedTransactions();){
                for (UnconfirmedTransaction unconfirmedTransaction : dbIterator) {
                    unconfirmedTransaction.getTransaction().undoUnconfirmed();
                    if (arrayList.size() < maxUnconfirmedTransactions) {
                        arrayList.add(unconfirmedTransaction.getTransaction());
                    }
                    this.waitingTransactions.add(unconfirmedTransaction);
                }
            }
            this.unconfirmedTransactionTable.truncate();
            this.unconfirmedDuplicates.clear();
            this.transactionCache.clear();
            if (!arrayList.isEmpty()) {
                this.transactionListeners.notify(arrayList, TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS);
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebroadcastAllUnconfirmedTransactions() {
        BlockchainImpl.getInstance().writeLock();
        try (DbIterator<UnconfirmedTransaction> dbIterator = this.getAllUnconfirmedTransactions();){
            for (UnconfirmedTransaction unconfirmedTransaction : dbIterator) {
                if (unconfirmedTransaction.getTransaction().isUnconfirmedDuplicate(this.unconfirmedDuplicates)) {
                    Logger.logDebugMessage("Skipping duplicate unconfirmed transaction " + unconfirmedTransaction.getTransaction().getJSONObject().toString());
                    continue;
                }
                if (!enableTransactionRebroadcasting) continue;
                this.broadcastedTransactions.add(unconfirmedTransaction.getTransaction());
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnconfirmedTransactions(Collection<? extends TransactionImpl> collection) {
        BlockchainImpl.getInstance().writeLock();
        try {
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    this.removeUnconfirmedTransactions(collection);
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Logger.logErrorMessage(exception.toString(), exception);
                    Db.db.rollbackTransaction();
                    throw exception;
                }
                finally {
                    Db.db.endTransaction();
                }
                return;
            }
            collection.forEach(this::removeUnconfirmedTransaction);
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    void removeUnconfirmedTransaction(TransactionImpl transactionImpl) {
        block47: {
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    this.removeUnconfirmedTransaction(transactionImpl);
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Logger.logErrorMessage(exception.toString(), exception);
                    Db.db.rollbackTransaction();
                    throw exception;
                }
                finally {
                    Db.db.endTransaction();
                }
                return;
            }
            try (Connection connection = this.unconfirmedTransactionTable.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM unconfirmed_transaction WHERE id = ?");){
                preparedStatement.setLong(1, transactionImpl.getId());
                int n = preparedStatement.executeUpdate();
                if (n <= 0) break block47;
                transactionImpl.undoUnconfirmed();
                DbKey dbKey = this.unconfirmedTransactionDbKeyFactory.newKey(transactionImpl.getId());
                this.transactionCache.remove(dbKey);
                this.transactionListeners.notify(Collections.singletonList(transactionImpl), TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS);
                if (transactionImpl.getChain() == FxtChain.FXT) break block47;
                try (DbIterator<UnconfirmedTransaction> dbIterator = this.getUnconfirmedFxtTransactions();){
                    while (dbIterator.hasNext()) {
                        byte[][] byArray;
                        TransactionImpl transactionImpl2 = dbIterator.next().getTransaction();
                        if (!(transactionImpl2 instanceof ChildBlockFxtTransactionImpl) || ((ChildBlockFxtTransactionImpl)transactionImpl2).getChildChain() != transactionImpl.getChain()) continue;
                        for (byte[] byArray2 : byArray = ((ChildBlockFxtTransactionImpl)transactionImpl2).getChildTransactionFullHashes()) {
                            if (!Arrays.equals(byArray2, transactionImpl.getFullHash())) continue;
                            this.removeUnconfirmedTransaction(transactionImpl2);
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.logErrorMessage(sQLException.toString(), sQLException);
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processLater(Collection<? extends FxtTransaction> collection) {
        long l = System.currentTimeMillis();
        BlockchainImpl.getInstance().writeLock();
        try {
            collection.forEach(fxtTransaction -> {
                FxtTransactionImpl fxtTransactionImpl = (FxtTransactionImpl)fxtTransaction;
                if (!TransactionHome.hasFxtTransaction(fxtTransactionImpl.getId(), Integer.MAX_VALUE)) {
                    boolean bl = true;
                    if (fxtTransactionImpl instanceof ChildBlockFxtTransactionImpl) {
                        TransactionHome transactionHome = ((ChildBlockFxtTransactionImpl)fxtTransactionImpl).getChildChain().getTransactionHome();
                        for (ChildTransactionImpl childTransactionImpl : fxtTransactionImpl.getChildTransactions()) {
                            if (!transactionHome.hasTransaction(childTransactionImpl)) {
                                childTransactionImpl.unsetBlock();
                                this.waitingTransactions.add(childTransactionImpl.newUnconfirmedTransaction(Math.min(l, Convert.fromEpochTime(childTransactionImpl.getTimestamp())), true));
                                continue;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        fxtTransactionImpl.unsetBlock();
                        this.waitingTransactions.add(fxtTransactionImpl.newUnconfirmedTransaction(Math.min(l, Convert.fromEpochTime(fxtTransactionImpl.getTimestamp())), true));
                    }
                }
            });
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processWaitingTransactions() {
        BlockchainImpl.getInstance().writeLock();
        try {
            if (this.unconfirmedTransactionTable.getCount() / 2 > maxUnconfirmedTransactions) {
                Logger.logDebugMessage("Unconfirmed transaction table size exceeded twice the maximum allowed, re-queueing");
                this.requeueAllUnconfirmedTransactions();
            }
            if (this.waitingTransactions.size() > 0) {
                int n = Nxt.getEpochTime();
                ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
                boolean bl = false;
                while (true) {
                    Iterator<UnconfirmedTransaction> iterator = this.waitingTransactions.iterator();
                    while (iterator.hasNext()) {
                        UnconfirmedTransaction unconfirmedTransaction = iterator.next();
                        if (!bl && unconfirmedTransaction.getType() == ChildBlockFxtTransactionType.INSTANCE) continue;
                        try {
                            unconfirmedTransaction.validate();
                            this.processTransaction(unconfirmedTransaction);
                            iterator.remove();
                            arrayList.add(unconfirmedTransaction.getTransaction());
                        }
                        catch (NxtException.ExistingTransactionException existingTransactionException) {
                            iterator.remove();
                        }
                        catch (NxtException.NotCurrentlyValidException notCurrentlyValidException) {
                            if (unconfirmedTransaction.getExpiration() >= n && n - Convert.toEpochTime(unconfirmedTransaction.getArrivalTimestamp()) <= 3600) continue;
                            iterator.remove();
                        }
                        catch (RuntimeException | NxtException.ValidationException exception) {
                            iterator.remove();
                        }
                    }
                    if (bl) break;
                    bl = true;
                }
                if (arrayList.size() > 0) {
                    this.transactionListeners.notify(arrayList, TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
                }
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    public List<TransactionImpl> processPeerTransactions(List<Transaction> list) throws NxtException.NotValidException {
        if (Nxt.getBlockchain().getHeight() <= Constants.LAST_KNOWN_BLOCK && !testUnconfirmedTransactions) {
            return Collections.emptyList();
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        list.sort(peerTransactionComparator);
        long l = System.currentTimeMillis();
        ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
        ArrayList<TransactionImpl> arrayList2 = new ArrayList<TransactionImpl>();
        ArrayList<TransactionImpl> arrayList3 = new ArrayList<TransactionImpl>();
        ArrayList<Exception> arrayList4 = new ArrayList<Exception>();
        HashSet<ChildBlockFxtTransactionImpl> hashSet = new HashSet<ChildBlockFxtTransactionImpl>();
        for (Transaction transaction : list) {
            try {
                TransactionImpl transactionImpl = (TransactionImpl)transaction;
                arrayList.add(transactionImpl);
                UnconfirmedTransaction unconfirmedTransaction = transactionImpl.newUnconfirmedTransaction(l, false);
                unconfirmedTransaction.validate();
                hashSet.addAll(this.processTransaction(unconfirmedTransaction));
                if (this.broadcastedTransactions.contains(transactionImpl)) {
                    Logger.logDebugMessage("Received back transaction " + transactionImpl.getStringId() + " that we broadcasted, will not forward again to peers");
                } else {
                    arrayList2.add(transactionImpl);
                }
                arrayList3.add(transactionImpl);
            }
            catch (NxtException.NotCurrentlyValidException notCurrentlyValidException) {
            }
            catch (RuntimeException | NxtException.ValidationException exception) {
                Logger.logDebugMessage(String.format("Invalid transaction from peer: %s", transaction.getJSONObject()), exception);
                arrayList4.add(exception);
            }
        }
        this.removeUnconfirmedTransactions(hashSet);
        if (!arrayList2.isEmpty()) {
            NetworkHandler.broadcastMessage(new NetworkMessage.TransactionsInventoryMessage(arrayList2));
        }
        if (!arrayList3.isEmpty()) {
            this.transactionListeners.notify(arrayList3, TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
        }
        this.broadcastedTransactions.removeAll(arrayList);
        if (!arrayList4.isEmpty()) {
            throw new NxtException.NotValidException("Peer sends invalid transactions: " + ((Object)arrayList4).toString());
        }
        return arrayList3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ChildBlockFxtTransactionImpl> processTransaction(UnconfirmedTransaction unconfirmedTransaction) throws NxtException.ValidationException {
        long l;
        TransactionImpl transactionImpl = unconfirmedTransaction.getTransaction();
        int n = Nxt.getEpochTime();
        if (transactionImpl.getExpiration() < n) {
            throw new NxtException.NotCurrentlyValidException("Expired transaction");
        }
        int n2 = n + 15;
        if (transactionImpl.getType() == ChildBlockFxtTransactionType.INSTANCE && (l = Generator.getNextHitTime(Nxt.getBlockchain().getLastBlock().getId(), n)) > 0L && l < (long)n) {
            n2 = (int)l + 15;
        }
        if (transactionImpl.getTimestamp() > n2) {
            throw new NxtException.NotCurrentlyValidException("Transaction timestamp from the future");
        }
        if (transactionImpl.getVersion() < 1) {
            throw new NxtException.NotValidException("Invalid transaction version");
        }
        Set<ChildBlockFxtTransactionImpl> set = Collections.emptySet();
        BlockchainImpl.getInstance().writeLock();
        try {
            try {
                Db.db.beginTransaction();
                if (Nxt.getBlockchain().getHeight() < Constants.LAST_KNOWN_BLOCK && !testUnconfirmedTransactions) {
                    throw new NxtException.NotCurrentlyValidException("Blockchain not ready to accept transactions");
                }
                if (this.getUnconfirmedTransaction(unconfirmedTransaction.getDbKey()) != null || transactionImpl.getChain().getTransactionHome().hasTransaction(transactionImpl)) {
                    throw new NxtException.ExistingTransactionException("Transaction already processed");
                }
                transactionImpl.validateId();
                if (!transactionImpl.verifySignature()) {
                    if (Account.getAccount(transactionImpl.getSenderId()) != null) {
                        throw new NxtException.NotValidException("Transaction signature verification failed");
                    }
                    throw new NxtException.NotCurrentlyValidException("Unknown transaction sender");
                }
                if (transactionImpl.getType() == ChildBlockFxtTransactionType.INSTANCE) {
                    set = new HashSet<ChildBlockFxtTransactionImpl>(this.findDisplacedChildBlockTransactions((ChildBlockFxtTransactionImpl)transactionImpl));
                }
                if (!transactionImpl.applyUnconfirmed()) {
                    throw new NxtException.InsufficientBalanceException("Insufficient balance");
                }
                if (transactionImpl.isUnconfirmedDuplicate(this.unconfirmedDuplicates)) {
                    throw new NxtException.NotCurrentlyValidException("Duplicate unconfirmed transaction");
                }
                this.unconfirmedTransactionTable.insert(unconfirmedTransaction);
                Db.db.commitTransaction();
            }
            catch (Exception exception) {
                Db.db.rollbackTransaction();
                throw exception;
            }
            finally {
                Db.db.endTransaction();
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
        return set;
    }

    private List<ChildBlockFxtTransactionImpl> findDisplacedChildBlockTransactions(ChildBlockFxtTransactionImpl childBlockFxtTransactionImpl) throws NxtException.NotCurrentlyValidException {
        ArrayList<ChildBlockFxtTransactionImpl> arrayList = new ArrayList<ChildBlockFxtTransactionImpl>();
        try (DbIterator<UnconfirmedTransaction> dbIterator = this.getUnconfirmedFxtTransactions();){
            while (dbIterator.hasNext()) {
                FxtTransaction fxtTransaction = (FxtTransaction)((Object)dbIterator.next().getTransaction());
                if (fxtTransaction.getType() != ChildBlockFxtTransactionType.INSTANCE || ((ChildBlockFxtTransaction)fxtTransaction).getChildChain() != childBlockFxtTransactionImpl.getChildChain()) continue;
                try {
                    fxtTransaction.validate();
                }
                catch (NxtException.ValidationException validationException) {
                    continue;
                }
                if (fxtTransaction.getFee() >= childBlockFxtTransactionImpl.getFee()) {
                    if (!((ChildBlockFxtTransactionImpl)fxtTransaction).containsAll(childBlockFxtTransactionImpl.getChildTransactions())) continue;
                    throw new NxtException.NotCurrentlyValidException("A ChildBlockTransaction with same or higher fee and including the same child transactions is already in the pool");
                }
                if (!childBlockFxtTransactionImpl.containsAll(fxtTransaction.getChildTransactions())) continue;
                arrayList.add((ChildBlockFxtTransactionImpl)fxtTransaction);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<? extends Transaction> getCachedUnconfirmedTransactions(List<Long> list) {
        TreeSet<UnconfirmedTransaction> treeSet = new TreeSet<UnconfirmedTransaction>(cachedUnconfirmedTransactionComparator);
        Nxt.getBlockchain().readLock();
        try {
            Map<DbKey, UnconfirmedTransaction> map = this.transactionCache;
            synchronized (map) {
                if (!this.cacheInitialized) {
                    DbIterator<UnconfirmedTransaction> dbIterator = this.getAllUnconfirmedTransactions();
                    while (dbIterator.hasNext()) {
                        UnconfirmedTransaction unconfirmedTransaction2 = dbIterator.next();
                        this.transactionCache.put(unconfirmedTransaction2.getDbKey(), unconfirmedTransaction2);
                    }
                    this.cacheInitialized = true;
                }
            }
            this.transactionCache.values().forEach(unconfirmedTransaction -> {
                if (Collections.binarySearch(list, unconfirmedTransaction.getId()) < 0) {
                    treeSet.add((UnconfirmedTransaction)unconfirmedTransaction);
                }
            });
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transaction> restorePrunableData(List<Transaction> list) {
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>();
        Nxt.getBlockchain().readLock();
        try {
            Db.db.beginTransaction();
            try {
                for (Transaction transaction : list) {
                    TransactionImpl transactionImpl = (TransactionImpl)transaction;
                    TransactionImpl transactionImpl2 = transactionImpl.getChain().getTransactionHome().findTransaction(transactionImpl.getFullHash());
                    if (transactionImpl2 == null) continue;
                    boolean bl = true;
                    block9: for (Appendix.AbstractAppendix abstractAppendix : transactionImpl.getAppendages()) {
                        if (!(abstractAppendix instanceof Appendix.Prunable)) continue;
                        for (Appendix.AbstractAppendix abstractAppendix2 : transactionImpl2.getAppendages()) {
                            if (abstractAppendix2.getClass() != abstractAppendix.getClass()) continue;
                            abstractAppendix2.loadPrunable(transactionImpl2, true);
                            if (!((Appendix.Prunable)((Object)abstractAppendix2)).hasPrunableData()) break;
                            Logger.logDebugMessage(String.format("Already have prunable data for transaction %s %s appendage", transactionImpl2.getStringId(), abstractAppendix2.getAppendixName()));
                            continue block9;
                        }
                        if (((Appendix.Prunable)((Object)abstractAppendix)).hasPrunableData()) {
                            Logger.logDebugMessage(String.format("Loading prunable data for transaction %s %s appendage", Long.toUnsignedString(transactionImpl.getId()), abstractAppendix.getAppendixName()));
                            ((Appendix.Prunable)((Object)abstractAppendix)).restorePrunableData(transactionImpl, transactionImpl2.getBlockTimestamp(), transactionImpl2.getHeight());
                            continue;
                        }
                        bl = false;
                    }
                    if (bl) {
                        arrayList.add(transactionImpl2);
                    }
                    Db.db.clearCache();
                    Db.db.commitTransaction();
                }
                Db.db.commitTransaction();
            }
            catch (Exception exception) {
                Db.db.rollbackTransaction();
                arrayList.clear();
                throw exception;
            }
            finally {
                Db.db.endTransaction();
            }
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
        return arrayList;
    }

    static {
        int n = Nxt.getIntProperty("nxt.maxUnconfirmedTransactions");
        maxUnconfirmedTransactions = n <= 0 ? Integer.MAX_VALUE : n;
        instance = new TransactionProcessorImpl();
        blockchainPermission = new BlockchainPermission("getTransactionProcessor");
        peerTransactionComparator = (transaction, transaction2) -> Boolean.compare(transaction2.getType() != ChildBlockFxtTransactionType.INSTANCE, transaction.getType() != ChildBlockFxtTransactionType.INSTANCE);
        cachedUnconfirmedTransactionComparator = (unconfirmedTransaction, unconfirmedTransaction2) -> {
            int n = Integer.compare(unconfirmedTransaction.getHeight(), unconfirmedTransaction2.getHeight());
            if (n != 0) {
                return n;
            }
            n = Boolean.compare(unconfirmedTransaction.isBundled(), unconfirmedTransaction2.isBundled());
            if (n != 0) {
                return -n;
            }
            n = Long.compare(unconfirmedTransaction.getArrivalTimestamp(), unconfirmedTransaction2.getArrivalTimestamp());
            if (n != 0) {
                return n;
            }
            return Long.compare(unconfirmedTransaction.getId(), unconfirmedTransaction2.getId());
        };
    }
}

