/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Attachment;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import org.json.simple.JSONObject;

public abstract class TransactionType {
    public static TransactionType findTransactionType(byte by, byte by2) {
        if (by < 0) {
            return FxtTransactionType.findTransactionType(by, by2);
        }
        return ChildTransactionType.findTransactionType(by, by2);
    }

    TransactionType() {
    }

    public abstract byte getType();

    public abstract byte getSubtype();

    public abstract AccountLedger.LedgerEvent getLedgerEvent();

    public abstract Attachment.AbstractAttachment parseAttachment(ByteBuffer var1) throws NxtException.NotValidException;

    public abstract Attachment.AbstractAttachment parseAttachment(JSONObject var1) throws NxtException.NotValidException;

    public abstract void validateAttachment(Transaction var1) throws NxtException.ValidationException;

    public abstract boolean applyUnconfirmed(TransactionImpl var1, Account var2);

    public abstract boolean applyAttachmentUnconfirmed(Transaction var1, Account var2);

    public abstract void apply(TransactionImpl var1, Account var2, Account var3);

    public abstract void applyAttachment(Transaction var1, Account var2, Account var3);

    public abstract void undoUnconfirmed(TransactionImpl var1, Account var2);

    public abstract void undoAttachmentUnconfirmed(Transaction var1, Account var2);

    public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        return false;
    }

    public boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        return false;
    }

    public boolean isUnconfirmedDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        return false;
    }

    public static boolean isDuplicate(TransactionType transactionType, String string, Map<TransactionType, Map<String, Integer>> map, boolean bl) {
        return TransactionType.isDuplicate(transactionType, string, map, bl ? 0 : Integer.MAX_VALUE);
    }

    protected static boolean isDuplicate(TransactionType transactionType2, String string, Map<TransactionType, Map<String, Integer>> map, int n) {
        Map map2 = map.computeIfAbsent(transactionType2, transactionType -> new HashMap());
        Integer n2 = (Integer)map2.get(string);
        if (n2 == null) {
            map2.put(string, n > 0 ? 1 : 0);
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 < n) {
            map2.put(string, n2 + 1);
            return false;
        }
        return true;
    }

    public boolean isPruned(Chain chain, byte[] byArray) {
        return false;
    }

    public abstract boolean canHaveRecipient();

    public boolean mustHaveRecipient() {
        return this.canHaveRecipient();
    }

    public abstract boolean isPhasingSafe();

    public boolean isPhasable() {
        return true;
    }

    public abstract boolean isGlobal();

    public abstract Fee getBaselineFee(Transaction var1);

    public Fee getNextFee(Transaction transaction) {
        return this.getBaselineFee(transaction);
    }

    public int getBaselineFeeHeight() {
        return 0;
    }

    public int getNextFeeHeight() {
        return Integer.MAX_VALUE;
    }

    public abstract String getName();

    public final String toString() {
        return this.getName() + " type: " + this.getType() + ", subtype: " + this.getSubtype();
    }

    protected abstract void validateId(Transaction var1) throws NxtException.ValidationException;
}

