/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nxt.NxtException;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.blockchain.UnconfirmedTransaction;

final class UnconfirmedFxtTransaction
extends UnconfirmedTransaction
implements FxtTransaction {
    UnconfirmedFxtTransaction(FxtTransactionImpl fxtTransactionImpl, long l) {
        super(fxtTransactionImpl, l, true);
    }

    UnconfirmedFxtTransaction(ResultSet resultSet) throws SQLException, NxtException.NotValidException {
        super(TransactionImpl.newTransactionBuilder(resultSet.getBytes("transaction_bytes")), resultSet);
    }

    @Override
    public FxtTransactionImpl getTransaction() {
        return (FxtTransactionImpl)super.getTransaction();
    }

    @Override
    public Collection<? extends ChildTransaction> getChildTransactions() {
        return this.getTransaction().getChildTransactions();
    }

    @Override
    public List<? extends ChildTransaction> getSortedChildTransactions() {
        return this.getTransaction().getSortedChildTransactions();
    }

    @Override
    public void setChildTransactions(List<? extends ChildTransaction> list, byte[] byArray) throws NxtException.NotValidException {
        this.getTransaction().setChildTransactions(list, byArray);
    }

    @Override
    public void validate() throws NxtException.ValidationException {
        super.validate();
        if (!this.getChildTransactions().isEmpty()) {
            HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
            for (ChildTransactionImpl childTransactionImpl : this.getTransaction().getChildTransactions()) {
                if (!childTransactionImpl.attachmentIsDuplicate(hashMap, true)) continue;
                throw new NxtException.NotValidException("ChildBlock transaction " + this.getTransaction().getStringId() + " includes child transactions that are duplicates");
            }
        }
    }
}

