/*
 * Decompiled with CFR 0.152.
 */
package nxt.ce;

import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.Map;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.ce.CoinExchange;
import nxt.ce.OrderCancelAttachment;
import nxt.ce.OrderIssueAttachment;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class CoinExchangeTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_COIN_EXCHANGE_ORDER_ISSUE = 0;
    private static final byte SUBTYPE_COIN_EXCHANGE_ORDER_CANCEL = 1;
    public static final TransactionType ORDER_ISSUE = new CoinExchangeTransactionType(){

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.COIN_EXCHANGE_ORDER_ISSUE;
        }

        @Override
        public String getName() {
            return "CoinExchangeOrderIssue";
        }

        @Override
        public OrderIssueAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new OrderIssueAttachment(byteBuffer);
        }

        @Override
        public OrderIssueAttachment parseAttachment(JSONObject jSONObject) throws NxtException.NotValidException {
            return new OrderIssueAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)childTransactionImpl.getAttachment();
            BalanceHome.Balance balance = orderIssueAttachment.getChain().getBalanceHome().getBalance(account.getId());
            long l = Convert.unitRateToAmount(orderIssueAttachment.getQuantityQNT(), orderIssueAttachment.getExchangeChain().getDecimals(), orderIssueAttachment.getPriceNQT(), orderIssueAttachment.getChain().getDecimals()) + 1L;
            if (balance.getUnconfirmedBalance() >= l) {
                balance.addToUnconfirmedBalance(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), -l);
                return true;
            }
            return false;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)childTransactionImpl.getAttachment();
            BalanceHome.Balance balance = orderIssueAttachment.getChain().getBalanceHome().getBalance(account.getId());
            long l = Convert.unitRateToAmount(orderIssueAttachment.getQuantityQNT(), orderIssueAttachment.getExchangeChain().getDecimals(), orderIssueAttachment.getPriceNQT(), orderIssueAttachment.getChain().getDecimals()) + 1L;
            balance.addToUnconfirmedBalance(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), l);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)childTransactionImpl.getAttachment();
            CoinExchange.addOrder(childTransactionImpl, orderIssueAttachment);
        }

        @Override
        public final void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)childTransactionImpl.getAttachment();
            long l = orderIssueAttachment.getQuantityQNT();
            long l2 = orderIssueAttachment.getPriceNQT();
            Chain chain = orderIssueAttachment.getChain();
            Chain chain2 = orderIssueAttachment.getExchangeChain();
            if (l <= 0L || l > 100000000000000000L || l2 <= 0L || l2 > 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid coin exchange order: " + orderIssueAttachment.getJSONObject());
            }
            if (childTransactionImpl.getChain() != chain) {
                throw new NxtException.NotValidException("Coin exchange order for chain " + orderIssueAttachment.getChain().getName() + " was submitted on chain " + childTransactionImpl.getChain().getName());
            }
            if (chain == chain2) {
                throw new NxtException.NotValidException("Coin exchange order chain and exchange chain must be different: " + orderIssueAttachment.getJSONObject());
            }
            long l3 = Convert.unitRateToAmount(l, chain2.getDecimals(), l2, chain.getDecimals());
            if (l3 == 0L) {
                throw new NxtException.NotValidException("Coin exchange order has no value: " + orderIssueAttachment.getJSONObject());
            }
            long l4 = BigDecimal.ONE.divide(new BigDecimal(l2).movePointLeft(chain.getDecimals()), MathContext.DECIMAL128).movePointRight(chain2.getDecimals()).longValue();
            if (l4 == 0L) {
                throw new NxtException.NotValidException("Coin exchange order has no value: " + orderIssueAttachment.getJSONObject());
            }
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (CoinExchange.getOrder(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate coin exchange order id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public final boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType ORDER_CANCEL = new CoinExchangeTransactionType(){

        @Override
        public final byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.COIN_EXCHANGE_ORDER_CANCEL;
        }

        @Override
        public String getName() {
            return "CoinExchangeOrderCancel";
        }

        @Override
        public OrderCancelAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new OrderCancelAttachment(byteBuffer);
        }

        @Override
        public OrderCancelAttachment parseAttachment(JSONObject jSONObject) {
            return new OrderCancelAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public boolean isUnconfirmedDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            OrderCancelAttachment orderCancelAttachment = (OrderCancelAttachment)transaction.getAttachment();
            return TransactionType.isDuplicate(ORDER_CANCEL, Long.toUnsignedString(orderCancelAttachment.getOrderId()), map, true);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            OrderCancelAttachment orderCancelAttachment = (OrderCancelAttachment)childTransactionImpl.getAttachment();
            CoinExchange.Order order = CoinExchange.getOrder(orderCancelAttachment.getOrderId());
            if (order != null) {
                CoinExchange.removeOrder(orderCancelAttachment.getOrderId());
                BalanceHome.Balance balance = Chain.getChain(order.getChainId()).getBalanceHome().getBalance(account.getId());
                balance.addToUnconfirmedBalance(AccountLedger.LedgerEvent.COIN_EXCHANGE_ORDER_CANCEL, AccountLedger.newEventId(childTransactionImpl), order.getAmountNQT());
            }
        }

        @Override
        public final void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            OrderCancelAttachment orderCancelAttachment = (OrderCancelAttachment)childTransactionImpl.getAttachment();
            CoinExchange.Order order = CoinExchange.getOrder(orderCancelAttachment.getOrderId());
            if (order == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid coin exchange order: " + Long.toUnsignedString(orderCancelAttachment.getOrderId()));
            }
            if (order.getAccountId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotValidException("Order " + Long.toUnsignedString(order.getId()) + " was created by account " + Convert.rsAccount(order.getAccountId()));
            }
            if (childTransactionImpl.getChain().getId() != order.getChainId()) {
                throw new NxtException.NotValidException("Coin exchange order cancellation for order on chain " + Chain.getChain(order.getChainId()).getName() + " was submitted on chain " + childTransactionImpl.getChain().getName());
            }
        }

        @Override
        public final boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return true;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return ORDER_ISSUE;
            }
            case 1: {
                return ORDER_CANCEL;
            }
        }
        return null;
    }

    private CoinExchangeTransactionType() {
    }

    @Override
    public final byte getType() {
        return 11;
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }
}

