/*
 * Decompiled with CFR 0.152.
 */
package nxt.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nxt.configuration.SubSystem;

public interface Setup {
    public static final Setup FULL_NODE = new Setup(){
        private List<SubSystem> initSequence = Arrays.asList(SubSystem.LOGGER, SubSystem.SYSTEM_TRAY, SubSystem.DB, SubSystem.BLOCKCHAIN, SubSystem.PEER_NETWORKING, SubSystem.ADDONS, SubSystem.THREAD_POOL, SubSystem.API_SERVER, SubSystem.RANDOMIZATION, SubSystem.DESKTOP_WALLET);
        private List<SubSystem> shutdownSequence = Arrays.asList(SubSystem.DESKTOP_WALLET, SubSystem.ADDONS, SubSystem.RANDOMIZATION, SubSystem.API_SERVER, SubSystem.THREAD_POOL, SubSystem.BLOCKCHAIN, SubSystem.PEER_NETWORKING, SubSystem.DB, SubSystem.LOGGER, SubSystem.SYSTEM_TRAY);

        @Override
        public List<SubSystem> initSequence() {
            return this.initSequence;
        }

        @Override
        public List<SubSystem> shutdownSequence() {
            return this.shutdownSequence;
        }
    };
    public static final Setup COMMAND_LINE_TOOL = new Setup(){
        List<SubSystem> subSystems = Arrays.asList(SubSystem.LOGGER, SubSystem.DB, SubSystem.BLOCKCHAIN, SubSystem.THREAD_POOL, SubSystem.API_SERVER);

        @Override
        public List<SubSystem> initSequence() {
            return this.subSystems;
        }

        @Override
        public List<SubSystem> shutdownSequence() {
            ArrayList<SubSystem> arrayList = new ArrayList<SubSystem>(this.subSystems);
            Collections.reverse(arrayList);
            return arrayList;
        }
    };
    public static final Setup UNIT_TEST = new Setup(){
        private List<SubSystem> initSequence = Arrays.asList(SubSystem.LOGGER, SubSystem.DB, SubSystem.BLOCKCHAIN, SubSystem.PEER_NETWORKING, SubSystem.ADDONS, SubSystem.THREAD_POOL, SubSystem.API_SERVER, SubSystem.RANDOMIZATION);
        private List<SubSystem> shutdownSequence = Arrays.asList(SubSystem.ADDONS, SubSystem.RANDOMIZATION, SubSystem.API_SERVER, SubSystem.THREAD_POOL, SubSystem.BLOCKCHAIN, SubSystem.PEER_NETWORKING, SubSystem.DB, SubSystem.LOGGER);

        @Override
        public List<SubSystem> initSequence() {
            return this.initSequence;
        }

        @Override
        public List<SubSystem> shutdownSequence() {
            return this.shutdownSequence;
        }
    };
    public static final Setup CLIENT_APP = new Setup(){
        List<SubSystem> subSystems = Arrays.asList(SubSystem.LOGGER, SubSystem.ADDONS, SubSystem.API_SERVER);

        @Override
        public List<SubSystem> initSequence() {
            return this.subSystems;
        }

        @Override
        public List<SubSystem> shutdownSequence() {
            return this.subSystems;
        }
    };
    public static final Setup NOT_INITIALIZED = new Setup(){

        @Override
        public List<SubSystem> initSequence() {
            return Collections.emptyList();
        }

        @Override
        public List<SubSystem> shutdownSequence() {
            return Collections.emptyList();
        }
    };

    public List<SubSystem> initSequence();

    public List<SubSystem> shutdownSequence();
}

