/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nxt.db.DbUtils;

public final class DbIterator<T>
implements Iterator<T>,
Iterable<T>,
AutoCloseable {
    private final Connection con;
    private final PreparedStatement pstmt;
    private final ResultSetReader<T> rsReader;
    private final ResultSet rs;
    private boolean hasNext;
    private boolean iterated;

    public DbIterator(Connection connection, PreparedStatement preparedStatement, ResultSetReader<T> resultSetReader) {
        this.con = connection;
        this.pstmt = preparedStatement;
        this.rsReader = resultSetReader;
        try {
            this.rs = preparedStatement.executeQuery();
            this.hasNext = this.rs.next();
        }
        catch (SQLException sQLException) {
            DbUtils.close(preparedStatement, connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.hasNext) {
            DbUtils.close(this.rs, this.pstmt, this.con);
        }
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext) {
            DbUtils.close(this.rs, this.pstmt, this.con);
            throw new NoSuchElementException();
        }
        try {
            T t = this.rsReader.get(this.con, this.rs);
            this.hasNext = this.rs.next();
            return t;
        }
        catch (Exception exception) {
            DbUtils.close(this.rs, this.pstmt, this.con);
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal not supported");
    }

    @Override
    public void close() {
        DbUtils.close(this.rs, this.pstmt, this.con);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iterated) {
            throw new IllegalStateException("Already iterated");
        }
        this.iterated = true;
        return this;
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public static interface ResultSetReader<T> {
        public T get(Connection var1, ResultSet var2) throws Exception;
    }
}

