/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import nxt.Constants;
import nxt.Nxt;
import nxt.db.DbKey;
import nxt.db.PersistentDbTable;
import nxt.util.Logger;

public abstract class PrunableDbTable<T>
extends PersistentDbTable<T> {
    protected PrunableDbTable(String string, DbKey.Factory<T> factory) {
        super(string, factory);
    }

    protected PrunableDbTable(String string, DbKey.Factory<T> factory, String string2) {
        super(string, factory, string2);
    }

    PrunableDbTable(String string, DbKey.Factory<T> factory, boolean bl, String string2) {
        super(string, factory, bl, string2);
    }

    @Override
    public final void trim(int n) {
        this.prune();
        super.trim(n);
    }

    protected void prune() {
        if (Constants.ENABLE_PRUNING) {
            try (Connection connection = this.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.schemaTable + " WHERE transaction_timestamp < ? LIMIT " + Constants.BATCH_COMMIT_SIZE);){
                int n;
                preparedStatement.setInt(1, Nxt.getEpochTime() - Constants.MAX_PRUNABLE_LIFETIME);
                do {
                    if ((n = preparedStatement.executeUpdate()) > 0) {
                        Logger.logDebugMessage("Deleted " + n + " expired prunable data from " + this.schemaTable);
                    }
                    db.commitTransaction();
                } while (n >= Constants.BATCH_COMMIT_SIZE);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
        }
    }
}

