/*
 * Decompiled with CFR 0.152.
 */
package nxt.dbschema;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import nxt.Constants;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.db.BasicDb;
import nxt.db.DbVersion;
import nxt.db.TransactionalDb;
import nxt.dbschema.ChildDbVersion;
import nxt.dbschema.FxtDbVersion;

public final class Db {
    public static final String PREFIX = Constants.isTestnet ? "nxt.testDb" : "nxt.db";
    public static final TransactionalDb db = new TransactionalDb(new BasicDb.DbProperties().maxCacheSize(Nxt.getIntProperty("nxt.dbCacheKB")).dbUrl(Nxt.getStringProperty(PREFIX + "Url")).dbType(Nxt.getStringProperty(PREFIX + "Type")).dbDir(Nxt.getStringProperty(PREFIX + "Dir")).dbParams(Nxt.getStringProperty(PREFIX + "Params")).dbUsername(Nxt.getStringProperty(PREFIX + "Username")).dbPassword(Nxt.getStringProperty(PREFIX + "Password", null, true)).maxConnections(Nxt.getIntProperty("nxt.maxDbConnections")).loginTimeout(Nxt.getIntProperty("nxt.dbLoginTimeout")).defaultLockTimeout(Nxt.getIntProperty("nxt.dbDefaultLockTimeout") * 1000).maxMemoryRows(Nxt.getIntProperty("nxt.dbMaxMemoryRows")));

    public static Connection getConnection() throws SQLException {
        return db.getConnection("PUBLIC");
    }

    public static void init() {
        Init.init();
    }

    public static void shutdown() {
        db.shutdown();
    }

    private Db() {
    }

    private static class Init {
        private Init() {
        }

        private static void init() {
        }

        static {
            ArrayList<DbVersion> arrayList = new ArrayList<DbVersion>();
            arrayList.add(new FxtDbVersion(db));
            ChildChain.getAll().forEach(childChain -> arrayList.add(new ChildDbVersion(db, childChain.getName())));
            db.init(arrayList);
        }
    }
}

