/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.crypto.EncryptedData;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class DeliveryAttachment
extends Attachment.AbstractAttachment {
    private final long purchaseId;
    private EncryptedData goods;
    private final long discountNQT;
    private final boolean goodsIsText;

    DeliveryAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.purchaseId = byteBuffer.getLong();
        int n = byteBuffer.getInt();
        boolean bl = this.goodsIsText = n < 0;
        if (n < 0) {
            n &= Integer.MAX_VALUE;
        }
        this.goods = EncryptedData.readEncryptedData(byteBuffer, n, 1000);
        this.discountNQT = byteBuffer.getLong();
    }

    DeliveryAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.purchaseId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"purchase"));
        this.goods = new EncryptedData(Convert.parseHexString((String)jSONObject.get((Object)"goodsData")), Convert.parseHexString((String)jSONObject.get((Object)"goodsNonce")));
        this.discountNQT = Convert.parseLong(jSONObject.get((Object)"discountNQT"));
        this.goodsIsText = Boolean.TRUE.equals(jSONObject.get((Object)"goodsIsText"));
    }

    public DeliveryAttachment(long l, EncryptedData encryptedData, boolean bl, long l2) {
        this.purchaseId = l;
        this.goods = encryptedData;
        this.discountNQT = l2;
        this.goodsIsText = bl;
    }

    @Override
    protected int getMySize() {
        return 12 + this.goods.getSize() + 8;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.purchaseId);
        byteBuffer.putInt(this.goodsIsText ? this.goods.getData().length | Integer.MIN_VALUE : this.goods.getData().length);
        byteBuffer.put(this.goods.getData());
        byteBuffer.put(this.goods.getNonce());
        byteBuffer.putLong(this.discountNQT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"purchase", (Object)Long.toUnsignedString(this.purchaseId));
        jSONObject.put((Object)"goodsData", (Object)Convert.toHexString(this.goods.getData()));
        jSONObject.put((Object)"goodsNonce", (Object)Convert.toHexString(this.goods.getNonce()));
        jSONObject.put((Object)"discountNQT", (Object)this.discountNQT);
        jSONObject.put((Object)"goodsIsText", (Object)this.goodsIsText);
    }

    @Override
    public final TransactionType getTransactionType() {
        return DigitalGoodsTransactionType.DELIVERY;
    }

    public final long getPurchaseId() {
        return this.purchaseId;
    }

    public final EncryptedData getGoods() {
        return this.goods;
    }

    final void setGoods(EncryptedData encryptedData) {
        this.goods = encryptedData;
    }

    int getGoodsDataLength() {
        return this.goods.getData().length;
    }

    public final long getDiscountNQT() {
        return this.discountNQT;
    }

    public final boolean goodsIsText() {
        return this.goodsIsText;
    }
}

