/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionImpl;
import nxt.crypto.EncryptedData;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.db.VersionedValuesDbTable;
import nxt.dgs.DeliveryAttachment;
import nxt.dgs.ListingAttachment;
import nxt.dgs.PurchaseAttachment;
import nxt.messaging.EncryptedMessageAppendix;
import nxt.messaging.MessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Search;

public final class DigitalGoodsHome {
    private static final Listeners<Goods, Event> goodsListeners = new Listeners();
    private static final Listeners<Purchase, Event> purchaseListeners = new Listeners();
    private final ChildChain childChain;
    private final DbKey.StringKeyFactory<Tag> tagDbKeyFactory;
    private final VersionedEntityDbTable<Tag> tagTable;
    private final DbKey.LongKeyFactory<Goods> goodsDbKeyFactory;
    private final VersionedEntityDbTable<Goods> goodsTable;
    private final DbKey.LongKeyFactory<Purchase> purchaseDbKeyFactory;
    private final VersionedEntityDbTable<Purchase> purchaseTable;
    private final DbKey.LongKeyFactory<Purchase> feedbackDbKeyFactory;
    private final VersionedValuesDbTable<Purchase, EncryptedData> feedbackTable;
    private final DbKey.LongKeyFactory<Purchase> publicFeedbackDbKeyFactory;
    private final VersionedValuesDbTable<Purchase, String> publicFeedbackTable;
    private static final DbClause inStockOnlyClause = new DbClause.IntClause("in_stock_count", DbClause.Op.GT, 0);
    private static final DbClause inStockClause = new DbClause.BooleanClause("goods.delisted", false).and(new DbClause.LongClause("goods.quantity", DbClause.Op.GT, 0L));

    public static DigitalGoodsHome forChain(ChildChain childChain) {
        if (childChain.getDigitalGoodsHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new DigitalGoodsHome(childChain);
    }

    public static boolean addGoodsListener(Listener<Goods> listener, Event event) {
        return goodsListeners.addListener(listener, event);
    }

    public static boolean removeGoodsListener(Listener<Goods> listener, Event event) {
        return goodsListeners.removeListener(listener, event);
    }

    public static boolean addPurchaseListener(Listener<Purchase> listener, Event event) {
        return purchaseListeners.addListener(listener, event);
    }

    public static boolean removePurchaseListener(Listener<Purchase> listener, Event event) {
        return purchaseListeners.removeListener(listener, event);
    }

    private DigitalGoodsHome(ChildChain childChain) {
        this.childChain = childChain;
        this.tagDbKeyFactory = new DbKey.StringKeyFactory<Tag>("tag"){

            @Override
            public DbKey newKey(Tag tag) {
                return tag.dbKey;
            }
        };
        this.tagTable = new VersionedEntityDbTable<Tag>(childChain.getSchemaTable("tag"), this.tagDbKeyFactory){

            @Override
            protected Tag load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Tag(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Tag tag) throws SQLException {
                tag.save(connection);
            }

            @Override
            public String defaultSort() {
                return " ORDER BY in_stock_count DESC, total_count DESC, tag ASC ";
            }
        };
        this.goodsDbKeyFactory = new DbKey.LongKeyFactory<Goods>("id"){

            @Override
            public DbKey newKey(Goods goods) {
                return goods.dbKey;
            }
        };
        this.goodsTable = new VersionedEntityDbTable<Goods>(childChain.getSchemaTable("goods"), this.goodsDbKeyFactory, "name,description,tags"){

            @Override
            protected Goods load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Goods(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Goods goods) throws SQLException {
                goods.save(connection);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY timestamp DESC, id ASC ";
            }
        };
        this.purchaseDbKeyFactory = new DbKey.LongKeyFactory<Purchase>("id"){

            @Override
            public DbKey newKey(Purchase purchase) {
                return purchase.dbKey;
            }
        };
        this.purchaseTable = new VersionedEntityDbTable<Purchase>(childChain.getSchemaTable("purchase"), this.purchaseDbKeyFactory){

            @Override
            protected Purchase load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Purchase(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Purchase purchase) throws SQLException {
                purchase.save(connection);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY timestamp DESC, id ASC ";
            }
        };
        this.feedbackDbKeyFactory = new DbKey.LongKeyFactory<Purchase>("id"){

            @Override
            public DbKey newKey(Purchase purchase) {
                return purchase.dbKey == null ? this.newKey(purchase.id) : purchase.dbKey;
            }
        };
        this.feedbackTable = new VersionedValuesDbTable<Purchase, EncryptedData>(childChain.getSchemaTable("purchase_feedback"), this.feedbackDbKeyFactory){

            @Override
            protected EncryptedData load(Connection connection, ResultSet resultSet) throws SQLException {
                byte[] byArray = resultSet.getBytes("feedback_data");
                byte[] byArray2 = resultSet.getBytes("feedback_nonce");
                return new EncryptedData(byArray, byArray2);
            }

            @Override
            protected void save(Connection connection, Purchase purchase, EncryptedData encryptedData) throws SQLException {
                try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO purchase_feedback (id, feedback_data, feedback_nonce, height, latest) VALUES (?, ?, ?, ?, TRUE)");){
                    int n = 0;
                    preparedStatement.setLong(++n, purchase.getId());
                    ++n;
                    n = DigitalGoodsHome.setEncryptedData(preparedStatement, encryptedData, n);
                    preparedStatement.setInt(n, Nxt.getBlockchain().getHeight());
                    preparedStatement.executeUpdate();
                }
            }
        };
        this.publicFeedbackDbKeyFactory = new DbKey.LongKeyFactory<Purchase>("id"){

            @Override
            public DbKey newKey(Purchase purchase) {
                return purchase.dbKey == null ? this.newKey(purchase.id) : purchase.dbKey;
            }
        };
        this.publicFeedbackTable = new VersionedValuesDbTable<Purchase, String>(childChain.getSchemaTable("purchase_public_feedback"), this.publicFeedbackDbKeyFactory){

            @Override
            protected String load(Connection connection, ResultSet resultSet) throws SQLException {
                return resultSet.getString("public_feedback");
            }

            @Override
            protected void save(Connection connection, Purchase purchase, String string) throws SQLException {
                try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO purchase_public_feedback (id, public_feedback, height, latest) VALUES (?, ?, ?, TRUE)");){
                    int n = 0;
                    preparedStatement.setLong(++n, purchase.getId());
                    preparedStatement.setString(++n, string);
                    preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                    preparedStatement.executeUpdate();
                }
            }
        };
        Nxt.getBlockchainProcessor().addListener(block -> {
            if (block.getHeight() == 0) {
                return;
            }
            ArrayList<Purchase> arrayList = new ArrayList<Purchase>();
            Throwable object2 = null;
            try (Iterator<Purchase> iterator = this.getExpiredPendingPurchases((Block)block);){
                while (((DbIterator)iterator).hasNext()) {
                    arrayList.add((Purchase)((DbIterator)iterator).next());
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
            for (Purchase purchase : arrayList) {
                childChain.getBalanceHome().getBalance(purchase.getBuyerId()).addToUnconfirmedBalance(AccountLedger.LedgerEvent.DIGITAL_GOODS_PURCHASE_EXPIRED, AccountLedger.newEventId(purchase.getId(), null, childChain), Math.multiplyExact((long)purchase.getQuantity(), purchase.getPriceNQT()));
                this.getGoods(purchase.getGoodsId()).changeQuantity(purchase.getQuantity());
                purchase.setPending(false);
            }
        }, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
    }

    public int getTagCount() {
        return this.tagTable.getCount();
    }

    public int getTagCountInStock() {
        return this.tagTable.getCount(inStockOnlyClause);
    }

    public DbIterator<Tag> getAllTags(int n, int n2) {
        return this.tagTable.getAll(n, n2);
    }

    public DbIterator<Tag> getInStockTags(int n, int n2) {
        return this.tagTable.getManyBy(inStockOnlyClause, n, n2);
    }

    public DbIterator<Tag> getTagsLike(String string, boolean bl, int n, int n2) {
        DbClause dbClause = new DbClause.LikeClause("tag", string);
        if (bl) {
            dbClause = dbClause.and(inStockOnlyClause);
        }
        return this.tagTable.getManyBy(dbClause, n, n2, " ORDER BY tag ");
    }

    private void addTags(Goods goods) {
        for (String string : goods.getParsedTags()) {
            Tag tag = (Tag)this.tagTable.get(this.tagDbKeyFactory.newKey(string));
            if (tag == null) {
                tag = new Tag(string);
            }
            Tag tag2 = tag;
            tag2.inStockCount = tag2.inStockCount + 1;
            tag2 = tag;
            tag2.totalCount = tag2.totalCount + 1;
            this.tagTable.insert(tag);
        }
    }

    private void delistTags(Goods goods) {
        for (String string : goods.getParsedTags()) {
            Tag tag = (Tag)this.tagTable.get(this.tagDbKeyFactory.newKey(string));
            if (tag == null) {
                throw new IllegalStateException("Unknown tag " + string);
            }
            Tag tag2 = tag;
            tag2.inStockCount = tag2.inStockCount - 1;
            this.tagTable.insert(tag);
        }
    }

    public int getGoodsCount() {
        return this.goodsTable.getCount();
    }

    public int getGoodsInStockCount() {
        return this.goodsTable.getCount(inStockClause);
    }

    public Goods getGoods(long l) {
        return (Goods)this.goodsTable.get(this.goodsDbKeyFactory.newKey(l));
    }

    public DbIterator<Goods> getAllGoods(int n, int n2) {
        return this.goodsTable.getAll(n, n2);
    }

    public DbIterator<Goods> getGoodsInStock(int n, int n2) {
        return this.goodsTable.getManyBy(inStockClause, n, n2);
    }

    public DbIterator<Goods> getSellerGoods(long l, boolean bl, int n, int n2) {
        return this.goodsTable.getManyBy((DbClause)new SellerDbClause(l, bl), n, n2, " ORDER BY name ASC, timestamp DESC, id ASC ");
    }

    public int getSellerGoodsCount(long l, boolean bl) {
        return this.goodsTable.getCount(new SellerDbClause(l, bl));
    }

    public DbIterator<Goods> searchGoods(String string, boolean bl, int n, int n2) {
        return this.goodsTable.search(string, bl ? inStockClause : DbClause.EMPTY_CLAUSE, n, n2, " ORDER BY ft.score DESC, goods.timestamp DESC ");
    }

    public DbIterator<Goods> searchSellerGoods(String string, long l, boolean bl, int n, int n2) {
        return this.goodsTable.search(string, new SellerDbClause(l, bl), n, n2, " ORDER BY ft.score DESC, goods.name ASC, goods.timestamp DESC ");
    }

    public int getPurchaseCount() {
        return this.purchaseTable.getCount();
    }

    public int getPurchaseCount(boolean bl, boolean bl2) {
        return this.purchaseTable.getCount(new PurchasesClause(" TRUE ", bl, bl2));
    }

    public DbIterator<Purchase> getAllPurchases(int n, int n2) {
        return this.purchaseTable.getAll(n, n2);
    }

    public DbIterator<Purchase> getPurchases(boolean bl, boolean bl2, int n, int n2) {
        return this.purchaseTable.getManyBy(new PurchasesClause(" TRUE ", bl, bl2), n, n2);
    }

    public DbIterator<Purchase> getSellerPurchases(long l, boolean bl, boolean bl2, int n, int n2) {
        return this.purchaseTable.getManyBy(new LongPurchasesClause("seller_id", l, bl, bl2), n, n2);
    }

    public int getSellerPurchaseCount(long l, boolean bl, boolean bl2) {
        return this.purchaseTable.getCount(new LongPurchasesClause("seller_id", l, bl, bl2));
    }

    public DbIterator<Purchase> getBuyerPurchases(long l, boolean bl, boolean bl2, int n, int n2) {
        return this.purchaseTable.getManyBy(new LongPurchasesClause("buyer_id", l, bl, bl2), n, n2);
    }

    public int getBuyerPurchaseCount(long l, boolean bl, boolean bl2) {
        return this.purchaseTable.getCount(new LongPurchasesClause("buyer_id", l, bl, bl2));
    }

    public DbIterator<Purchase> getSellerBuyerPurchases(long l, long l2, boolean bl, boolean bl2, int n, int n2) {
        return this.purchaseTable.getManyBy(new SellerBuyerPurchasesClause(l, l2, bl, bl2), n, n2);
    }

    public int getSellerBuyerPurchaseCount(long l, long l2, boolean bl, boolean bl2) {
        return this.purchaseTable.getCount(new SellerBuyerPurchasesClause(l, l2, bl, bl2));
    }

    public DbIterator<Purchase> getGoodsPurchases(long l, long l2, boolean bl, boolean bl2, int n, int n2) {
        DbClause dbClause = new LongPurchasesClause("goods_id", l, bl, bl2);
        if (l2 != 0L) {
            dbClause = dbClause.and(new DbClause.LongClause("buyer_id", l2));
        }
        return this.purchaseTable.getManyBy(dbClause, n, n2);
    }

    public int getGoodsPurchaseCount(long l, boolean bl, boolean bl2) {
        return this.purchaseTable.getCount(new LongPurchasesClause("goods_id", l, bl, bl2));
    }

    public Purchase getPurchase(long l) {
        return (Purchase)this.purchaseTable.get(this.purchaseDbKeyFactory.newKey(l));
    }

    public DbIterator<Purchase> getPendingSellerPurchases(long l, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("seller_id", l).and(new DbClause.BooleanClause("pending", true));
        return this.purchaseTable.getManyBy(dbClause, n, n2);
    }

    public DbIterator<Purchase> getExpiredSellerPurchases(long l, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("seller_id", l).and(new DbClause.BooleanClause("pending", false)).and(new DbClause.NullClause("goods"));
        return this.purchaseTable.getManyBy(dbClause, n, n2);
    }

    public Purchase getPendingPurchase(long l) {
        Purchase purchase = this.getPurchase(l);
        return purchase == null || !purchase.isPending() ? null : purchase;
    }

    private DbIterator<Purchase> getExpiredPendingPurchases(Block block) {
        int n = block.getTimestamp();
        int n2 = Nxt.getBlockchain().getBlock(block.getPreviousBlockId()).getTimestamp();
        DbClause dbClause = new DbClause.LongClause("deadline", DbClause.Op.LT, n).and(new DbClause.LongClause("deadline", DbClause.Op.GTE, n2)).and(new DbClause.BooleanClause("pending", true));
        return this.purchaseTable.getManyBy(dbClause, 0, -1);
    }

    void listGoods(ChildTransactionImpl childTransactionImpl, ListingAttachment listingAttachment) {
        Goods goods = new Goods(childTransactionImpl, listingAttachment);
        this.addTags(goods);
        this.goodsTable.insert(goods);
        goodsListeners.notify(goods, Event.GOODS_LISTED);
    }

    void delistGoods(long l) {
        Goods goods = (Goods)this.goodsTable.get(this.goodsDbKeyFactory.newKey(l));
        if (goods.isDelisted()) {
            throw new IllegalStateException("Goods already delisted");
        }
        goods.setDelisted(true);
        goodsListeners.notify(goods, Event.GOODS_DELISTED);
    }

    void changePrice(long l, long l2) {
        Goods goods = (Goods)this.goodsTable.get(this.goodsDbKeyFactory.newKey(l));
        if (goods.isDelisted()) {
            throw new IllegalStateException("Can't change price of delisted goods");
        }
        goods.changePrice(l2);
        goodsListeners.notify(goods, Event.GOODS_PRICE_CHANGE);
    }

    void changeQuantity(long l, int n) {
        Goods goods = (Goods)this.goodsTable.get(this.goodsDbKeyFactory.newKey(l));
        if (goods.isDelisted()) {
            throw new IllegalStateException("Can't change quantity of delisted goods");
        }
        goods.changeQuantity(n);
        goodsListeners.notify(goods, Event.GOODS_QUANTITY_CHANGE);
    }

    void purchase(ChildTransaction childTransaction, PurchaseAttachment purchaseAttachment) {
        Goods goods = (Goods)this.goodsTable.get(this.goodsDbKeyFactory.newKey(purchaseAttachment.getGoodsId()));
        if (!goods.isDelisted() && purchaseAttachment.getQuantity() <= goods.getQuantity() && purchaseAttachment.getPriceNQT() == goods.getPriceNQT()) {
            goods.changeQuantity(-purchaseAttachment.getQuantity());
            Purchase purchase = new Purchase(childTransaction, purchaseAttachment, goods.getSellerId());
            this.purchaseTable.insert(purchase);
            purchaseListeners.notify(purchase, Event.PURCHASE);
        } else {
            BalanceHome.Balance balance = childTransaction.getChain().getBalanceHome().getBalance(childTransaction.getSenderId());
            balance.addToUnconfirmedBalance(AccountLedger.LedgerEvent.DIGITAL_GOODS_DELISTED, AccountLedger.newEventId(childTransaction), Math.multiplyExact((long)purchaseAttachment.getQuantity(), purchaseAttachment.getPriceNQT()));
        }
    }

    void deliver(ChildTransaction childTransaction, DeliveryAttachment deliveryAttachment) {
        Purchase purchase = this.getPendingPurchase(deliveryAttachment.getPurchaseId());
        purchase.setPending(false);
        long l = Math.multiplyExact((long)purchase.getQuantity(), purchase.getPriceNQT());
        BalanceHome.Balance balance = this.childChain.getBalanceHome().getBalance(purchase.getBuyerId());
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(childTransaction);
        balance.addToBalance(AccountLedger.LedgerEvent.DIGITAL_GOODS_DELIVERY, ledgerEventId, Math.subtractExact(deliveryAttachment.getDiscountNQT(), l));
        balance.addToUnconfirmedBalance(AccountLedger.LedgerEvent.DIGITAL_GOODS_DELIVERY, ledgerEventId, deliveryAttachment.getDiscountNQT());
        BalanceHome.Balance balance2 = this.childChain.getBalanceHome().getBalance(childTransaction.getSenderId());
        balance2.addToBalanceAndUnconfirmedBalance(AccountLedger.LedgerEvent.DIGITAL_GOODS_DELIVERY, ledgerEventId, Math.subtractExact(l, deliveryAttachment.getDiscountNQT()));
        purchase.setEncryptedGoods(deliveryAttachment.getGoods(), deliveryAttachment.goodsIsText());
        purchase.setDiscountNQT(deliveryAttachment.getDiscountNQT());
        purchaseListeners.notify(purchase, Event.DELIVERY);
    }

    void refund(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2, long l3, EncryptedMessageAppendix encryptedMessageAppendix) {
        Purchase purchase = (Purchase)this.purchaseTable.get(this.purchaseDbKeyFactory.newKey(l2));
        BalanceHome.Balance balance = this.childChain.getBalanceHome().getBalance(l);
        balance.addToBalance(ledgerEvent, ledgerEventId, -l3);
        BalanceHome.Balance balance2 = this.childChain.getBalanceHome().getBalance(purchase.getBuyerId());
        balance2.addToBalanceAndUnconfirmedBalance(ledgerEvent, ledgerEventId, l3);
        if (encryptedMessageAppendix != null) {
            purchase.setRefundNote(encryptedMessageAppendix.getEncryptedData());
        }
        purchase.setRefundNQT(l3);
        purchaseListeners.notify(purchase, Event.REFUND);
    }

    void feedback(long l, EncryptedMessageAppendix encryptedMessageAppendix, MessageAppendix messageAppendix) {
        Purchase purchase = (Purchase)this.purchaseTable.get(this.purchaseDbKeyFactory.newKey(l));
        if (encryptedMessageAppendix != null) {
            purchase.addFeedbackNote(encryptedMessageAppendix.getEncryptedData());
        }
        if (messageAppendix != null) {
            purchase.addPublicFeedback(Convert.toString(messageAppendix.getMessage()));
        }
        purchaseListeners.notify(purchase, Event.FEEDBACK);
    }

    private static EncryptedData loadEncryptedData(ResultSet resultSet, String string, String string2) throws SQLException {
        byte[] byArray = resultSet.getBytes(string);
        if (byArray == null) {
            return null;
        }
        return new EncryptedData(byArray, resultSet.getBytes(string2));
    }

    private static int setEncryptedData(PreparedStatement preparedStatement, EncryptedData encryptedData, int n) throws SQLException {
        if (encryptedData == null) {
            preparedStatement.setNull(n++, -3);
            preparedStatement.setNull(n++, -3);
        } else {
            preparedStatement.setBytes(n++, encryptedData.getData());
            preparedStatement.setBytes(n++, encryptedData.getNonce());
        }
        return n;
    }

    private static final class SellerDbClause
    extends DbClause {
        private final long sellerId;

        private SellerDbClause(long l, boolean bl) {
            super(" seller_id = ? " + (bl ? "AND delisted = FALSE AND quantity > 0" : ""));
            this.sellerId = l;
        }

        @Override
        public int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n++, this.sellerId);
            return n;
        }
    }

    public final class Purchase {
        private final long id;
        private final DbKey dbKey;
        private final long buyerId;
        private final long goodsId;
        private final long sellerId;
        private final int quantity;
        private final long priceNQT;
        private final int deadline;
        private final EncryptedData note;
        private final int timestamp;
        private boolean isPending;
        private EncryptedData encryptedGoods;
        private boolean goodsIsText;
        private EncryptedData refundNote;
        private boolean hasFeedbackNotes;
        private List<EncryptedData> feedbackNotes;
        private boolean hasPublicFeedbacks;
        private List<String> publicFeedbacks;
        private long discountNQT;
        private long refundNQT;

        private Purchase(ChildTransaction childTransaction, PurchaseAttachment purchaseAttachment, long l) {
            this.id = childTransaction.getId();
            this.dbKey = DigitalGoodsHome.this.purchaseDbKeyFactory.newKey(this.id);
            this.buyerId = childTransaction.getSenderId();
            this.goodsId = purchaseAttachment.getGoodsId();
            this.sellerId = l;
            this.quantity = purchaseAttachment.getQuantity();
            this.priceNQT = purchaseAttachment.getPriceNQT();
            this.deadline = purchaseAttachment.getDeliveryDeadlineTimestamp();
            this.note = childTransaction.getEncryptedMessage() == null ? null : childTransaction.getEncryptedMessage().getEncryptedData();
            this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
            this.isPending = true;
        }

        private Purchase(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.buyerId = resultSet.getLong("buyer_id");
            this.goodsId = resultSet.getLong("goods_id");
            this.sellerId = resultSet.getLong("seller_id");
            this.quantity = resultSet.getInt("quantity");
            this.priceNQT = resultSet.getLong("price");
            this.deadline = resultSet.getInt("deadline");
            this.note = DigitalGoodsHome.loadEncryptedData(resultSet, "note", "nonce");
            this.timestamp = resultSet.getInt("timestamp");
            this.isPending = resultSet.getBoolean("pending");
            this.encryptedGoods = DigitalGoodsHome.loadEncryptedData(resultSet, "goods", "goods_nonce");
            this.refundNote = DigitalGoodsHome.loadEncryptedData(resultSet, "refund_note", "refund_nonce");
            this.hasFeedbackNotes = resultSet.getBoolean("has_feedback_notes");
            this.hasPublicFeedbacks = resultSet.getBoolean("has_public_feedbacks");
            this.discountNQT = resultSet.getLong("discount");
            this.refundNQT = resultSet.getLong("refund");
            this.goodsIsText = resultSet.getBoolean("goods_is_text");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO purchase (id, buyer_id, goods_id, seller_id, quantity, price, deadline, note, nonce, timestamp, pending, goods, goods_nonce, goods_is_text, refund_note, refund_nonce, has_feedback_notes, has_public_feedbacks, discount, refund, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setLong(++n, this.buyerId);
                preparedStatement.setLong(++n, this.goodsId);
                preparedStatement.setLong(++n, this.sellerId);
                preparedStatement.setInt(++n, this.quantity);
                preparedStatement.setLong(++n, this.priceNQT);
                preparedStatement.setInt(++n, this.deadline);
                ++n;
                n = DigitalGoodsHome.setEncryptedData(preparedStatement, this.note, n);
                preparedStatement.setInt(n, this.timestamp);
                preparedStatement.setBoolean(++n, this.isPending);
                ++n;
                n = DigitalGoodsHome.setEncryptedData(preparedStatement, this.encryptedGoods, n);
                preparedStatement.setBoolean(n, this.goodsIsText);
                ++n;
                n = DigitalGoodsHome.setEncryptedData(preparedStatement, this.refundNote, n);
                preparedStatement.setBoolean(n, this.hasFeedbackNotes);
                preparedStatement.setBoolean(++n, this.hasPublicFeedbacks);
                preparedStatement.setLong(++n, this.discountNQT);
                preparedStatement.setLong(++n, this.refundNQT);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public long getBuyerId() {
            return this.buyerId;
        }

        public long getGoodsId() {
            return this.goodsId;
        }

        public long getSellerId() {
            return this.sellerId;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }

        public int getDeliveryDeadlineTimestamp() {
            return this.deadline;
        }

        public EncryptedData getNote() {
            return this.note;
        }

        public boolean isPending() {
            return this.isPending;
        }

        private void setPending(boolean bl) {
            this.isPending = bl;
            DigitalGoodsHome.this.purchaseTable.insert(this);
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public EncryptedData getEncryptedGoods() {
            return this.encryptedGoods;
        }

        public boolean goodsIsText() {
            return this.goodsIsText;
        }

        private void setEncryptedGoods(EncryptedData encryptedData, boolean bl) {
            this.encryptedGoods = encryptedData;
            this.goodsIsText = bl;
            DigitalGoodsHome.this.purchaseTable.insert(this);
        }

        public EncryptedData getRefundNote() {
            return this.refundNote;
        }

        private void setRefundNote(EncryptedData encryptedData) {
            this.refundNote = encryptedData;
            DigitalGoodsHome.this.purchaseTable.insert(this);
        }

        public boolean hasFeedbackNotes() {
            return this.hasFeedbackNotes;
        }

        public List<EncryptedData> getFeedbackNotes() {
            if (!this.hasFeedbackNotes) {
                return null;
            }
            this.feedbackNotes = DigitalGoodsHome.this.feedbackTable.get(DigitalGoodsHome.this.feedbackDbKeyFactory.newKey(this));
            return this.feedbackNotes;
        }

        private void addFeedbackNote(EncryptedData encryptedData) {
            if (this.getFeedbackNotes() == null) {
                this.feedbackNotes = new ArrayList<EncryptedData>();
            }
            this.feedbackNotes.add(encryptedData);
            if (!this.hasFeedbackNotes) {
                this.hasFeedbackNotes = true;
                DigitalGoodsHome.this.purchaseTable.insert(this);
            }
            DigitalGoodsHome.this.feedbackTable.insert(this, this.feedbackNotes);
        }

        public boolean hasPublicFeedbacks() {
            return this.hasPublicFeedbacks;
        }

        public List<String> getPublicFeedbacks() {
            if (!this.hasPublicFeedbacks) {
                return null;
            }
            this.publicFeedbacks = DigitalGoodsHome.this.publicFeedbackTable.get(DigitalGoodsHome.this.publicFeedbackDbKeyFactory.newKey(this));
            return this.publicFeedbacks;
        }

        private void addPublicFeedback(String string) {
            if (this.getPublicFeedbacks() == null) {
                this.publicFeedbacks = new ArrayList<String>();
            }
            this.publicFeedbacks.add(string);
            if (!this.hasPublicFeedbacks) {
                this.hasPublicFeedbacks = true;
                DigitalGoodsHome.this.purchaseTable.insert(this);
            }
            DigitalGoodsHome.this.publicFeedbackTable.insert(this, this.publicFeedbacks);
        }

        public long getDiscountNQT() {
            return this.discountNQT;
        }

        private void setDiscountNQT(long l) {
            this.discountNQT = l;
            DigitalGoodsHome.this.purchaseTable.insert(this);
        }

        public long getRefundNQT() {
            return this.refundNQT;
        }

        private void setRefundNQT(long l) {
            this.refundNQT = l;
            DigitalGoodsHome.this.purchaseTable.insert(this);
        }

        public DigitalGoodsHome getDGSHome() {
            return DigitalGoodsHome.this;
        }

        public ChildChain getChildChain() {
            return DigitalGoodsHome.this.childChain;
        }
    }

    private static final class SellerBuyerPurchasesClause
    extends PurchasesClause {
        private final long sellerId;
        private final long buyerId;

        private SellerBuyerPurchasesClause(long l, long l2, boolean bl, boolean bl2) {
            super(" seller_id = ? AND buyer_id = ? ", bl, bl2);
            this.sellerId = l;
            this.buyerId = l2;
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n++, this.sellerId);
            preparedStatement.setLong(n++, this.buyerId);
            return n;
        }
    }

    private static final class LongPurchasesClause
    extends PurchasesClause {
        private final long value;

        private LongPurchasesClause(String string, long l, boolean bl, boolean bl2) {
            super(string + " = ? ", bl, bl2);
            this.value = l;
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n++, this.value);
            return n;
        }
    }

    private static class PurchasesClause
    extends DbClause {
        private PurchasesClause(String string, boolean bl, boolean bl2) {
            super(string + (bl2 ? " AND goods IS NOT NULL " : " ") + (bl ? " AND has_public_feedbacks = TRUE " : " "));
        }

        @Override
        protected int set(PreparedStatement preparedStatement, int n) throws SQLException {
            return n;
        }
    }

    public final class Goods {
        private final long id;
        private final DbKey dbKey;
        private final byte[] fullHash;
        private final long sellerId;
        private final String name;
        private final String description;
        private final String tags;
        private final String[] parsedTags;
        private final int timestamp;
        private final boolean hasImage;
        private int quantity;
        private long priceNQT;
        private boolean delisted;

        private Goods(ChildTransactionImpl childTransactionImpl, ListingAttachment listingAttachment) {
            byte[] byArray;
            this.id = childTransactionImpl.getId();
            this.dbKey = DigitalGoodsHome.this.goodsDbKeyFactory.newKey(this.id);
            this.fullHash = childTransactionImpl.getFullHash();
            this.sellerId = childTransactionImpl.getSenderId();
            this.name = listingAttachment.getName();
            this.description = listingAttachment.getDescription();
            this.tags = listingAttachment.getTags();
            this.parsedTags = Search.parseTags(this.tags, 3, 20, 3);
            this.quantity = listingAttachment.getQuantity();
            this.priceNQT = listingAttachment.getPriceNQT();
            this.delisted = false;
            this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
            boolean bl = false;
            PrunablePlainMessageAppendix prunablePlainMessageAppendix = childTransactionImpl.getPrunablePlainMessage();
            if (!Constants.DISABLE_METADATA_DETECTION && prunablePlainMessageAppendix != null && (byArray = prunablePlainMessageAppendix.getMessage()) != null) {
                String string = Search.detectMimeType(byArray);
                bl = string != null && string.startsWith("image/");
            }
            this.hasImage = bl;
        }

        private Goods(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.fullHash = resultSet.getBytes("full_hash");
            this.sellerId = resultSet.getLong("seller_id");
            this.name = resultSet.getString("name");
            this.description = resultSet.getString("description");
            this.tags = resultSet.getString("tags");
            this.parsedTags = (String[])DbUtils.getArray(resultSet, "parsed_tags", String[].class);
            this.quantity = resultSet.getInt("quantity");
            this.priceNQT = resultSet.getLong("price");
            this.delisted = resultSet.getBoolean("delisted");
            this.timestamp = resultSet.getInt("timestamp");
            this.hasImage = resultSet.getBoolean("has_image");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO goods (id, full_hash, seller_id, name, description, tags, parsed_tags, timestamp, quantity, price, delisted, has_image, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                DbUtils.setBytes(preparedStatement, ++n, this.fullHash);
                preparedStatement.setLong(++n, this.sellerId);
                preparedStatement.setString(++n, this.name);
                preparedStatement.setString(++n, this.description);
                preparedStatement.setString(++n, this.tags);
                DbUtils.setArray(preparedStatement, ++n, this.parsedTags);
                preparedStatement.setInt(++n, this.timestamp);
                preparedStatement.setInt(++n, this.quantity);
                preparedStatement.setLong(++n, this.priceNQT);
                preparedStatement.setBoolean(++n, this.delisted);
                preparedStatement.setBoolean(++n, this.hasImage);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public byte[] getFullHash() {
            return this.fullHash;
        }

        public long getSellerId() {
            return this.sellerId;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTags() {
            return this.tags;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public int getQuantity() {
            return this.quantity;
        }

        private void changeQuantity(int n) {
            if (this.quantity == 0 && n > 0) {
                DigitalGoodsHome.this.addTags(this);
            }
            this.quantity += n;
            if (this.quantity < 0) {
                this.quantity = 0;
            } else if (this.quantity > 1000000000) {
                this.quantity = 1000000000;
            }
            if (this.quantity == 0) {
                DigitalGoodsHome.this.delistTags(this);
            }
            DigitalGoodsHome.this.goodsTable.insert(this);
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }

        private void changePrice(long l) {
            this.priceNQT = l;
            DigitalGoodsHome.this.goodsTable.insert(this);
        }

        public boolean isDelisted() {
            return this.delisted;
        }

        private void setDelisted(boolean bl) {
            this.delisted = bl;
            if (this.quantity > 0) {
                DigitalGoodsHome.this.delistTags(this);
            }
            DigitalGoodsHome.this.goodsTable.insert(this);
        }

        public String[] getParsedTags() {
            return this.parsedTags;
        }

        public boolean hasImage() {
            return this.hasImage;
        }

        public DigitalGoodsHome getDGSHome() {
            return DigitalGoodsHome.this;
        }

        public ChildChain getChildChain() {
            return DigitalGoodsHome.this.childChain;
        }
    }

    public final class Tag {
        private final String tag;
        private final DbKey dbKey;
        private int inStockCount;
        private int totalCount;

        private Tag(String string) {
            this.tag = string;
            this.dbKey = DigitalGoodsHome.this.tagDbKeyFactory.newKey(this.tag);
        }

        private Tag(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.tag = resultSet.getString("tag");
            this.dbKey = dbKey;
            this.inStockCount = resultSet.getInt("in_stock_count");
            this.totalCount = resultSet.getInt("total_count");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO tag (tag, in_stock_count, total_count, height, latest) KEY (tag, height) VALUES (?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setString(++n, this.tag);
                preparedStatement.setInt(++n, this.inStockCount);
                preparedStatement.setInt(++n, this.totalCount);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public String getTag() {
            return this.tag;
        }

        public int getInStockCount() {
            return this.inStockCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }

    public static enum Event {
        GOODS_LISTED,
        GOODS_DELISTED,
        GOODS_PRICE_CHANGE,
        GOODS_QUANTITY_CHANGE,
        PURCHASE,
        DELIVERY,
        REFUND,
        FEEDBACK;

    }
}

