/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import java.util.Map;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Appendix;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.dgs.DelistingAttachment;
import nxt.dgs.DeliveryAttachment;
import nxt.dgs.DigitalGoodsHome;
import nxt.dgs.FeedbackAttachment;
import nxt.dgs.ListingAttachment;
import nxt.dgs.PriceChangeAttachment;
import nxt.dgs.PurchaseAttachment;
import nxt.dgs.QuantityChangeAttachment;
import nxt.dgs.RefundAttachment;
import nxt.dgs.UnencryptedDeliveryAttachment;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.util.Search;
import org.json.simple.JSONObject;

public abstract class DigitalGoodsTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_DIGITAL_GOODS_LISTING = 0;
    private static final byte SUBTYPE_DIGITAL_GOODS_DELISTING = 1;
    private static final byte SUBTYPE_DIGITAL_GOODS_PRICE_CHANGE = 2;
    private static final byte SUBTYPE_DIGITAL_GOODS_QUANTITY_CHANGE = 3;
    private static final byte SUBTYPE_DIGITAL_GOODS_PURCHASE = 4;
    private static final byte SUBTYPE_DIGITAL_GOODS_DELIVERY = 5;
    private static final byte SUBTYPE_DIGITAL_GOODS_FEEDBACK = 6;
    private static final byte SUBTYPE_DIGITAL_GOODS_REFUND = 7;
    public static final TransactionType LISTING = new DigitalGoodsTransactionType(){
        private final Fee DGS_LISTING_FEE = new Fee.SizeBasedFee(20000000L, 20000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                ListingAttachment listingAttachment = (ListingAttachment)transactionImpl.getAttachment();
                return listingAttachment.getName().length() + listingAttachment.getDescription().length();
            }
        };

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.DIGITAL_GOODS_LISTING;
        }

        @Override
        public String getName() {
            return "DigitalGoodsListing";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.DGS_LISTING_FEE;
        }

        @Override
        public ListingAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new ListingAttachment(byteBuffer);
        }

        @Override
        public ListingAttachment parseAttachment(JSONObject jSONObject) {
            return new ListingAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ListingAttachment listingAttachment = (ListingAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getDigitalGoodsHome().listGoods(childTransactionImpl, listingAttachment);
        }

        @Override
        void doValidateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            String string;
            byte[] byArray;
            ListingAttachment listingAttachment = (ListingAttachment)childTransactionImpl.getAttachment();
            if (listingAttachment.getName().length() == 0 || listingAttachment.getName().length() > 100 || listingAttachment.getDescription().length() > 1000 || listingAttachment.getTags().length() > 100 || listingAttachment.getQuantity() < 0 || listingAttachment.getQuantity() > 1000000000 || listingAttachment.getPriceNQT() <= 0L || listingAttachment.getPriceNQT() > 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid digital goods listing: " + listingAttachment.getJSONObject());
            }
            PrunablePlainMessageAppendix prunablePlainMessageAppendix = childTransactionImpl.getPrunablePlainMessage();
            if (!(Constants.DISABLE_METADATA_DETECTION || prunablePlainMessageAppendix == null || Nxt.getBlockchain().getHeight() >= Constants.MISSING_TX_SENDER_BLOCK || (byArray = prunablePlainMessageAppendix.getMessage()) == null || (string = Search.detectMimeType(byArray)) != null && string.startsWith("image/"))) {
                throw new NxtException.NotValidException("Only image attachments allowed for DGS listing, media type is " + string);
            }
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (childTransactionImpl.getChain().getDigitalGoodsHome().getGoods(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate goods id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            return 1.isDuplicate(LISTING, this.getName(), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType DELISTING = new DigitalGoodsTransactionType(){

        @Override
        public final byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.DIGITAL_GOODS_DELISTING;
        }

        @Override
        public String getName() {
            return "DigitalGoodsDelisting";
        }

        @Override
        public DelistingAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new DelistingAttachment(byteBuffer);
        }

        @Override
        public DelistingAttachment parseAttachment(JSONObject jSONObject) {
            return new DelistingAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            DelistingAttachment delistingAttachment = (DelistingAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getDigitalGoodsHome().delistGoods(delistingAttachment.getGoodsId());
        }

        @Override
        void doValidateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            DelistingAttachment delistingAttachment = (DelistingAttachment)childTransactionImpl.getAttachment();
            DigitalGoodsHome.Goods goods = childTransactionImpl.getChain().getDigitalGoodsHome().getGoods(delistingAttachment.getGoodsId());
            if (goods != null && childTransactionImpl.getSenderId() != goods.getSellerId()) {
                throw new NxtException.NotValidException("Invalid digital goods delisting - seller is different: " + delistingAttachment.getJSONObject());
            }
            if (goods == null || goods.isDelisted()) {
                throw new NxtException.NotCurrentlyValidException("Goods " + Long.toUnsignedString(delistingAttachment.getGoodsId()) + "not yet listed or already delisted");
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            DelistingAttachment delistingAttachment = (DelistingAttachment)transaction.getAttachment();
            return 2.isDuplicate(DELISTING, Long.toUnsignedString(delistingAttachment.getGoodsId()), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType PRICE_CHANGE = new DigitalGoodsTransactionType(){

        @Override
        public final byte getSubtype() {
            return 2;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.DIGITAL_GOODS_PRICE_CHANGE;
        }

        @Override
        public String getName() {
            return "DigitalGoodsPriceChange";
        }

        @Override
        public PriceChangeAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new PriceChangeAttachment(byteBuffer);
        }

        @Override
        public PriceChangeAttachment parseAttachment(JSONObject jSONObject) {
            return new PriceChangeAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            PriceChangeAttachment priceChangeAttachment = (PriceChangeAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getDigitalGoodsHome().changePrice(priceChangeAttachment.getGoodsId(), priceChangeAttachment.getPriceNQT());
        }

        @Override
        void doValidateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            PriceChangeAttachment priceChangeAttachment = (PriceChangeAttachment)childTransactionImpl.getAttachment();
            DigitalGoodsHome.Goods goods = childTransactionImpl.getChain().getDigitalGoodsHome().getGoods(priceChangeAttachment.getGoodsId());
            if (priceChangeAttachment.getPriceNQT() <= 0L || priceChangeAttachment.getPriceNQT() > 100000000000000000L || goods != null && childTransactionImpl.getSenderId() != goods.getSellerId()) {
                throw new NxtException.NotValidException("Invalid digital goods price change: " + priceChangeAttachment.getJSONObject());
            }
            if (goods == null || goods.isDelisted()) {
                throw new NxtException.NotCurrentlyValidException("Goods " + Long.toUnsignedString(priceChangeAttachment.getGoodsId()) + "not yet listed or already delisted");
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            PriceChangeAttachment priceChangeAttachment = (PriceChangeAttachment)transaction.getAttachment();
            return 3.isDuplicate(DELISTING, Long.toUnsignedString(priceChangeAttachment.getGoodsId()), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType QUANTITY_CHANGE = new DigitalGoodsTransactionType(){

        @Override
        public final byte getSubtype() {
            return 3;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.DIGITAL_GOODS_QUANTITY_CHANGE;
        }

        @Override
        public String getName() {
            return "DigitalGoodsQuantityChange";
        }

        @Override
        public QuantityChangeAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new QuantityChangeAttachment(byteBuffer);
        }

        @Override
        public QuantityChangeAttachment parseAttachment(JSONObject jSONObject) {
            return new QuantityChangeAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            QuantityChangeAttachment quantityChangeAttachment = (QuantityChangeAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getDigitalGoodsHome().changeQuantity(quantityChangeAttachment.getGoodsId(), quantityChangeAttachment.getDeltaQuantity());
        }

        @Override
        void doValidateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            QuantityChangeAttachment quantityChangeAttachment = (QuantityChangeAttachment)childTransactionImpl.getAttachment();
            DigitalGoodsHome.Goods goods = childTransactionImpl.getChain().getDigitalGoodsHome().getGoods(quantityChangeAttachment.getGoodsId());
            if (quantityChangeAttachment.getDeltaQuantity() < -1000000000 || quantityChangeAttachment.getDeltaQuantity() > 1000000000 || goods != null && childTransactionImpl.getSenderId() != goods.getSellerId()) {
                throw new NxtException.NotValidException("Invalid digital goods quantity change: " + quantityChangeAttachment.getJSONObject());
            }
            if (goods == null || goods.isDelisted()) {
                throw new NxtException.NotCurrentlyValidException("Goods " + Long.toUnsignedString(quantityChangeAttachment.getGoodsId()) + "not yet listed or already delisted");
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            QuantityChangeAttachment quantityChangeAttachment = (QuantityChangeAttachment)transaction.getAttachment();
            return 4.isDuplicate(DELISTING, Long.toUnsignedString(quantityChangeAttachment.getGoodsId()), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType PURCHASE = new DigitalGoodsTransactionType(){

        @Override
        public final byte getSubtype() {
            return 4;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.DIGITAL_GOODS_PURCHASE;
        }

        @Override
        public String getName() {
            return "DigitalGoodsPurchase";
        }

        @Override
        public PurchaseAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new PurchaseAttachment(byteBuffer);
        }

        @Override
        public PurchaseAttachment parseAttachment(JSONObject jSONObject) {
            return new PurchaseAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            PurchaseAttachment purchaseAttachment = (PurchaseAttachment)childTransactionImpl.getAttachment();
            if (childTransactionImpl.getChain().getBalanceHome().getBalance(account.getId()).getUnconfirmedBalance() >= Math.multiplyExact((long)purchaseAttachment.getQuantity(), purchaseAttachment.getPriceNQT())) {
                account.addToUnconfirmedBalance(childTransactionImpl.getChain(), this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), -Math.multiplyExact((long)purchaseAttachment.getQuantity(), purchaseAttachment.getPriceNQT()));
                return true;
            }
            return false;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            PurchaseAttachment purchaseAttachment = (PurchaseAttachment)childTransactionImpl.getAttachment();
            account.addToUnconfirmedBalance(childTransactionImpl.getChain(), this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), Math.multiplyExact((long)purchaseAttachment.getQuantity(), purchaseAttachment.getPriceNQT()));
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            PurchaseAttachment purchaseAttachment = (PurchaseAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getDigitalGoodsHome().purchase(childTransactionImpl, purchaseAttachment);
        }

        @Override
        void doValidateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            PurchaseAttachment purchaseAttachment = (PurchaseAttachment)childTransactionImpl.getAttachment();
            DigitalGoodsHome.Goods goods = childTransactionImpl.getChain().getDigitalGoodsHome().getGoods(purchaseAttachment.getGoodsId());
            if (purchaseAttachment.getQuantity() <= 0 || purchaseAttachment.getQuantity() > 1000000000 || purchaseAttachment.getPriceNQT() <= 0L || purchaseAttachment.getPriceNQT() > 100000000000000000L || goods != null && goods.getSellerId() != childTransactionImpl.getRecipientId()) {
                throw new NxtException.NotValidException("Invalid digital goods purchase: " + purchaseAttachment.getJSONObject());
            }
            if (childTransactionImpl.getEncryptedMessage() != null && !childTransactionImpl.getEncryptedMessage().isText()) {
                throw new NxtException.NotValidException("Only text encrypted messages allowed");
            }
            if (goods == null || goods.isDelisted()) {
                throw new NxtException.NotCurrentlyValidException("Goods " + Long.toUnsignedString(purchaseAttachment.getGoodsId()) + "not yet listed or already delisted");
            }
            if (purchaseAttachment.getQuantity() > goods.getQuantity() || purchaseAttachment.getPriceNQT() != goods.getPriceNQT()) {
                throw new NxtException.NotCurrentlyValidException("Goods price or quantity changed: " + purchaseAttachment.getJSONObject());
            }
            if (purchaseAttachment.getDeliveryDeadlineTimestamp() <= Nxt.getBlockchain().getLastBlockTimestamp()) {
                throw new NxtException.NotCurrentlyValidException("Delivery deadline has already expired: " + purchaseAttachment.getDeliveryDeadlineTimestamp());
            }
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (childTransactionImpl.getChain().getDigitalGoodsHome().getPurchase(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate purchase id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            PurchaseAttachment purchaseAttachment = (PurchaseAttachment)transaction.getAttachment();
            return 5.isDuplicate(DELISTING, Long.toUnsignedString(purchaseAttachment.getGoodsId()), map, false);
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType DELIVERY = new DigitalGoodsTransactionType(){
        private final Fee DGS_DELIVERY_FEE = new Fee.SizeBasedFee(10000000L, 20000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                DeliveryAttachment deliveryAttachment = (DeliveryAttachment)transactionImpl.getAttachment();
                return deliveryAttachment.getGoodsDataLength() - 16;
            }
        };

        @Override
        public final byte getSubtype() {
            return 5;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.DIGITAL_GOODS_DELIVERY;
        }

        @Override
        public String getName() {
            return "DigitalGoodsDelivery";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.DGS_DELIVERY_FEE;
        }

        @Override
        public DeliveryAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new DeliveryAttachment(byteBuffer);
        }

        @Override
        public DeliveryAttachment parseAttachment(JSONObject jSONObject) {
            if (jSONObject.get((Object)"goodsData") == null) {
                return new UnencryptedDeliveryAttachment(jSONObject);
            }
            return new DeliveryAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            DeliveryAttachment deliveryAttachment = (DeliveryAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getDigitalGoodsHome().deliver(childTransactionImpl, deliveryAttachment);
        }

        @Override
        void doValidateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            DeliveryAttachment deliveryAttachment = (DeliveryAttachment)childTransactionImpl.getAttachment();
            DigitalGoodsHome.Purchase purchase = childTransactionImpl.getChain().getDigitalGoodsHome().getPendingPurchase(deliveryAttachment.getPurchaseId());
            if (deliveryAttachment.getGoodsDataLength() > 1000) {
                throw new NxtException.NotValidException("Invalid digital goods delivery data length: " + deliveryAttachment.getGoodsDataLength());
            }
            if (deliveryAttachment.getGoods() != null && (deliveryAttachment.getGoods().getData().length == 0 || deliveryAttachment.getGoods().getNonce().length != 32)) {
                throw new NxtException.NotValidException("Invalid digital goods delivery: " + deliveryAttachment.getJSONObject());
            }
            if (deliveryAttachment.getDiscountNQT() < 0L || deliveryAttachment.getDiscountNQT() > 100000000000000000L || purchase != null && (purchase.getBuyerId() != childTransactionImpl.getRecipientId() || childTransactionImpl.getSenderId() != purchase.getSellerId() || deliveryAttachment.getDiscountNQT() > Math.multiplyExact(purchase.getPriceNQT(), (long)purchase.getQuantity()))) {
                throw new NxtException.NotValidException("Invalid digital goods delivery: " + deliveryAttachment.getJSONObject());
            }
            if (purchase == null || purchase.getEncryptedGoods() != null) {
                throw new NxtException.NotCurrentlyValidException("Purchase does not exist yet, or already delivered: " + deliveryAttachment.getJSONObject());
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            DeliveryAttachment deliveryAttachment = (DeliveryAttachment)transaction.getAttachment();
            return 6.isDuplicate(DELIVERY, Long.toUnsignedString(deliveryAttachment.getPurchaseId()), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType FEEDBACK = new DigitalGoodsTransactionType(){

        @Override
        public final byte getSubtype() {
            return 6;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.DIGITAL_GOODS_FEEDBACK;
        }

        @Override
        public String getName() {
            return "DigitalGoodsFeedback";
        }

        @Override
        public FeedbackAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new FeedbackAttachment(byteBuffer);
        }

        @Override
        public FeedbackAttachment parseAttachment(JSONObject jSONObject) {
            return new FeedbackAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            FeedbackAttachment feedbackAttachment = (FeedbackAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getDigitalGoodsHome().feedback(feedbackAttachment.getPurchaseId(), childTransactionImpl.getEncryptedMessage(), childTransactionImpl.getMessage());
        }

        @Override
        void doValidateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            FeedbackAttachment feedbackAttachment = (FeedbackAttachment)childTransactionImpl.getAttachment();
            DigitalGoodsHome.Purchase purchase = childTransactionImpl.getChain().getDigitalGoodsHome().getPurchase(feedbackAttachment.getPurchaseId());
            if (purchase != null && (purchase.getSellerId() != childTransactionImpl.getRecipientId() || childTransactionImpl.getSenderId() != purchase.getBuyerId())) {
                throw new NxtException.NotValidException("Invalid digital goods feedback: " + feedbackAttachment.getJSONObject());
            }
            if (childTransactionImpl.getEncryptedMessage() == null && childTransactionImpl.getMessage() == null) {
                throw new NxtException.NotValidException("Missing feedback message");
            }
            if (childTransactionImpl.getEncryptedMessage() != null && !childTransactionImpl.getEncryptedMessage().isText()) {
                throw new NxtException.NotValidException("Only text encrypted messages allowed");
            }
            if (childTransactionImpl.getMessage() != null && !childTransactionImpl.getMessage().isText()) {
                throw new NxtException.NotValidException("Only text public messages allowed");
            }
            if (purchase == null || purchase.getEncryptedGoods() == null) {
                throw new NxtException.NotCurrentlyValidException("Purchase does not exist yet or not yet delivered");
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType REFUND = new DigitalGoodsTransactionType(){

        @Override
        public final byte getSubtype() {
            return 7;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.DIGITAL_GOODS_REFUND;
        }

        @Override
        public String getName() {
            return "DigitalGoodsRefund";
        }

        @Override
        public RefundAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new RefundAttachment(byteBuffer);
        }

        @Override
        public RefundAttachment parseAttachment(JSONObject jSONObject) {
            return new RefundAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            RefundAttachment refundAttachment = (RefundAttachment)childTransactionImpl.getAttachment();
            if (childTransactionImpl.getChain().getBalanceHome().getBalance(account.getId()).getUnconfirmedBalance() >= refundAttachment.getRefundNQT()) {
                account.addToUnconfirmedBalance(childTransactionImpl.getChain(), this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), -refundAttachment.getRefundNQT());
                return true;
            }
            return false;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            RefundAttachment refundAttachment = (RefundAttachment)childTransactionImpl.getAttachment();
            account.addToUnconfirmedBalance(childTransactionImpl.getChain(), this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), refundAttachment.getRefundNQT());
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            RefundAttachment refundAttachment = (RefundAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getDigitalGoodsHome().refund(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), childTransactionImpl.getSenderId(), refundAttachment.getPurchaseId(), refundAttachment.getRefundNQT(), childTransactionImpl.getEncryptedMessage());
        }

        @Override
        void doValidateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            RefundAttachment refundAttachment = (RefundAttachment)childTransactionImpl.getAttachment();
            DigitalGoodsHome.Purchase purchase = childTransactionImpl.getChain().getDigitalGoodsHome().getPurchase(refundAttachment.getPurchaseId());
            if (refundAttachment.getRefundNQT() < 0L || refundAttachment.getRefundNQT() > 100000000000000000L || purchase != null && (purchase.getBuyerId() != childTransactionImpl.getRecipientId() || childTransactionImpl.getSenderId() != purchase.getSellerId())) {
                throw new NxtException.NotValidException("Invalid digital goods refund: " + refundAttachment.getJSONObject());
            }
            if (childTransactionImpl.getEncryptedMessage() != null && !childTransactionImpl.getEncryptedMessage().isText()) {
                throw new NxtException.NotValidException("Only text encrypted messages allowed");
            }
            if (purchase == null || purchase.getEncryptedGoods() == null || purchase.getRefundNQT() != 0L) {
                throw new NxtException.NotCurrentlyValidException("Purchase does not exist or is not delivered or is already refunded");
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            RefundAttachment refundAttachment = (RefundAttachment)transaction.getAttachment();
            return 8.isDuplicate(REFUND, Long.toUnsignedString(refundAttachment.getPurchaseId()), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return LISTING;
            }
            case 1: {
                return DELISTING;
            }
            case 2: {
                return PRICE_CHANGE;
            }
            case 3: {
                return QUANTITY_CHANGE;
            }
            case 4: {
                return PURCHASE;
            }
            case 5: {
                return DELIVERY;
            }
            case 6: {
                return FEEDBACK;
            }
            case 7: {
                return REFUND;
            }
        }
        return null;
    }

    private DigitalGoodsTransactionType() {
    }

    @Override
    public final byte getType() {
        return 3;
    }

    @Override
    public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        return true;
    }

    @Override
    public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
    }

    @Override
    public final void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
        if (childTransactionImpl.getAmount() != 0L) {
            throw new NxtException.NotValidException("Invalid digital goods transaction");
        }
        this.doValidateAttachment(childTransactionImpl);
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }

    abstract void doValidateAttachment(ChildTransactionImpl var1) throws NxtException.ValidationException;
}

