/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class PurchaseAttachment
extends Attachment.AbstractAttachment {
    private final long goodsId;
    private final int quantity;
    private final long priceNQT;
    private final int deliveryDeadlineTimestamp;

    PurchaseAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.goodsId = byteBuffer.getLong();
        this.quantity = byteBuffer.getInt();
        this.priceNQT = byteBuffer.getLong();
        this.deliveryDeadlineTimestamp = byteBuffer.getInt();
    }

    PurchaseAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.goodsId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"goods"));
        this.quantity = ((Long)jSONObject.get((Object)"quantity")).intValue();
        this.priceNQT = Convert.parseLong(jSONObject.get((Object)"priceNQT"));
        this.deliveryDeadlineTimestamp = ((Long)jSONObject.get((Object)"deliveryDeadlineTimestamp")).intValue();
    }

    public PurchaseAttachment(long l, int n, long l2, int n2) {
        this.goodsId = l;
        this.quantity = n;
        this.priceNQT = l2;
        this.deliveryDeadlineTimestamp = n2;
    }

    @Override
    protected int getMySize() {
        return 24;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.goodsId);
        byteBuffer.putInt(this.quantity);
        byteBuffer.putLong(this.priceNQT);
        byteBuffer.putInt(this.deliveryDeadlineTimestamp);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"goods", (Object)Long.toUnsignedString(this.goodsId));
        jSONObject.put((Object)"quantity", (Object)this.quantity);
        jSONObject.put((Object)"priceNQT", (Object)this.priceNQT);
        jSONObject.put((Object)"deliveryDeadlineTimestamp", (Object)this.deliveryDeadlineTimestamp);
    }

    @Override
    public TransactionType getTransactionType() {
        return DigitalGoodsTransactionType.PURCHASE;
    }

    public long getGoodsId() {
        return this.goodsId;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public long getPriceNQT() {
        return this.priceNQT;
    }

    public int getDeliveryDeadlineTimestamp() {
        return this.deliveryDeadlineTimestamp;
    }
}

