/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class RefundAttachment
extends Attachment.AbstractAttachment {
    private final long purchaseId;
    private final long refundNQT;

    RefundAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.purchaseId = byteBuffer.getLong();
        this.refundNQT = byteBuffer.getLong();
    }

    RefundAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.purchaseId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"purchase"));
        this.refundNQT = Convert.parseLong(jSONObject.get((Object)"refundNQT"));
    }

    public RefundAttachment(long l, long l2) {
        this.purchaseId = l;
        this.refundNQT = l2;
    }

    @Override
    protected int getMySize() {
        return 16;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.purchaseId);
        byteBuffer.putLong(this.refundNQT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"purchase", (Object)Long.toUnsignedString(this.purchaseId));
        jSONObject.put((Object)"refundNQT", (Object)this.refundNQT);
    }

    @Override
    public TransactionType getTransactionType() {
        return DigitalGoodsTransactionType.REFUND;
    }

    public long getPurchaseId() {
        return this.purchaseId;
    }

    public long getRefundNQT() {
        return this.refundNQT;
    }
}

