/*
 * Decompiled with CFR 0.152.
 */
package nxt.freeze;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Nxt;
import nxt.account.HoldingType;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;

class HoldingFreeze {
    private static final DbKey.LongStringKeyFactory<HoldingFreeze> DB_KEY_FACTORY = new DbKey.LongStringKeyFactory<HoldingFreeze>("holding_id", "holding_type"){

        @Override
        public DbKey newKey(HoldingFreeze holdingFreeze) {
            return holdingFreeze.dbKey;
        }
    };
    private static final VersionedEntityDbTable<HoldingFreeze> DB_TABLE = new VersionedEntityDbTable<HoldingFreeze>("public.holding_freeze", DB_KEY_FACTORY){

        @Override
        protected HoldingFreeze load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new HoldingFreeze(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, HoldingFreeze holdingFreeze) throws SQLException {
            holdingFreeze.save(connection);
        }
    };
    private final DbKey dbKey;
    private final HoldingType holdingType;
    private final long holdingId;
    private final int minHeight;
    private int actualHeight;
    private int height;

    static void init() {
    }

    HoldingFreeze(long l, HoldingType holdingType, int n, int n2) {
        this.dbKey = DB_KEY_FACTORY.newKey(l, holdingType.name());
        this.holdingId = l;
        this.holdingType = holdingType;
        this.minHeight = n;
        this.actualHeight = n2;
        this.height = -1;
    }

    private HoldingFreeze(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.dbKey = dbKey;
        this.holdingId = resultSet.getLong("holding_id");
        this.holdingType = HoldingType.valueOf(resultSet.getString("holding_type"));
        this.minHeight = resultSet.getInt("min_height");
        this.actualHeight = resultSet.getInt("actual_height");
        this.height = resultSet.getInt("height");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO holding_freeze  (holding_id, holding_type, min_height, actual_height, height, latest)  KEY (holding_id, holding_type, height) VALUES (?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.holdingId);
            preparedStatement.setString(++n, this.holdingType.name());
            preparedStatement.setInt(++n, this.minHeight);
            preparedStatement.setInt(++n, this.actualHeight);
            preparedStatement.setInt(++n, this.height);
            preparedStatement.executeUpdate();
        }
    }

    static HoldingFreeze getById(long l, HoldingType holdingType) {
        return (HoldingFreeze)DB_TABLE.get(DB_KEY_FACTORY.newKey(l, holdingType.name()));
    }

    static void insert(HoldingFreeze holdingFreeze) {
        DB_TABLE.insert(holdingFreeze);
    }

    static DbIterator<HoldingFreeze> getAll() {
        return DB_TABLE.getAll(0, -1);
    }

    static DbIterator<HoldingFreeze> getFreezes(HoldingType holdingType, int n) {
        DbClause dbClause = new DbClause.IntClause("actual_height", n).and(new DbClause.StringClause("holding_type", holdingType.name()));
        return DB_TABLE.getManyBy(dbClause, -1, -1);
    }

    static DbIterator<HoldingFreeze> getFreezes(int n) {
        DbClause.IntClause intClause = new DbClause.IntClause("actual_height", n);
        return DB_TABLE.getManyBy(intClause, -1, -1);
    }

    long getHoldingId() {
        return this.holdingId;
    }

    int getMinHeight() {
        return this.minHeight;
    }

    int getActualHeight() {
        return this.actualHeight;
    }

    HoldingType getHoldingType() {
        return this.holdingType;
    }

    void setActualHeight(int n) {
        this.actualHeight = n;
        this.height = Nxt.getBlockchain().getHeight();
    }

    boolean isFrozen(int n) {
        return this.actualHeight != 0 && this.actualHeight <= n;
    }

    public String toString() {
        return "HoldingFreeze{holdingId=" + this.holdingId + ", holdingType=" + (Object)((Object)this.holdingType) + ", minHeight=" + this.minHeight + ", actualHeight=" + this.actualHeight + '}';
    }
}

