/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nxt.http.API;
import nxt.http.APIConnector;
import nxt.http.APIServlet;
import nxt.http.MockedRequest;
import nxt.http.MockedResponse;
import nxt.util.Logger;

public class APIInProcessConnector
implements APIConnector {
    private final Map<String, List<String>> params;
    private final Map<String, byte[]> parts;

    APIInProcessConnector(Map<String, List<String>> map, Map<String, byte[]> map2) {
        this.params = map;
        this.parts = map2;
    }

    @Override
    public InputStream getInputStream() {
        this.logRequestParameters();
        MockedRequest mockedRequest = new MockedRequest(this.params, this.parts);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MockedResponse mockedResponse = new MockedResponse(byteArrayOutputStream);
        try {
            APIServlet aPIServlet = new APIServlet();
            aPIServlet.doPost(mockedRequest, mockedResponse);
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private void logRequestParameters() {
        if (!Logger.isInfoEnabled()) {
            Logger.logInfoMessage("%s", this.params.get("requestType"));
            return;
        }
        String string = this.params.entrySet().stream().map(entry -> {
            if (API.SENSITIVE_PARAMS.contains(entry.getKey())) {
                return (String)entry.getKey() + "={hidden}";
            }
            if (((List)entry.getValue()).size() == 1) {
                return (String)entry.getKey() + "=" + (String)((List)entry.getValue()).get(0);
            }
            return (String)entry.getKey() + "=" + ((List)entry.getValue()).toString();
        }).collect(Collectors.joining("&"));
        Logger.logInfoMessage("%s: request %s", this.params.get("requestType"), string);
    }
}

