/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Constants;
import nxt.http.API;
import nxt.http.APIProxy;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.util.Convert;

public class APITestServlet
extends HttpServlet {
    private static final String header1 = "<!DOCTYPE html>\n<html>\n<head>\n    <meta charset='UTF-8'/>\n    <meta http-equiv='X-UA-Compatible' content='IE=edge'>\n    <meta name='viewport' content='width=device-width, initial-scale=1'>\n    <title>Ardor http API</title>\n    <link href='css/bootstrap.min.css' rel='stylesheet' type='text/css' />\n    <link href='css/font-awesome.min.css' rel='stylesheet' type='text/css' />\n    <link href='css/highlight.style.css' rel='stylesheet' type='text/css' />\n    <style type='text/css'>\n        table {border-collapse: collapse;}\n        td {padding: 10px;}\n        .result {white-space: pre; font-family: monospace; overflow: auto;}\n    </style>\n</head>\n<body>\n<div class='navbar navbar-default' role='navigation'>\n   <div class='container' style='min-width: 90%;'>\n       <div class='navbar-header'>\n           <a class='navbar-brand' href='/test'>Ardor http API</a>\n       </div>\n       <div class='navbar-collapse collapse'>\n           <ul class='nav navbar-nav navbar-right'>\n               <li><input type='text' class='form-control' id='nodeType'                     readonly style='margin-top:8px;'></li>\n               <li><input type='text' class='form-control' id='servletPath'                     readonly style='margin-top:8px;'></li>\n               <li><input type='text' class='form-control' id='search'                     placeholder='Search' style='margin-top:8px;'></li>\n               <li><a href='https://ardordocs.jelurida.com/API' target='_blank' style='margin-left:20px;'>Wiki Docs</a></li>\n           </ul>\n       </div>\n   </div>\n</div>\n<div class='container' style='min-width: 90%;'>\n<div class='row'>\n  <div class='col-xs-12' style='margin-bottom:10px;'>\n    <div class='pull-right'>\n      <div class='btn-group'>\n        <button type='button' class='btn btn-default btn-sm dropdown-toggle' data-toggle='dropdown'>\n          <i class='fa fa-check-circle-o'></i> <i class='fa fa-circle-o'></i>\n        </button>\n        <ul class='dropdown-menu' role='menu' style='font-size:12px;'>\n          <li><a href='#' id='navi-select-all-d-add-btn'>Select All Displayed (Add)</a></li>\n          <li><a href='#' id='navi-select-all-d-replace-btn'>Select All Displayed (Replace)</a></li>\n          <li><a href='#' id='navi-deselect-all-d-btn'>Deselect All Displayed</a></li>\n          <li><a href='#' id='navi-deselect-all-btn'>Deselect All</a></li>\n        </ul>\n      </div>\n      <button type='button' id='navi-show-fields' data-navi-val='ALL' class='btn btn-default btn-sm' style='width:165px;'>Show Non-Empty Fields</button>\n      <button type='button' id='navi-show-tabs' data-navi-val='ALL' class='btn btn-default btn-sm' style='width:130px;'>Show Open Tabs</button>\n    </div>\n  </div>\n</div>\n<div class='row' style='margin-bottom:15px;'>\n<div class='col-xs-4 col-sm-3 col-md-2'>\n<ul class='nav nav-pills nav-stacked'>\n";
    private static final String header2 = "</ul>\n</div> <!-- col --><div  class='col-xs-8 col-sm-9 col-md-10'>\n<div class='panel-group' id='accordion'>\n";
    private static final String footer1 = "</div> <!-- panel-group -->\n</div> <!-- col -->\n</div> <!-- row -->\n</div> <!-- container -->\n<script src='js/3rdparty/jquery.js'></script>\n<script src='js/3rdparty/bootstrap.js' type='text/javascript'></script>\n<script src='js/3rdparty/highlight.pack.js' type='text/javascript'></script>\n<script src='js/ats.js' type='text/javascript'></script>\n<script src='js/ats.util.js' type='text/javascript'></script>\n<script>\n$(document).ready(function() {";
    private static final String footer2 = "});\n</script>\n</body>\n</html>\n";
    private static final List<String> allRequestTypes = new ArrayList<String>(APIServlet.apiRequestHandlers.keySet());
    private static final SortedMap<String, SortedSet<String>> requestTags;

    private static String buildLinks(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("requestTag"));
        stringBuilder.append("<li");
        if (string.equals("") & !httpServletRequest.getParameterMap().containsKey("requestType") & !httpServletRequest.getParameterMap().containsKey("requestTypes")) {
            stringBuilder.append(" class='active'");
        }
        stringBuilder.append("><a href='/test'>ALL</a></li>\n");
        stringBuilder.append("<li");
        if (httpServletRequest.getParameterMap().containsKey("requestTypes")) {
            stringBuilder.append(" class='active'");
        }
        stringBuilder.append("><a href='/test?requestTypes=' id='navi-selected'>SELECTED</a></li>\n");
        for (APITag aPITag : APITag.values()) {
            if (requestTags.get(aPITag.name()) == null) continue;
            stringBuilder.append("<li");
            if (string.equals(aPITag.name())) {
                stringBuilder.append(" class='active'");
            }
            stringBuilder.append("><a href='/test?requestTag=").append(aPITag.name()).append("'>");
            stringBuilder.append(aPITag.getDisplayName()).append("</a></li>\n");
        }
        return stringBuilder.toString();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        if (API.isForbiddenHost(httpServletRequest.getRemoteHost())) {
            httpServletResponse.sendError(403);
            return;
        }
        try (PrintWriter printWriter = httpServletResponse.getWriter();){
            printWriter.print(header1);
            printWriter.print(APITestServlet.buildLinks(httpServletRequest));
            printWriter.print(header2);
            String string = Convert.nullToEmpty(httpServletRequest.getParameter("requestType"));
            APIServlet.APIRequestHandler aPIRequestHandler = APIServlet.apiRequestHandlers.get(string);
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "Full Node";
            if (Constants.isLightClient) {
                string2 = "Light Client";
            } else if (APIProxy.enableAPIProxy) {
                string2 = "Roaming Client";
            }
            stringBuilder.append("    $('#nodeType').val('").append(string2).append("');");
            stringBuilder.append("    $('#servletPath').val('").append(httpServletRequest.getServletPath()).append("');");
            if (aPIRequestHandler != null) {
                printWriter.print(APITestServlet.form(httpServletRequest, string, true, aPIRequestHandler));
                stringBuilder.append("    ATS.apiCalls.push('").append(string).append("');\n");
            } else if (!httpServletRequest.getParameterMap().containsKey("requestTypes")) {
                String string3 = Convert.nullToEmpty(httpServletRequest.getParameter("requestTag"));
                Set set = (Set)requestTags.get(string3);
                for (String string4 : set != null ? set : allRequestTypes) {
                    aPIRequestHandler = APIServlet.apiRequestHandlers.get(string4);
                    printWriter.print(APITestServlet.form(httpServletRequest, string4, false, aPIRequestHandler));
                    stringBuilder.append("    ATS.apiCalls.push('").append(string4).append("');\n");
                }
            } else {
                String string5 = Convert.nullToEmpty(httpServletRequest.getParameter("requestTypes"));
                if (!string5.equals("")) {
                    TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(string5.split("_")));
                    for (String string6 : treeSet) {
                        aPIRequestHandler = APIServlet.apiRequestHandlers.get(string6);
                        printWriter.print(APITestServlet.form(httpServletRequest, string6, false, aPIRequestHandler));
                        stringBuilder.append("    ATS.apiCalls.push('").append(string6).append("');\n");
                    }
                } else {
                    printWriter.print("<div class='alert alert-info' role='alert'>No API calls selected.</div>\n");
                }
            }
            printWriter.print(footer1);
            printWriter.print(stringBuilder.toString());
            printWriter.print(footer2);
        }
    }

    private static String form(HttpServletRequest httpServletRequest, String string, boolean bl, APIServlet.APIRequestHandler aPIRequestHandler) {
        List<String> list = aPIRequestHandler.getParameters();
        boolean bl2 = aPIRequestHandler.requirePost();
        String string2 = aPIRequestHandler.getFileParameter();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class='panel panel-default api-call-All' ");
        stringBuilder.append("id='api-call-").append(string).append("'>\n");
        stringBuilder.append("<div class='panel-heading'>\n");
        stringBuilder.append("<h4 class='panel-title'>\n");
        stringBuilder.append("<a data-toggle='collapse' class='collapse-link' data-target='#collapse").append(string).append("' href='#'>");
        stringBuilder.append(string);
        stringBuilder.append("</a>\n");
        stringBuilder.append("<span style='float:right;font-weight:normal;font-size:14px;'>\n");
        if (!bl) {
            stringBuilder.append("<a href='/test?requestType=").append(string);
            stringBuilder.append("' target='_blank' style='font-weight:normal;font-size:14px;color:#777;'><span class='glyphicon glyphicon-new-window'></span></a>");
            stringBuilder.append(" &nbsp;&nbsp;\n");
        }
        stringBuilder.append("<a style='font-weight:normal;font-size:14px;color:#777;' href='");
        stringBuilder.append("https://ardordocs.jelurida.com/");
        stringBuilder.append(aPIRequestHandler.getDocsUrlPath());
        stringBuilder.append("' target='_blank'>wiki</a>&nbsp;&nbsp;\n");
        stringBuilder.append("&nbsp;&nbsp;&nbsp;\n<input type='checkbox' class='api-call-sel-ALL' ");
        stringBuilder.append("id='api-call-sel-").append(string).append("'>\n");
        stringBuilder.append("</span>\n");
        stringBuilder.append("</h4>\n");
        stringBuilder.append("</div> <!-- panel-heading -->\n");
        stringBuilder.append("<div id='collapse").append(string).append("' class='panel-collapse collapse");
        if (bl) {
            stringBuilder.append(" in");
        }
        stringBuilder.append("'>\n");
        stringBuilder.append("<div class='panel-body'>\n");
        String string3 = httpServletRequest.getServletPath();
        String string4 = "/test-proxy".equals(string3) ? "/nxt-proxy" : "/nxt";
        stringBuilder.append("<form action='").append(string4).append("' method='POST' ");
        if (string2 != null) {
            stringBuilder.append("enctype='multipart/form-data' ");
        }
        stringBuilder.append("onsubmit='return ATS.submitForm(this");
        if (string2 != null) {
            stringBuilder.append(", \"").append(string2).append("\"");
        }
        stringBuilder.append(")'>\n");
        stringBuilder.append("<input type='hidden' id='formAction' value='").append(string4).append("'/>\n");
        stringBuilder.append("<input type='hidden' name='requestType' value='").append(string).append("'/>\n");
        stringBuilder.append("<div class='col-xs-12 col-lg-6' style='min-width: 40%;'>\n");
        stringBuilder.append("<table class='table'>\n");
        if (string2 != null) {
            stringBuilder.append("<tr class='api-call-input-tr'>\n");
            stringBuilder.append("<td>").append(string2).append(":</td>\n");
            stringBuilder.append("<td><input type='file' name='").append(string2).append("' id='").append(string2).append(string).append("' ");
            stringBuilder.append("style='width:100%;min-width:200px;'/></td>\n");
            stringBuilder.append("</tr>\n");
        }
        int n = 0;
        String string5 = null;
        for (String string6 : list) {
            stringBuilder.append("<tr class='api-call-input-tr'>\n");
            stringBuilder.append("<td>").append(string6).append(":</td>\n");
            if (APITestServlet.isTextArea(string6, aPIRequestHandler)) {
                stringBuilder.append("<td><textarea ");
            } else {
                stringBuilder.append("<td><input type='").append(APITestServlet.isPassword(string6, aPIRequestHandler) ? "password" : "text").append("' ");
            }
            stringBuilder.append("name='").append(string6).append("' ");
            n = string6.equals(string5) ? ++n : 0;
            string5 = string6;
            String[] stringArray = httpServletRequest.getParameterValues(string6);
            String string7 = Convert.emptyToNull(stringArray != null && n < stringArray.length ? stringArray[n] : null);
            if (string7 != null) {
                stringBuilder.append("value='").append(string7.replace("'", "&quot;")).append("' ");
            }
            stringBuilder.append("style='width:100%;min-width:200px;'");
            if (APITestServlet.isTextArea(string6, aPIRequestHandler)) {
                stringBuilder.append("></textarea></td>\n");
            } else {
                stringBuilder.append("/></td>\n");
            }
            stringBuilder.append("</tr>\n");
        }
        stringBuilder.append("<tr>\n");
        stringBuilder.append("<td colspan='2'><input type='submit' class='btn btn-default' value='submit'/></td>\n");
        stringBuilder.append("</tr>\n");
        stringBuilder.append("</table>\n");
        stringBuilder.append("</div>\n");
        stringBuilder.append("<div class='col-xs-12 col-lg-6' style='min-width: 50%;'>\n");
        stringBuilder.append("<h5 style='margin-top:0px;'>\n");
        if (bl2) {
            stringBuilder.append("<span style='float:right;' class='postman-link'>");
            stringBuilder.append("</span>\n");
        } else {
            stringBuilder.append("<span style='float:right;' class='uri-link'>");
            stringBuilder.append("</span>\n");
        }
        stringBuilder.append("Response</h5>\n");
        stringBuilder.append("<pre class='hljs json'><code class='result'>JSON response</code></pre>\n");
        stringBuilder.append("</div>\n");
        stringBuilder.append("</form>\n");
        stringBuilder.append("</div> <!-- panel-body -->\n");
        stringBuilder.append("</div> <!-- panel-collapse -->\n");
        stringBuilder.append("</div> <!-- panel -->\n");
        return stringBuilder.toString();
    }

    private static boolean isPassword(String string, APIServlet.APIRequestHandler aPIRequestHandler) {
        return "secretPhrase".equals(string) || "adminPassword".equals(string) || "recipientSecretPhrase".equals(string) || aPIRequestHandler.isPassword(string);
    }

    private static boolean isTextArea(String string, APIServlet.APIRequestHandler aPIRequestHandler) {
        return aPIRequestHandler.isTextArea(string);
    }

    static void initClass() {
    }

    static {
        Collections.sort(allRequestTypes);
        requestTags = new TreeMap<String, SortedSet<String>>();
        for (Map.Entry<String, APIServlet.APIRequestHandler> entry : APIServlet.apiRequestHandlers.entrySet()) {
            String string2 = entry.getKey();
            Set<APITag> set = entry.getValue().getAPITags();
            for (APITag aPITag : set) {
                SortedSet sortedSet = requestTags.computeIfAbsent(aPITag.name(), string -> new TreeSet());
                sortedSet.add(string2);
            }
        }
    }
}

