/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.crypto.SecretSharingGenerator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class CombineSecret
extends APIServlet.APIRequestHandler {
    static final CombineSecret instance = new CombineSecret();

    private CombineSecret() {
        super(new APITag[]{APITag.UTILS}, "pieces", "pieces", "pieces");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String[] stringArray = httpServletRequest.getParameterValues("pieces");
        if (stringArray == null) {
            return JSONResponses.missing("pieces");
        }
        try {
            String string = SecretSharingGenerator.combine(stringArray);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"secretPhrase", (Object)string);
            return JSON.prepare(jSONObject);
        }
        catch (RuntimeException runtimeException) {
            Logger.logInfoMessage("Failed to split secretPhrase", runtimeException);
            return JSONResponses.error(runtimeException.toString());
        }
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

