/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.ChildChain;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.ms.Currency;
import nxt.ms.ExchangeBuyAttachment;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class CurrencyBuy
extends CreateTransaction {
    static final CurrencyBuy instance = new CurrencyBuy();

    private CurrencyBuy() {
        super(new APITag[]{APITag.MS, APITag.CREATE_TRANSACTION}, "currency", "rateNQTPerUnit", "unitsQNT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Currency currency = ParameterParser.getCurrency(httpServletRequest);
        long l = ParameterParser.getRateNQTPerUnit(httpServletRequest);
        long l2 = ParameterParser.getUnitsQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        long l3 = Convert.unitRateToAmount(l2, currency.getDecimals(), l, childChain.getDecimals());
        if (l3 == 0L) {
            return JSONResponses.NO_COST_ORDER;
        }
        ExchangeBuyAttachment exchangeBuyAttachment = new ExchangeBuyAttachment(currency.getId(), l, l2);
        try {
            return this.createTransaction(httpServletRequest, account, exchangeBuyAttachment);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }

    @Override
    String getDocsUrlPath() {
        return "Monetary_System#Currency_Buy_.2F_Sell";
    }
}

