/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.dgs.DigitalGoodsHome;
import nxt.dgs.FeedbackAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class DGSFeedback
extends CreateTransaction {
    static final DGSFeedback instance = new DGSFeedback();

    private DGSFeedback() {
        super(new APITag[]{APITag.DGS, APITag.CREATE_TRANSACTION}, "purchase");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        DigitalGoodsHome.Purchase purchase = ParameterParser.getPurchase(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        if (account.getId() != purchase.getBuyerId()) {
            return JSONResponses.INCORRECT_PURCHASE;
        }
        if (purchase.getEncryptedGoods() == null) {
            return JSONResponses.GOODS_NOT_DELIVERED;
        }
        Account account2 = Account.getAccount(purchase.getSellerId());
        FeedbackAttachment feedbackAttachment = new FeedbackAttachment(purchase.getId());
        return this.transactionParameters(httpServletRequest, account, feedbackAttachment).setRecipientId(account2.getId()).createTransaction();
    }
}

