/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.dgs.DigitalGoodsHome;
import nxt.dgs.RefundAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class DGSRefund
extends CreateTransaction {
    static final DGSRefund instance = new DGSRefund();

    private DGSRefund() {
        super(new APITag[]{APITag.DGS, APITag.CREATE_TRANSACTION}, "purchase", "refundNQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        DigitalGoodsHome.Purchase purchase = ParameterParser.getPurchase(httpServletRequest);
        if (account.getId() != purchase.getSellerId()) {
            return JSONResponses.INCORRECT_PURCHASE;
        }
        if (purchase.getRefundNote() != null) {
            return JSONResponses.DUPLICATE_REFUND;
        }
        if (purchase.getEncryptedGoods() == null) {
            return JSONResponses.GOODS_NOT_DELIVERED;
        }
        String string = Convert.emptyToNull(httpServletRequest.getParameter("refundNQT"));
        long l = 0L;
        try {
            if (string != null) {
                l = Long.parseLong(string);
            }
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_DGS_REFUND;
        }
        if (l < 0L || l > 100000000000000000L) {
            return JSONResponses.INCORRECT_DGS_REFUND;
        }
        Account account2 = Account.getAccount(purchase.getBuyerId());
        RefundAttachment refundAttachment = new RefundAttachment(purchase.getId(), l);
        return this.transactionParameters(httpServletRequest, account, refundAttachment).setRecipientId(account2.getId()).createTransaction();
    }
}

