/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class DecodeQRCode
extends APIServlet.APIRequestHandler {
    static final DecodeQRCode instance = new DecodeQRCode();

    private DecodeQRCode() {
        super(new APITag[]{APITag.UTILS}, "qrCodeBase64");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("qrCodeBase64"));
        JSONObject jSONObject = new JSONObject();
        try {
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(string))))));
            HashMap<DecodeHintType, Object> hashMap = new HashMap<DecodeHintType, Object>();
            hashMap.put(DecodeHintType.POSSIBLE_FORMATS, EnumSet.of(BarcodeFormat.QR_CODE));
            hashMap.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            Result result = new MultiFormatReader().decode(binaryBitmap, hashMap);
            jSONObject.put((Object)"qrCodeData", (Object)result.getText());
        }
        catch (IOException iOException) {
            String string2 = "Error reading base64 byte stream";
            Logger.logErrorMessage(string2, iOException);
            JSONData.putException(jSONObject, iOException, string2);
        }
        catch (NullPointerException nullPointerException) {
            String string3 = "Invalid base64 image";
            Logger.logErrorMessage(string3, nullPointerException);
            JSONData.putException(jSONObject, nullPointerException, string3);
        }
        catch (NotFoundException notFoundException) {
            jSONObject.put((Object)"qrCodeData", (Object)"");
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

