/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.lightcontracts.ContractReference;
import nxt.lightcontracts.ContractReferenceDeleteAttachment;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class DeleteContractReference
extends CreateTransaction {
    static final DeleteContractReference instance = new DeleteContractReference();

    private DeleteContractReference() {
        super(new APITag[]{APITag.ACCOUNTS, APITag.CREATE_TRANSACTION}, "contractName");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("contractName")).trim();
        if (string.isEmpty()) {
            return JSONResponses.missing("contractName");
        }
        ContractReference contractReference = ContractReference.getContractReference(account.getId(), string);
        if (contractReference == null) {
            return JSONResponses.unknown("contractName");
        }
        if (contractReference.getAccountId() != account.getId()) {
            return JSONResponses.incorrect("contractName");
        }
        ContractReferenceDeleteAttachment contractReferenceDeleteAttachment = new ContractReferenceDeleteAttachment(contractReference.getId());
        return this.createTransaction(httpServletRequest, account, contractReferenceDeleteAttachment);
    }

    @Override
    public boolean isIgnisOnly() {
        return true;
    }
}

