/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Search;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class DetectMimeType
extends APIServlet.APIRequestHandler {
    static final DetectMimeType instance = new DetectMimeType();

    private DetectMimeType() {
        super("file", new APITag[]{APITag.DATA, APITag.UTILS}, "data", "filename", "isText");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray;
        ParameterParser.FileData fileData;
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("filename")).trim();
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("data"));
        if (string2 == null) {
            fileData = ParameterParser.getFileData(httpServletRequest, "file", true);
            if (fileData == null) {
                throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_FILE);
            }
            byArray = fileData.getData();
            if (string.isEmpty() && fileData.getFilename() != null) {
                string = fileData.getFilename();
            }
        } else {
            boolean bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("isText"));
            byArray = bl ? Convert.toBytes(string2) : Convert.parseHexString(string2);
        }
        fileData = new JSONObject();
        fileData.put("type", Search.detectMimeType(byArray, string));
        return fileData;
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

