/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.crypto.EncryptedData;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class EncryptTo
extends APIServlet.APIRequestHandler {
    static final EncryptTo instance = new EncryptTo();

    private EncryptTo() {
        super(new APITag[]{APITag.MESSAGES}, "recipient", "messageToEncrypt", "messageToEncryptIsText", "compressMessageToEncrypt", "secretPhrase");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray;
        long l = ParameterParser.getAccountId(httpServletRequest, "recipient", true);
        byte[] byArray2 = Account.getPublicKey(l);
        if (byArray2 == null) {
            return JSONResponses.INCORRECT_RECIPIENT;
        }
        boolean bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("messageToEncryptIsText"));
        boolean bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("compressMessageToEncrypt"));
        String string = Convert.emptyToNull(httpServletRequest.getParameter("messageToEncrypt"));
        if (string == null) {
            return JSONResponses.MISSING_MESSAGE_TO_ENCRYPT;
        }
        try {
            byArray = bl ? Convert.toBytes(string) : Convert.parseHexString(string);
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_MESSAGE_TO_ENCRYPT;
        }
        String string2 = ParameterParser.getSecretPhrase(httpServletRequest, true);
        EncryptedData encryptedData = Account.encryptTo(byArray2, byArray, string2, bl2);
        return JSONData.encryptedData(encryptedData);
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

