/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Chain;
import nxt.blockchain.FxtChain;
import nxt.ce.OrderIssueAttachment;
import nxt.ce.OrderIssueFxtAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class ExchangeCoins
extends CreateTransaction {
    static final ExchangeCoins instance = new ExchangeCoins();

    private ExchangeCoins() {
        super(new APITag[]{APITag.CE, APITag.CREATE_TRANSACTION}, "exchange", "quantityQNT", "priceNQTPerCoin");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Chain chain;
        Chain chain2 = ParameterParser.getChain(httpServletRequest, "chain", true);
        if (chain2 == (chain = ParameterParser.getChain(httpServletRequest, "exchange", true))) {
            return JSONResponses.incorrect("exchange", "exchange must specify a different chain");
        }
        long l = ParameterParser.getQuantityQNT(httpServletRequest);
        long l2 = ParameterParser.getPriceNQTPerCoin(httpServletRequest);
        long l3 = Convert.unitRateToAmount(l, chain.getDecimals(), l2, chain2.getDecimals());
        if (l3 == 0L) {
            return JSONResponses.NO_COST_ORDER;
        }
        long l4 = BigDecimal.ONE.divide(new BigDecimal(l2).movePointLeft(chain2.getDecimals()), MathContext.DECIMAL128).movePointRight(chain.getDecimals()).longValue();
        if (l4 == 0L) {
            return JSONResponses.NO_COST_ORDER;
        }
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Chain chain3 = chain.getId() == FxtChain.FXT.getId() ? chain : chain2;
        OrderIssueAttachment orderIssueAttachment = chain3.getId() == FxtChain.FXT.getId() ? new OrderIssueFxtAttachment(chain2, chain, l, l2) : new OrderIssueAttachment(chain2, chain, l, l2);
        try {
            return this.transactionParameters(httpServletRequest, account, orderIssueAttachment).setTxChain(chain3).createTransaction();
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }
}

