/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAccountLessors
extends APIServlet.APIRequestHandler {
    static final GetAccountLessors instance = new GetAccountLessors();

    private GetAccountLessors() {
        super(new APITag[]{APITag.ACCOUNTS}, "account", "height");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getAccount(httpServletRequest);
        int n = ParameterParser.getHeight(httpServletRequest);
        if (n < 0) {
            n = Nxt.getBlockchain().getHeight();
        }
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", account.getId());
        jSONObject.put((Object)"height", (Object)n);
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<Account> dbIterator = account.getLessors(n);){
            if (dbIterator.hasNext()) {
                while (dbIterator.hasNext()) {
                    Account account2 = dbIterator.next();
                    JSONObject jSONObject2 = new JSONObject();
                    JSONData.putAccount(jSONObject2, "lessor", account2.getId());
                    jSONObject2.put((Object)"guaranteedBalanceNQT", (Object)String.valueOf(account2.getGuaranteedBalanceFQT(Constants.GUARANTEED_BALANCE_CONFIRMATIONS, n)));
                    jSONArray.add((Object)jSONObject2);
                }
            }
        }
        jSONObject.put((Object)"lessors", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

