/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.ms.ExchangeHome;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAllExchanges
extends APIServlet.APIRequestHandler {
    static final GetAllExchanges instance = new GetAllExchanges();

    private GetAllExchanges() {
        super(new APITag[]{APITag.MS}, "timestamp", "firstIndex", "lastIndex", "includeCurrencyInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n = ParameterParser.getTimestamp(httpServletRequest);
        int n2 = ParameterParser.getFirstIndex(httpServletRequest);
        int n3 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCurrencyInfo"));
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<ExchangeHome.Exchange> dbIterator = childChain.getExchangeHome().getAllExchanges(n2, n3);){
            while (dbIterator.hasNext()) {
                ExchangeHome.Exchange exchange = dbIterator.next();
                if (exchange.getTimestamp() < n) {
                    break;
                }
                jSONArray.add((Object)JSONData.exchange(exchange, bl));
            }
        }
        jSONObject.put((Object)"exchanges", (Object)jSONArray);
        return jSONObject;
    }
}

