/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.ae.OrderHome;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAllOpenBidOrders
extends APIServlet.APIRequestHandler {
    static final GetAllOpenBidOrders instance = new GetAllOpenBidOrders();

    private GetAllOpenBidOrders() {
        super(new APITag[]{APITag.AE}, "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        try (DbIterator<OrderHome.Bid> dbIterator = childChain.getOrderHome().getAllBidOrders(n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add((Object)JSONData.bidOrder(dbIterator.next()));
            }
        }
        jSONObject.put((Object)"openOrders", (Object)jSONArray);
        return jSONObject;
    }
}

