/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.ae.AssetExchangeTransactionType;
import nxt.ae.OrderCancellationAttachment;
import nxt.ae.OrderHome;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAskOrders
extends APIServlet.APIRequestHandler {
    static final GetAskOrders instance = new GetAskOrders();

    private GetAskOrders() {
        super(new APITag[]{APITag.AE}, "asset", "firstIndex", "lastIndex", "showExpectedCancellations");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Iterable<Object> iterable;
        JSONArray jSONArray;
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", true);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("showExpectedCancellations"));
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        long[] lArray = null;
        if (bl) {
            jSONArray = transaction -> transaction.getType() == AssetExchangeTransactionType.ASK_ORDER_CANCELLATION && transaction.getChain() == childChain;
            iterable = Nxt.getBlockchain().getExpectedTransactions((Filter<Transaction>)jSONArray);
            lArray = new long[iterable.size()];
            for (int i = 0; i < iterable.size(); ++i) {
                object = (OrderCancellationAttachment)((Transaction)iterable.get(i)).getAttachment();
                lArray[i] = ((OrderCancellationAttachment)object).getOrderId();
            }
            Arrays.sort(lArray);
        }
        jSONArray = new JSONArray();
        iterable = childChain.getOrderHome().getSortedAskOrders(l, n, n2);
        Throwable throwable = null;
        try {
            while (((DbIterator)iterable).hasNext()) {
                object = (OrderHome.Ask)((DbIterator)iterable).next();
                JSONObject jSONObject = JSONData.askOrder((OrderHome.Ask)object);
                if (bl && Arrays.binarySearch(lArray, ((OrderHome.Order)object).getId()) >= 0) {
                    jSONObject.put((Object)"expectedCancellation", (Object)Boolean.TRUE);
                }
                jSONArray.add((Object)jSONObject);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (iterable != null) {
                if (throwable != null) {
                    try {
                        ((DbIterator)iterable).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((DbIterator)iterable).close();
                }
            }
        }
        iterable = new JSONObject();
        iterable.put("askOrders", jSONArray);
        return iterable;
    }
}

