/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.ae.AssetHistory;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAssetHistory
extends APIServlet.APIRequestHandler {
    static final GetAssetHistory instance = new GetAssetHistory();

    private GetAssetHistory() {
        super(new APITag[]{APITag.AE}, "asset", "account", "firstIndex", "lastIndex", "timestamp", "deletesOnly", "increasesOnly", "includeAssetInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, false);
        if (l == 0L && l2 == 0L) {
            return JSONResponses.MISSING_ASSET_ACCOUNT;
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("deletesOnly"));
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("increasesOnly"));
        if (bl && bl2) {
            return JSONResponses.either("deletesOnly", "increasesOnly");
        }
        int n = ParameterParser.getTimestamp(httpServletRequest);
        int n2 = ParameterParser.getFirstIndex(httpServletRequest);
        int n3 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl3 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssetInfo"));
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        DbIterator<AssetHistory> dbIterator = null;
        try {
            AssetHistory assetHistory;
            dbIterator = bl ? (l2 == 0L ? AssetHistory.getAssetDeletes(l, n2, n3) : (l == 0L ? AssetHistory.getAccountAssetDeletes(l2, n2, n3) : AssetHistory.getAccountAssetDeletes(l2, l, n2, n3))) : (bl2 ? (l2 == 0L ? AssetHistory.getAssetIncreases(l, n2, n3) : (l == 0L ? AssetHistory.getAccountAssetIncreases(l2, n2, n3) : AssetHistory.getAccountAssetIncreases(l2, l, n2, n3))) : (l2 == 0L ? AssetHistory.getAssetHistory(l, n2, n3) : (l == 0L ? AssetHistory.getAccountAssetHistory(l2, n2, n3) : AssetHistory.getAccountAssetHistory(l2, l, n2, n3))));
            while (dbIterator.hasNext() && (assetHistory = dbIterator.next()).getTimestamp() >= n) {
                jSONArray.add((Object)JSONData.assetHistory(assetHistory, bl3));
            }
        }
        catch (Throwable throwable) {
            DbUtils.close(dbIterator);
            throw throwable;
        }
        DbUtils.close(dbIterator);
        jSONObject.put((Object)"assetHistory", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean startDbTransaction() {
        return true;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

