/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Block;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetBlocks
extends APIServlet.APIRequestHandler {
    static final GetBlocks instance = new GetBlocks();

    private GetBlocks() {
        super(new APITag[]{APITag.BLOCKS}, "firstIndex", "lastIndex", "timestamp", "includeTransactions", "includeExecutedPhased");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        int n3 = ParameterParser.getTimestamp(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeTransactions"));
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeExecutedPhased"));
        JSONArray jSONArray = new JSONArray();
        try (JSONObject jSONObject = Nxt.getBlockchain().getBlocks(n, n2);){
            while (jSONObject.hasNext()) {
                Block block = jSONObject.next();
                if (block.getTimestamp() < n3) {
                    break;
                }
                jSONArray.add((Object)JSONData.block(block, bl, bl2));
            }
        }
        jSONObject = new JSONObject();
        jSONObject.put((Object)"blocks", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

