/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.HoldingType;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.TransactionType;
import nxt.crypto.HashFunction;
import nxt.http.API;
import nxt.http.APIEnum;
import nxt.http.APIProxy;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.ms.CurrencyMinting;
import nxt.ms.CurrencyType;
import nxt.peer.Peer;
import nxt.shuffling.ShufflingParticipantHome;
import nxt.shuffling.ShufflingStage;
import nxt.util.JSON;
import nxt.util.Logger;
import nxt.voting.PhasingPollHome;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetConstants
extends APIServlet.APIRequestHandler {
    static final GetConstants instance = new GetConstants();

    private GetConstants() {
        super(new APITag[]{APITag.INFO}, new String[0]);
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        return Holder.CONSTANTS;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }

    public static JSONStreamAware getConstants() {
        return Holder.CONSTANTS;
    }

    private static final class Holder {
        private static final JSONStreamAware CONSTANTS;

        private Holder() {
        }

        private static /* synthetic */ void lambda$static$6(JSONObject jSONObject, Chain chain) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put((Object)"name", (Object)chain.getName());
            jSONObject2.put((Object)"id", (Object)chain.getId());
            jSONObject2.put((Object)"decimals", (Object)chain.getDecimals());
            jSONObject2.put((Object)"totalAmount", (Object)String.valueOf(chain.getTotalAmount()));
            jSONObject2.put((Object)"ONE_COIN", (Object)String.valueOf(chain.ONE_COIN));
            if (chain instanceof ChildChain) {
                jSONObject2.put((Object)"SHUFFLING_DEPOSIT_NQT", (Object)String.valueOf(((ChildChain)chain).SHUFFLING_DEPOSIT_NQT));
            }
            JSONArray jSONArray = new JSONArray();
            chain.getDisabledTransactionTypes().forEach(transactionType -> jSONArray.add((Object)transactionType.getName()));
            jSONObject2.put((Object)"disabledTransactionTypes", (Object)jSONArray);
            JSONArray jSONArray2 = new JSONArray();
            chain.getDisabledAPITags().forEach(aPITag -> jSONArray2.add((Object)aPITag.name()));
            jSONObject2.put((Object)"disabledAPITags", (Object)jSONArray2);
            jSONObject.put((Object)chain.getId(), (Object)jSONObject2);
        }

        private static /* synthetic */ void lambda$static$1(APITag aPITag, JSONArray jSONArray, ChildChain childChain) {
            if (childChain.getDisabledAPITags().contains((Object)aPITag)) {
                jSONArray.add((Object)childChain.getId());
            }
        }

        private static /* synthetic */ void lambda$static$0(APIEnum aPIEnum, JSONArray jSONArray, ChildChain childChain) {
            if (childChain.getDisabledAPIs().contains((Object)aPIEnum)) {
                jSONArray.add((Object)childChain.getId());
            }
        }

        static {
            try {
                JSONArray jSONArray;
                JSONObject jSONObject;
                Object object2;
                Peer.State state2;
                Object object222;
                TransactionType transactionType;
                int n;
                JSONObject jSONObject3;
                JSONObject jSONObject4;
                JSONObject jSONObject5 = new JSONObject();
                jSONObject5.put((Object)"accountPrefix", (Object)"ARDOR");
                jSONObject5.put((Object)"genesisBlockId", (Object)Long.toUnsignedString(Nxt.getBlockchainProcessor().getGenesisBlockId()));
                jSONObject5.put((Object)"epochBeginning", (Object)Constants.EPOCH_BEGINNING);
                jSONObject5.put((Object)"maxChildBlockPayloadLength", (Object)131072);
                jSONObject5.put((Object)"maxNumberOfFxtTransactions", (Object)10);
                jSONObject5.put((Object)"maxNumberOfChildTransaction", (Object)100);
                JSONObject jSONObject6 = new JSONObject();
                jSONObject6.put((Object)"id", (Object)Long.toUnsignedString(Constants.LAST_KNOWN_BLOCK_ID));
                jSONObject6.put((Object)"height", (Object)Constants.LAST_KNOWN_BLOCK);
                jSONObject5.put((Object)"lastKnownBlock", (Object)jSONObject6);
                jSONObject5.put((Object)"leasingDelay", (Object)Constants.LEASING_DELAY);
                JSONObject jSONObject7 = new JSONObject();
                JSONObject jSONObject8 = new JSONObject();
                int n2 = 0;
                block2: while (true) {
                    jSONObject4 = new JSONObject();
                    jSONObject3 = new JSONObject();
                    n = 0;
                    while (true) {
                        if ((transactionType = ChildTransactionType.findTransactionType((byte)n2, (byte)n)) == null) {
                            if (n != 0) break;
                            break block2;
                        }
                        object222 = new JSONObject();
                        object222.put((Object)"name", (Object)transactionType.getName());
                        object222.put((Object)"canHaveRecipient", (Object)transactionType.canHaveRecipient());
                        object222.put((Object)"mustHaveRecipient", (Object)transactionType.mustHaveRecipient());
                        object222.put((Object)"isPhasingSafe", (Object)transactionType.isPhasingSafe());
                        object222.put((Object)"isPhasable", (Object)transactionType.isPhasable());
                        object222.put((Object)"isGlobal", (Object)transactionType.isGlobal());
                        object222.put((Object)"type", (Object)n2);
                        object222.put((Object)"subtype", (Object)n);
                        jSONObject3.put((Object)n, object222);
                        jSONObject8.put((Object)transactionType.getName(), object222);
                        ++n;
                    }
                    jSONObject4.put((Object)"subtypes", (Object)jSONObject3);
                    jSONObject7.put((Object)n2, (Object)jSONObject4);
                    ++n2;
                }
                n2 = -1;
                block4: while (true) {
                    jSONObject4 = new JSONObject();
                    jSONObject3 = new JSONObject();
                    n = 0;
                    while (true) {
                        if ((transactionType = FxtTransactionType.findTransactionType((byte)n2, (byte)n)) == null) {
                            if (n != 0) break;
                            break block4;
                        }
                        object222 = new JSONObject();
                        object222.put((Object)"name", (Object)transactionType.getName());
                        object222.put((Object)"canHaveRecipient", (Object)transactionType.canHaveRecipient());
                        object222.put((Object)"mustHaveRecipient", (Object)transactionType.mustHaveRecipient());
                        object222.put((Object)"isPhasingSafe", (Object)transactionType.isPhasingSafe());
                        object222.put((Object)"isPhasable", (Object)transactionType.isPhasable());
                        object222.put((Object)"type", (Object)n2);
                        object222.put((Object)"subtype", (Object)n);
                        jSONObject3.put((Object)n, object222);
                        jSONObject8.put((Object)transactionType.getName(), object222);
                        ++n;
                    }
                    jSONObject4.put((Object)"subtypes", (Object)jSONObject3);
                    jSONObject7.put((Object)n2, (Object)jSONObject4);
                    --n2;
                }
                jSONObject5.put((Object)"transactionTypes", (Object)jSONObject7);
                jSONObject5.put((Object)"transactionSubTypes", (Object)jSONObject8);
                JSONObject jSONObject9 = new JSONObject();
                for (Object object222 : CurrencyType.values()) {
                    jSONObject9.put((Object)((Enum)object222).toString(), (Object)((CurrencyType)((Object)object222)).getCode());
                }
                jSONObject5.put((Object)"currencyTypes", (Object)jSONObject9);
                jSONObject4 = new JSONObject();
                for (VoteWeighting.VotingModel votingModel : VoteWeighting.VotingModel.values()) {
                    jSONObject4.put((Object)votingModel.toString(), (Object)votingModel.getCode());
                }
                jSONObject5.put((Object)"votingModels", (Object)jSONObject4);
                JSONObject jSONObject10 = new JSONObject();
                for (VoteWeighting.MinBalanceModel minBalanceModel : VoteWeighting.MinBalanceModel.values()) {
                    jSONObject10.put((Object)minBalanceModel.toString(), (Object)minBalanceModel.getCode());
                }
                jSONObject5.put((Object)"minBalanceModels", (Object)jSONObject10);
                JSONObject jSONObject11 = new JSONObject();
                for (HashFunction jSONObject22 : HashFunction.values()) {
                    jSONObject11.put((Object)jSONObject22.toString(), (Object)jSONObject22.getId());
                }
                jSONObject5.put((Object)"hashAlgorithms", (Object)jSONObject11);
                JSONObject jSONObject12 = new JSONObject();
                for (HashFunction hashFunction : PhasingPollHome.acceptedHashFunctions) {
                    jSONObject12.put((Object)hashFunction.toString(), (Object)hashFunction.getId());
                }
                jSONObject5.put((Object)"phasingHashAlgorithms", (Object)jSONObject12);
                jSONObject5.put((Object)"maxPhasingDuration", (Object)20160);
                JSONObject jSONObject13 = new JSONObject();
                for (HashFunction hashFunction : CurrencyMinting.acceptedHashFunctions) {
                    jSONObject13.put((Object)hashFunction.toString(), (Object)hashFunction.getId());
                }
                jSONObject5.put((Object)"mintingHashAlgorithms", (Object)jSONObject13);
                JSONObject jSONObject14 = new JSONObject();
                for (Peer.State state2 : Peer.State.values()) {
                    jSONObject14.put((Object)state2.toString(), (Object)state2.ordinal());
                }
                jSONObject5.put((Object)"peerStates", (Object)jSONObject14);
                jSONObject5.put((Object)"maxTaggedDataDataLength", (Object)43008);
                JSONObject jSONObject2 = new JSONObject();
                for (Map.Entry<String, APIServlet.APIRequestHandler> entry : APIServlet.apiRequestHandlers.entrySet()) {
                    state2 = JSONData.apiRequestHandler(entry.getValue());
                    state2.put("enabled", true);
                    if (entry.getValue().isChainSpecific()) {
                        JSONArray jSONArray2 = new JSONArray();
                        Enum enum_ = APIEnum.fromName(entry.getKey());
                        if (FxtChain.FXT.getDisabledAPIs().contains(enum_)) {
                            jSONArray2.add((Object)FxtChain.FXT.getId());
                        }
                        ChildChain.getAll().forEach(arg_0 -> Holder.lambda$static$0((APIEnum)enum_, jSONArray2, arg_0));
                        if (jSONArray2.size() > 0) {
                            state2.put("disabledForChains", jSONArray2);
                        }
                    }
                    jSONObject2.put((Object)entry.getKey(), (Object)state2);
                }
                for (Map.Entry<String, APIServlet.APIRequestHandler> entry : APIServlet.disabledRequestHandlers.entrySet()) {
                    state2 = JSONData.apiRequestHandler(entry.getValue());
                    state2.put("enabled", false);
                    jSONObject2.put((Object)entry.getKey(), (Object)state2);
                }
                jSONObject5.put((Object)"requestTypes", (Object)jSONObject2);
                JSONObject jSONObject15 = new JSONObject();
                for (Enum enum_ : HoldingType.values()) {
                    jSONObject15.put((Object)enum_.toString(), (Object)((HoldingType)enum_).getCode());
                }
                jSONObject5.put((Object)"holdingTypes", (Object)jSONObject15);
                JSONObject jSONObject16 = new JSONObject();
                for (ShufflingStage shufflingStage : ShufflingStage.values()) {
                    jSONObject16.put((Object)shufflingStage.toString(), (Object)shufflingStage.getCode());
                }
                jSONObject5.put((Object)"shufflingStages", (Object)jSONObject16);
                JSONObject jSONObject17 = new JSONObject();
                for (ShufflingParticipantHome.State state3 : ShufflingParticipantHome.State.values()) {
                    jSONObject17.put((Object)state3.toString(), (Object)state3.getCode());
                }
                jSONObject5.put((Object)"shufflingParticipantStates", (Object)jSONObject17);
                JSONObject jSONObject18 = new JSONObject();
                for (Object object2 : APITag.values()) {
                    jSONObject = new JSONObject();
                    jSONObject.put((Object)"name", (Object)((APITag)((Object)object2)).getDisplayName());
                    jSONObject.put((Object)"enabled", (Object)(!API.getDisabledApiTags().contains(object2) ? 1 : 0));
                    jSONArray = new JSONArray();
                    if (FxtChain.FXT.getDisabledAPITags().contains(object2)) {
                        jSONArray.add((Object)FxtChain.FXT.getId());
                    }
                    ChildChain.getAll().forEach(arg_0 -> Holder.lambda$static$1((APITag)((Object)object2), jSONArray, arg_0));
                    jSONObject.put((Object)"disabledForChains", (Object)jSONArray);
                    jSONObject18.put((Object)((Enum)object2).name(), (Object)jSONObject);
                }
                jSONObject5.put((Object)"apiTags", (Object)jSONObject18);
                JSONArray jSONArray3 = new JSONArray();
                Collections.addAll(jSONArray3, new List[]{API.getDisabledApis()});
                jSONObject5.put((Object)"disabledAPIs", (Object)jSONArray3);
                JSONArray jSONArray4 = new JSONArray();
                API.getDisabledApiTags().forEach(aPITag -> jSONArray4.add((Object)aPITag.getDisplayName()));
                jSONObject5.put((Object)"disabledAPITags", (Object)jSONArray4);
                JSONArray jSONArray5 = new JSONArray();
                jSONArray5.addAll(APIProxy.NOT_FORWARDED_REQUESTS);
                jSONObject5.put((Object)"proxyNotForwardedRequests", (Object)jSONArray5);
                object2 = new ArrayList<ChildChain>(ChildChain.getAll());
                object2.add(FxtChain.FXT);
                jSONObject = new JSONObject();
                object2.forEach(chain -> jSONObject.put((Object)chain.getName(), (Object)chain.getId()));
                jSONObject5.put((Object)"chains", (Object)jSONObject);
                jSONArray = new JSONObject();
                object2.forEach(arg_0 -> Holder.lambda$static$6((JSONObject)jSONArray, arg_0));
                jSONObject5.put((Object)"chainProperties", (Object)jSONArray);
                jSONObject5.put((Object)"initialBaseTarget", (Object)Long.toUnsignedString(Constants.INITIAL_BASE_TARGET));
                jSONObject5.put((Object)"secretPhraseWords", (Object)Constants.COMPRESSED_SECRET_PHRASE_WORDS);
                CONSTANTS = JSON.prepare(jSONObject5);
            }
            catch (Exception exception) {
                Logger.logErrorMessage(exception.toString(), exception);
                throw exception;
            }
        }
    }
}

