/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.ParameterParser;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetEffectiveBalance
extends APIServlet.APIRequestHandler {
    static final GetEffectiveBalance instance = new GetEffectiveBalance();

    private GetEffectiveBalance() {
        super(new APITag[]{APITag.ACCOUNTS}, "account", "height");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, true);
        int n = ParameterParser.getHeight(httpServletRequest);
        Nxt.getBlockchain().readLock();
        try {
            if (n < 0) {
                n = Nxt.getBlockchain().getHeight();
            }
            JSONObject jSONObject = new JSONObject();
            Account account = Account.getAccount(l, n);
            if (account == null) {
                jSONObject.put((Object)"forgedBalanceFQT", (Object)"0");
                jSONObject.put((Object)"effectiveBalanceFXT", (Object)"0");
                jSONObject.put((Object)"guaranteedBalanceFQT", (Object)"0");
            } else {
                jSONObject.put((Object)"forgedBalanceFQT", (Object)String.valueOf(account.getForgedBalanceFQT()));
                jSONObject.put((Object)"effectiveBalanceFXT", (Object)account.getEffectiveBalanceFXT(n));
                jSONObject.put((Object)"guaranteedBalanceFQT", (Object)String.valueOf(account.getGuaranteedBalanceFQT(Constants.GUARANTEED_BALANCE_CONFIRMATIONS, n)));
            }
            JSONObject jSONObject2 = jSONObject;
            return jSONObject2;
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

