/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExecutedTransactions
extends APIServlet.APIRequestHandler {
    static final GetExecutedTransactions instance = new GetExecutedTransactions();

    private GetExecutedTransactions() {
        super(new APITag[]{APITag.TRANSACTIONS}, "height", "numberOfConfirmations", "type", "subtype", "sender", "recipient", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Chain chain = ParameterParser.getChain(httpServletRequest);
        long l = ParameterParser.getAccountId(httpServletRequest, "sender", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, "recipient", false);
        boolean bl = chain instanceof ChildChain;
        byte by = (byte)(bl ? -1 : 1);
        byte by2 = ParameterParser.getByte(httpServletRequest, "type", bl ? (byte)0 : -128, bl ? (byte)127 : -1, by, false);
        byte by3 = ParameterParser.getByte(httpServletRequest, "subtype", (byte)0, (byte)127, (byte)-1, false);
        if (by2 != by && by3 != -1 && TransactionType.findTransactionType(by2, by3) == null) {
            return JSONResponses.unknown("type");
        }
        int n = ParameterParser.getHeight(httpServletRequest);
        int n2 = ParameterParser.getNumberOfConfirmations(httpServletRequest);
        if (n > 0 && n2 > 0) {
            return JSONResponses.either("height", "numberOfConfirmations");
        }
        if (n <= 0 && l == 0L && l2 == 0L) {
            return JSONResponses.missing("sender", "recipient");
        }
        int n3 = ParameterParser.getFirstIndex(httpServletRequest);
        int n4 = ParameterParser.getLastIndex(httpServletRequest);
        JSONArray jSONArray = new JSONArray();
        try (JSONObject jSONObject = Nxt.getBlockchain().getExecutedTransactions(chain, l, l2, by2, by3, n, n2, n3, n4);){
            while (jSONObject.hasNext()) {
                Transaction transaction = jSONObject.next();
                jSONArray.add((Object)JSONData.transaction(transaction));
            }
        }
        jSONObject = new JSONObject();
        jSONObject.put((Object)"transactions", (Object)jSONArray);
        return jSONObject;
    }
}

