/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.ms.MonetarySystemTransactionType;
import nxt.ms.PublishExchangeOfferAttachment;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedBuyOffers
extends APIServlet.APIRequestHandler {
    static final GetExpectedBuyOffers instance = new GetExpectedBuyOffers();
    private final Comparator<Transaction> rateComparator = (transaction, transaction2) -> {
        PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)transaction.getAttachment();
        PublishExchangeOfferAttachment publishExchangeOfferAttachment2 = (PublishExchangeOfferAttachment)transaction2.getAttachment();
        return Long.compare(publishExchangeOfferAttachment2.getBuyRateNQT(), publishExchangeOfferAttachment.getBuyRateNQT());
    };

    private GetExpectedBuyOffers() {
        super(new APITag[]{APITag.MS}, "currency", "account", "sortByRate");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "currency", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, "account", false);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest, false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("sortByRate"));
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != MonetarySystemTransactionType.PUBLISH_EXCHANGE_OFFER) {
                return false;
            }
            if (l2 != 0L && transaction.getSenderId() != l2) {
                return false;
            }
            if (childChain != null && transaction.getChain() != childChain) {
                return false;
            }
            PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)transaction.getAttachment();
            return l == 0L || publishExchangeOfferAttachment.getCurrencyId() == l;
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        if (bl) {
            list.sort(this.rateComparator);
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add((Object)JSONData.expectedBuyOffer(transaction)));
        jSONObject.put((Object)"offers", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    String getDocsUrlPath() {
        return "Monetary_System#Get_Buy_.2F_Sell_Offers";
    }
}

