/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedTransactions
extends APIServlet.APIRequestHandler {
    static final GetExpectedTransactions instance = new GetExpectedTransactions();

    private GetExpectedTransactions() {
        super(new APITag[]{APITag.TRANSACTIONS}, "account", "account", "account");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Set<Long> set = Convert.toSet(ParameterParser.getAccountIds(httpServletRequest, false));
        Chain chain = ParameterParser.getChain(httpServletRequest, false);
        Filter<Transaction> filter = set.isEmpty() && chain == null ? transaction -> true : transaction -> {
            if (chain != null && transaction.getChain() != chain) {
                return false;
            }
            return set.contains(transaction.getSenderId()) || set.contains(transaction.getRecipientId());
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add((Object)JSONData.unconfirmedTransaction(transaction)));
        jSONObject.put((Object)"expectedTransactions", (Object)jSONArray);
        return jSONObject;
    }
}

