/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.voting.PhasingPollHome;
import nxt.voting.PhasingVoteHome;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetPhasingPollVotes
extends APIServlet.APIRequestHandler {
    static final GetPhasingPollVotes instance = new GetPhasingPollVotes();

    private GetPhasingPollVotes() {
        super(new APITag[]{APITag.PHASING}, "transactionFullHash", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "transactionFullHash", true);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        PhasingPollHome.PhasingPoll phasingPoll = childChain.getPhasingPollHome().getPoll(byArray);
        if (phasingPoll != null) {
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            try (DbIterator<PhasingVoteHome.PhasingVote> dbIterator = childChain.getPhasingVoteHome().getVotes(byArray, n, n2);){
                for (PhasingVoteHome.PhasingVote phasingVote : dbIterator) {
                    jSONArray.add((Object)JSONData.phasingPollVote(phasingVote));
                }
            }
            jSONObject.put((Object)"votes", (Object)jSONArray);
            return jSONObject;
        }
        return JSONResponses.UNKNOWN_TRANSACTION;
    }
}

