/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.blockchain.Chain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class GetTransaction
extends APIServlet.APIRequestHandler {
    static final GetTransaction instance = new GetTransaction();

    private GetTransaction() {
        super(new APITag[]{APITag.TRANSACTIONS}, "fullHash", "includePhasingResult");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "fullHash", true);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includePhasingResult"));
        Chain chain = ParameterParser.getChain(httpServletRequest);
        try {
            Transaction transaction = Nxt.getBlockchain().getTransaction(chain, byArray);
            if (transaction != null) {
                return JSONData.transaction(transaction, bl);
            }
            transaction = Nxt.getTransactionProcessor().getUnconfirmedTransaction(Convert.fullHashToId(byArray));
            if (transaction != null) {
                return JSONData.unconfirmedTransaction(transaction);
            }
            return JSONResponses.UNKNOWN_TRANSACTION;
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_TRANSACTION;
        }
    }
}

