/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.db.DbIterator;
import nxt.db.FilteringIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetUnconfirmedTransactions
extends APIServlet.APIRequestHandler {
    static final GetUnconfirmedTransactions instance = new GetUnconfirmedTransactions();

    private GetUnconfirmedTransactions() {
        super(new APITag[]{APITag.TRANSACTIONS, APITag.ACCOUNTS}, "account", "account", "account", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        JSONObject jSONObject;
        Chain chain = ParameterParser.getChain(httpServletRequest, false);
        Set<Long> set = Convert.toSet(ParameterParser.getAccountIds(httpServletRequest, false));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        JSONArray jSONArray = new JSONArray();
        if (set.isEmpty() && chain == null) {
            jSONObject = Nxt.getTransactionProcessor().getAllUnconfirmedTransactions(n, n2);
            Throwable throwable = null;
            try {
                while (jSONObject.hasNext()) {
                    Transaction transaction2 = jSONObject.next();
                    jSONArray.add((Object)JSONData.unconfirmedTransaction(transaction2));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jSONObject != null) {
                    if (throwable != null) {
                        try {
                            jSONObject.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        jSONObject.close();
                    }
                }
            }
        }
        jSONObject = chain == null ? Nxt.getTransactionProcessor().getAllUnconfirmedTransactions(0, -1) : (chain == FxtChain.FXT ? Nxt.getTransactionProcessor().getUnconfirmedFxtTransactions() : Nxt.getTransactionProcessor().getUnconfirmedChildTransactions((ChildChain)chain));
        try (FilteringIterator<Transaction> filteringIterator = new FilteringIterator<Transaction>((DbIterator<Transaction>)jSONObject, transaction -> set.isEmpty() || set.contains(transaction.getSenderId()) || set.contains(transaction.getRecipientId()), n, n2);){
            while (filteringIterator.hasNext()) {
                Transaction transaction3 = filteringIterator.next();
                jSONArray.add((Object)JSONData.unconfirmedTransaction(transaction3));
            }
        }
        jSONObject = new JSONObject();
        jSONObject.put((Object)"unconfirmedTransactions", (Object)jSONArray);
        return jSONObject;
    }
}

