/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.AccountRestrictions;
import nxt.account.BalanceHome;
import nxt.account.FundingMonitor;
import nxt.account.HoldingType;
import nxt.account.Token;
import nxt.addons.Contract;
import nxt.addons.ContractAndSetupParameters;
import nxt.addons.ContractInvocationParameter;
import nxt.addons.ContractLoader;
import nxt.addons.ContractRunner;
import nxt.addons.JA;
import nxt.addons.JO;
import nxt.addons.StandbyShuffler;
import nxt.addons.ValidateChain;
import nxt.addons.ValidateTransactionType;
import nxt.addons.ValidationAnnotation;
import nxt.ae.Asset;
import nxt.ae.AssetDeleteAttachment;
import nxt.ae.AssetDividendHome;
import nxt.ae.AssetHistory;
import nxt.ae.AssetTransfer;
import nxt.ae.AssetTransferAttachment;
import nxt.ae.OrderCancellationAttachment;
import nxt.ae.OrderHome;
import nxt.ae.OrderPlacementAttachment;
import nxt.ae.TradeHome;
import nxt.aliases.AliasHome;
import nxt.blockchain.Appendix;
import nxt.blockchain.Block;
import nxt.blockchain.Bundler;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.Generator;
import nxt.blockchain.Transaction;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.ce.CoinExchange;
import nxt.ce.OrderCancelAttachment;
import nxt.ce.OrderIssueAttachment;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.db.DbIterator;
import nxt.dgs.DigitalGoodsHome;
import nxt.http.APIServlet;
import nxt.lightcontracts.ContractReference;
import nxt.messaging.PrunableMessageHome;
import nxt.ms.Currency;
import nxt.ms.CurrencyFounderHome;
import nxt.ms.CurrencyTransfer;
import nxt.ms.CurrencyTransferAttachment;
import nxt.ms.CurrencyType;
import nxt.ms.ExchangeAttachment;
import nxt.ms.ExchangeHome;
import nxt.ms.ExchangeOfferHome;
import nxt.ms.ExchangeRequestHome;
import nxt.ms.MonetarySystemTransactionType;
import nxt.ms.PublishExchangeOfferAttachment;
import nxt.peer.BundlerRate;
import nxt.peer.Peer;
import nxt.shuffling.Shuffler;
import nxt.shuffling.ShufflingHome;
import nxt.shuffling.ShufflingParticipantHome;
import nxt.taggeddata.TaggedDataHome;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.Logger;
import nxt.voting.PhasingPollHome;
import nxt.voting.PhasingVoteHome;
import nxt.voting.PollHome;
import nxt.voting.VoteHome;
import nxt.voting.VoteWeighting;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class JSONData {
    static JSONObject alias(AliasHome.Alias alias) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", alias.getAccountId());
        jSONObject.put((Object)"aliasName", (Object)alias.getAliasName());
        jSONObject.put((Object)"aliasURI", (Object)alias.getAliasURI());
        jSONObject.put((Object)"timestamp", (Object)alias.getTimestamp());
        jSONObject.put((Object)"alias", (Object)Long.toUnsignedString(alias.getId()));
        AliasHome.Offer offer = alias.getOffer();
        if (offer != null) {
            jSONObject.put((Object)"priceNQT", (Object)String.valueOf(offer.getPriceNQT()));
            if (offer.getBuyerId() != 0L) {
                jSONObject.put((Object)"buyer", (Object)Long.toUnsignedString(offer.getBuyerId()));
            }
        }
        return jSONObject;
    }

    static JSONObject balance(Chain chain, long l, int n) {
        JSONObject jSONObject = new JSONObject();
        BalanceHome.Balance balance = chain.getBalanceHome().getBalance(l, n);
        if (balance == null) {
            jSONObject.put((Object)"balanceNQT", (Object)"0");
            jSONObject.put((Object)"unconfirmedBalanceNQT", (Object)"0");
        } else {
            jSONObject.put((Object)"balanceNQT", (Object)String.valueOf(balance.getBalance()));
            jSONObject.put((Object)"unconfirmedBalanceNQT", (Object)String.valueOf(balance.getUnconfirmedBalance()));
        }
        return jSONObject;
    }

    static JSONObject lessor(Account account, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        Account.AccountLease accountLease = account.getAccountLease();
        if (accountLease.getCurrentLesseeId() != 0L) {
            JSONData.putAccount(jSONObject, "currentLessee", accountLease.getCurrentLesseeId());
            jSONObject.put((Object)"currentHeightFrom", (Object)String.valueOf(accountLease.getCurrentLeasingHeightFrom()));
            jSONObject.put((Object)"currentHeightTo", (Object)String.valueOf(accountLease.getCurrentLeasingHeightTo()));
            if (bl) {
                jSONObject.put((Object)"effectiveBalanceFXT", (Object)String.valueOf(account.getGuaranteedBalanceFQT() / 100000000L));
            }
        }
        if (accountLease.getNextLesseeId() != 0L) {
            JSONData.putAccount(jSONObject, "nextLessee", accountLease.getNextLesseeId());
            jSONObject.put((Object)"nextHeightFrom", (Object)String.valueOf(accountLease.getNextLeasingHeightFrom()));
            jSONObject.put((Object)"nextHeightTo", (Object)String.valueOf(accountLease.getNextLeasingHeightTo()));
        }
        return jSONObject;
    }

    static JSONObject asset(Asset asset, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", asset.getAccountId());
        jSONObject.put((Object)"name", (Object)asset.getName());
        jSONObject.put((Object)"description", (Object)asset.getDescription());
        jSONObject.put((Object)"decimals", (Object)asset.getDecimals());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(asset.getQuantityQNT()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(asset.getId()));
        jSONObject.put((Object)"hasPhasingAssetControl", (Object)asset.hasPhasingControl());
        if (bl) {
            jSONObject.put((Object)"numberOfTransfers", (Object)AssetTransfer.getTransferCount(asset.getId()));
            jSONObject.put((Object)"numberOfAccounts", (Object)Account.getAssetAccountCount(asset.getId()));
        }
        return jSONObject;
    }

    static JSONObject currency(Currency currency, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(currency.getId()));
        JSONData.putAccount(jSONObject, "account", currency.getAccountId());
        jSONObject.put((Object)"name", (Object)currency.getName());
        jSONObject.put((Object)"code", (Object)currency.getCode());
        jSONObject.put((Object)"description", (Object)currency.getDescription());
        jSONObject.put((Object)"type", (Object)currency.getType());
        jSONObject.put((Object)"chain", (Object)currency.getChildChain().getId());
        jSONObject.put((Object)"initialSupplyQNT", (Object)String.valueOf(currency.getInitialSupplyQNT()));
        jSONObject.put((Object)"currentSupplyQNT", (Object)String.valueOf(currency.getCurrentSupplyQNT()));
        jSONObject.put((Object)"reserveSupplyQNT", (Object)String.valueOf(currency.getReserveSupplyQNT()));
        jSONObject.put((Object)"maxSupplyQNT", (Object)String.valueOf(currency.getMaxSupplyQNT()));
        jSONObject.put((Object)"creationHeight", (Object)currency.getCreationHeight());
        jSONObject.put((Object)"issuanceHeight", (Object)currency.getIssuanceHeight());
        jSONObject.put((Object)"minReservePerUnitNQT", (Object)String.valueOf(currency.getMinReservePerUnitNQT()));
        jSONObject.put((Object)"currentReservePerUnitNQT", (Object)String.valueOf(currency.getCurrentReservePerUnitNQT()));
        jSONObject.put((Object)"minDifficulty", (Object)currency.getMinDifficulty());
        jSONObject.put((Object)"maxDifficulty", (Object)currency.getMaxDifficulty());
        jSONObject.put((Object)"algorithm", (Object)currency.getAlgorithm());
        jSONObject.put((Object)"decimals", (Object)currency.getDecimals());
        if (bl) {
            jSONObject.put((Object)"numberOfTransfers", (Object)CurrencyTransfer.getTransferCount(currency.getId()));
        }
        JSONArray jSONArray = new JSONArray();
        for (CurrencyType currencyType : CurrencyType.values()) {
            if (!currency.is(currencyType)) continue;
            jSONArray.add((Object)currencyType.toString());
        }
        jSONObject.put((Object)"types", (Object)jSONArray);
        return jSONObject;
    }

    static JSONObject currencyFounder(CurrencyFounderHome.CurrencyFounder currencyFounder) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(currencyFounder.getCurrencyId()));
        JSONData.putAccount(jSONObject, "account", currencyFounder.getAccountId());
        jSONObject.put((Object)"amountPerUnitNQT", (Object)String.valueOf(currencyFounder.getAmountPerUnitNQT()));
        return jSONObject;
    }

    static JSONObject accountAsset(Account.AccountAsset accountAsset, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            JSONData.putAccount(jSONObject, "account", accountAsset.getAccountId());
        }
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(accountAsset.getAssetId()));
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(accountAsset.getQuantityQNT()));
        jSONObject.put((Object)"unconfirmedQuantityQNT", (Object)String.valueOf(accountAsset.getUnconfirmedQuantityQNT()));
        if (bl2) {
            JSONData.putAssetInfo(jSONObject, accountAsset.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject accountCurrency(Account.AccountCurrency accountCurrency, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            JSONData.putAccount(jSONObject, "account", accountCurrency.getAccountId());
        }
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(accountCurrency.getCurrencyId()));
        jSONObject.put((Object)"unitsQNT", (Object)String.valueOf(accountCurrency.getUnits()));
        jSONObject.put((Object)"unconfirmedUnitsQNT", (Object)String.valueOf(accountCurrency.getUnconfirmedUnits()));
        if (bl2) {
            JSONData.putCurrencyInfo(jSONObject, accountCurrency.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject accountProperty(Account.AccountProperty accountProperty, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            JSONData.putAccount(jSONObject, "recipient", accountProperty.getRecipientId());
        }
        if (bl2) {
            JSONData.putAccount(jSONObject, "setter", accountProperty.getSetterId());
        }
        jSONObject.put((Object)"property", (Object)accountProperty.getProperty());
        jSONObject.put((Object)"value", (Object)accountProperty.getValue());
        return jSONObject;
    }

    static JSONObject assetProperty(Asset.AssetProperty assetProperty, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        if (bl) {
            jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetProperty.getAssetId()));
        }
        if (bl2) {
            JSONData.putAccount(jSONObject, "setter", assetProperty.getSetterId());
        }
        jSONObject.put((Object)"property", (Object)assetProperty.getProperty());
        jSONObject.put((Object)"value", (Object)assetProperty.getValue());
        return jSONObject;
    }

    static JSONObject askOrder(OrderHome.Ask ask) {
        JSONObject jSONObject = JSONData.order(ask);
        jSONObject.put((Object)"type", (Object)"ask");
        return jSONObject;
    }

    static JSONObject bidOrder(OrderHome.Bid bid) {
        JSONObject jSONObject = JSONData.order(bid);
        jSONObject.put((Object)"type", (Object)"bid");
        return jSONObject;
    }

    private static JSONObject order(OrderHome.Order order) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"order", (Object)Long.toUnsignedString(order.getId()));
        jSONObject.put((Object)"orderFullHash", (Object)Convert.toHexString(order.getFullHash()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(order.getAssetId()));
        JSONData.putAccount(jSONObject, "account", order.getAccountId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(order.getQuantityQNT()));
        jSONObject.put((Object)"priceNQTPerShare", (Object)String.valueOf(order.getPriceNQT()));
        jSONObject.put((Object)"height", (Object)order.getHeight());
        jSONObject.put((Object)"transactionIndex", (Object)order.getTransactionIndex());
        jSONObject.put((Object)"transactionHeight", (Object)order.getTransactionHeight());
        return jSONObject;
    }

    static JSONObject expectedAskOrder(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOrder(transaction);
        jSONObject.put((Object)"type", (Object)"ask");
        return jSONObject;
    }

    static JSONObject expectedBidOrder(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOrder(transaction);
        jSONObject.put((Object)"type", (Object)"bid");
        return jSONObject;
    }

    private static JSONObject expectedOrder(Transaction transaction) {
        JSONObject jSONObject = new JSONObject();
        OrderPlacementAttachment orderPlacementAttachment = (OrderPlacementAttachment)transaction.getAttachment();
        jSONObject.put((Object)"order", (Object)Long.toUnsignedString(transaction.getId()));
        jSONObject.put((Object)"orderFullHash", (Object)Convert.toHexString(transaction.getFullHash()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(orderPlacementAttachment.getAssetId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(orderPlacementAttachment.getQuantityQNT()));
        jSONObject.put((Object)"priceNQTPerShare", (Object)String.valueOf(orderPlacementAttachment.getPriceNQT()));
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject expectedOrderCancellation(Transaction transaction) {
        JSONObject jSONObject = new JSONObject();
        OrderCancellationAttachment orderCancellationAttachment = (OrderCancellationAttachment)transaction.getAttachment();
        jSONObject.put((Object)"order", (Object)Long.toUnsignedString(orderCancellationAttachment.getOrderId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject offer(ExchangeOfferHome.ExchangeOffer exchangeOffer) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"offer", (Object)Long.toUnsignedString(exchangeOffer.getId()));
        jSONObject.put((Object)"offerFullHash", (Object)Convert.toHexString(exchangeOffer.getFullHash()));
        JSONData.putAccount(jSONObject, "account", exchangeOffer.getAccountId());
        jSONObject.put((Object)"height", (Object)exchangeOffer.getHeight());
        jSONObject.put((Object)"expirationHeight", (Object)exchangeOffer.getExpirationHeight());
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(exchangeOffer.getCurrencyId()));
        jSONObject.put((Object)"rateNQTPerUnit", (Object)String.valueOf(exchangeOffer.getRateNQT()));
        jSONObject.put((Object)"limitQNT", (Object)String.valueOf(exchangeOffer.getLimitQNT()));
        jSONObject.put((Object)"supplyQNT", (Object)String.valueOf(exchangeOffer.getSupplyQNT()));
        return jSONObject;
    }

    static JSONObject expectedBuyOffer(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOffer(transaction);
        PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)transaction.getAttachment();
        jSONObject.put((Object)"rateNQTPerUnit", (Object)String.valueOf(publishExchangeOfferAttachment.getBuyRateNQT()));
        jSONObject.put((Object)"limitQNT", (Object)String.valueOf(publishExchangeOfferAttachment.getTotalBuyLimitQNT()));
        jSONObject.put((Object)"supplyQNT", (Object)String.valueOf(publishExchangeOfferAttachment.getInitialBuySupplyQNT()));
        return jSONObject;
    }

    static JSONObject expectedSellOffer(Transaction transaction) {
        JSONObject jSONObject = JSONData.expectedOffer(transaction);
        PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)transaction.getAttachment();
        jSONObject.put((Object)"rateNQTPerUnit", (Object)String.valueOf(publishExchangeOfferAttachment.getSellRateNQT()));
        jSONObject.put((Object)"limitQNT", (Object)String.valueOf(publishExchangeOfferAttachment.getTotalSellLimitQNT()));
        jSONObject.put((Object)"supplyQNT", (Object)String.valueOf(publishExchangeOfferAttachment.getInitialSellSupplyQNT()));
        return jSONObject;
    }

    private static JSONObject expectedOffer(Transaction transaction) {
        PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)transaction.getAttachment();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"offer", (Object)Long.toUnsignedString(transaction.getId()));
        jSONObject.put((Object)"offerFullHash", (Object)Convert.toHexString(transaction.getFullHash()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        jSONObject.put((Object)"expirationHeight", (Object)publishExchangeOfferAttachment.getExpirationHeight());
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(publishExchangeOfferAttachment.getCurrencyId()));
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject availableOffers(ExchangeOfferHome.AvailableOffers availableOffers) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"rateNQTPerUnit", (Object)String.valueOf(availableOffers.getRateNQT()));
        jSONObject.put((Object)"unitsQNT", (Object)String.valueOf(availableOffers.getUnitsQNT()));
        jSONObject.put((Object)"amountNQT", (Object)String.valueOf(availableOffers.getAmountNQT()));
        return jSONObject;
    }

    static JSONObject coinExchangeOrder(CoinExchange.Order order) {
        JSONObject jSONObject = new JSONObject();
        Chain chain = Chain.getChain(order.getChainId());
        Chain chain2 = Chain.getChain(order.getExchangeId());
        long l = order.getQuantityQNT();
        long l2 = order.getBidPriceNQT();
        jSONObject.put((Object)"order", (Object)Long.toUnsignedString(order.getId()));
        jSONObject.put((Object)"orderFullHash", (Object)Convert.toHexString(order.getFullHash()));
        jSONObject.put((Object)"chain", (Object)chain.getId());
        jSONObject.put((Object)"exchange", (Object)chain2.getId());
        JSONData.putAccount(jSONObject, "account", order.getAccountId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(l));
        jSONObject.put((Object)"bidNQTPerCoin", (Object)String.valueOf(l2));
        jSONObject.put((Object)"askNQTPerCoin", (Object)String.valueOf(order.getAskPriceNQT()));
        long l3 = Convert.unitRateToAmount(l, chain2.getDecimals(), l2, chain.getDecimals());
        jSONObject.put((Object)"exchangeQNT", (Object)String.valueOf(l3));
        return jSONObject;
    }

    static JSONObject coinExchangeTrade(CoinExchange.Trade trade) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"orderFullHash", (Object)Convert.toHexString(trade.getOrderFullHash()));
        jSONObject.put((Object)"matchFullHash", (Object)Convert.toHexString(trade.getMatchFullHash()));
        jSONObject.put((Object)"chain", (Object)trade.getChainId());
        jSONObject.put((Object)"exchange", (Object)trade.getExchangeId());
        JSONData.putAccount(jSONObject, "account", trade.getAccountId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(trade.getExchangeQuantityQNT()));
        jSONObject.put((Object)"priceNQTPerCoin", (Object)String.valueOf(trade.getExchangePriceNQT()));
        jSONObject.put((Object)"exchangeRate", (Object)trade.getExchangePrice().toPlainString());
        jSONObject.put((Object)"block", (Object)Long.toUnsignedString(trade.getBlockId()));
        jSONObject.put((Object)"height", (Object)trade.getHeight());
        jSONObject.put((Object)"timestamp", (Object)trade.getTimestamp());
        return jSONObject;
    }

    static JSONObject expectedCoinExchangeOrder(Transaction transaction) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"order", (Object)Long.toUnsignedString(transaction.getId()));
        jSONObject.put((Object)"orderFullHash", (Object)Convert.toHexString(transaction.getFullHash()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)transaction.getAttachment();
        Chain chain = orderIssueAttachment.getChain();
        Chain chain2 = orderIssueAttachment.getExchangeChain();
        long l = orderIssueAttachment.getPriceNQT();
        long l2 = orderIssueAttachment.getQuantityQNT();
        jSONObject.put((Object)"chain", (Object)chain.getId());
        jSONObject.put((Object)"exchange", (Object)chain2.getId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(l2));
        jSONObject.put((Object)"bidNQTPerCoin", (Object)String.valueOf(l));
        BigDecimal[] bigDecimalArray = BigDecimal.ONE.divide(BigDecimal.valueOf(l, chain.getDecimals()), MathContext.DECIMAL128).movePointRight(chain2.getDecimals()).divideAndRemainder(BigDecimal.ONE, MathContext.DECIMAL128);
        long l3 = bigDecimalArray[0].longValue() + (long)(bigDecimalArray[1].signum() != 0 ? 1 : 0);
        jSONObject.put((Object)"askNQTPerCoin", (Object)String.valueOf(l3));
        long l4 = Convert.unitRateToAmount(l2, chain2.getDecimals(), l, chain.getDecimals());
        jSONObject.put((Object)"exchangeQNT", (Object)String.valueOf(l4));
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject expectedCoinExchangeOrderCancellation(Transaction transaction) {
        JSONObject jSONObject = new JSONObject();
        OrderCancelAttachment orderCancelAttachment = (OrderCancelAttachment)transaction.getAttachment();
        jSONObject.put((Object)"order", (Object)Long.toUnsignedString(orderCancelAttachment.getOrderId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject shuffling(ShufflingHome.Shuffling shuffling, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "issuer", shuffling.getIssuerId());
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(shuffling.getHoldingId()));
        HoldingType holdingType = shuffling.getHoldingType();
        jSONObject.put((Object)"holdingType", (Object)holdingType.getCode());
        if (shuffling.getAssigneeAccountId() != 0L) {
            JSONData.putAccount(jSONObject, "assignee", shuffling.getAssigneeAccountId());
        }
        jSONObject.put((Object)"amount", (Object)String.valueOf(shuffling.getAmount()));
        jSONObject.put((Object)"blocksRemaining", (Object)shuffling.getBlocksRemaining());
        jSONObject.put((Object)"participantCount", (Object)shuffling.getParticipantCount());
        jSONObject.put((Object)"registrantCount", (Object)shuffling.getRegistrantCount());
        jSONObject.put((Object)"stage", (Object)shuffling.getStage().getCode());
        jSONObject.put((Object)"shufflingStateHash", (Object)Convert.toHexString(shuffling.getStateHash()));
        jSONObject.put((Object)"shufflingFullHash", (Object)Convert.toHexString(shuffling.getFullHash()));
        JSONArray jSONArray = new JSONArray();
        for (byte[] byArray : shuffling.getRecipientPublicKeys()) {
            jSONArray.add((Object)Convert.toHexString(byArray));
        }
        if (jSONArray.size() > 0) {
            jSONObject.put((Object)"recipientPublicKeys", (Object)jSONArray);
        }
        if (bl) {
            jSONObject.put((Object)"holdingInfo", (Object)JSONData.holdingInfoJson(holdingType, shuffling.getHoldingId()));
        }
        return jSONObject;
    }

    private static JSONObject holdingInfoJson(HoldingType holdingType, long l) {
        JSONObject jSONObject = new JSONObject();
        if (holdingType == HoldingType.COIN) {
            JSONData.putChainInfo(jSONObject, l);
        } else if (holdingType == HoldingType.ASSET) {
            JSONData.putAssetInfo(jSONObject, l);
        } else if (holdingType == HoldingType.CURRENCY) {
            JSONData.putCurrencyInfo(jSONObject, l);
        }
        return jSONObject;
    }

    static JSONObject participant(ShufflingParticipantHome.ShufflingParticipant shufflingParticipant) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"shufflingFullHash", (Object)Convert.toHexString(shufflingParticipant.getShufflingFullHash()));
        JSONData.putAccount(jSONObject, "account", shufflingParticipant.getAccountId());
        JSONData.putAccount(jSONObject, "nextAccount", shufflingParticipant.getNextAccountId());
        jSONObject.put((Object)"state", (Object)shufflingParticipant.getState().getCode());
        return jSONObject;
    }

    static JSONObject shuffler(Shuffler shuffler, boolean bl) {
        ShufflingParticipantHome.ShufflingParticipant shufflingParticipant;
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", shuffler.getAccountId());
        JSONData.putAccount(jSONObject, "recipient", Account.getId(shuffler.getRecipientPublicKey()));
        jSONObject.put((Object)"shufflingFullHash", (Object)Convert.toHexString(shuffler.getShufflingFullHash()));
        jSONObject.put((Object)"feeRateNQTPerFXT", (Object)Long.toUnsignedString(shuffler.getFeeRateNQTPerFXT()));
        if (shuffler.getFailedTransaction() != null) {
            jSONObject.put((Object)"failedTransaction", (Object)JSONData.unconfirmedTransaction(shuffler.getFailedTransaction()));
            jSONObject.put((Object)"failureCause", (Object)shuffler.getFailureCause().getMessage());
        }
        if (bl && (shufflingParticipant = shuffler.getChildChain().getShufflingParticipantHome().getParticipant(shuffler.getShufflingFullHash(), shuffler.getAccountId())) != null) {
            jSONObject.put((Object)"participantState", (Object)shufflingParticipant.getState().getCode());
        }
        jSONObject.put((Object)"chain", (Object)shuffler.getChildChain().getId());
        return jSONObject;
    }

    static JSONObject block(Block block, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"block", (Object)block.getStringId());
        jSONObject.put((Object)"height", (Object)block.getHeight());
        JSONData.putAccount(jSONObject, "generator", block.getGeneratorId());
        jSONObject.put((Object)"generatorPublicKey", (Object)Convert.toHexString(block.getGeneratorPublicKey()));
        jSONObject.put((Object)"timestamp", (Object)block.getTimestamp());
        jSONObject.put((Object)"numberOfTransactions", (Object)block.getFxtTransactions().size());
        jSONObject.put((Object)"totalFeeFQT", (Object)String.valueOf(block.getTotalFeeFQT()));
        jSONObject.put((Object)"version", (Object)block.getVersion());
        jSONObject.put((Object)"baseTarget", (Object)Long.toUnsignedString(block.getBaseTarget()));
        jSONObject.put((Object)"cumulativeDifficulty", (Object)block.getCumulativeDifficulty().toString());
        if (block.getPreviousBlockId() != 0L) {
            jSONObject.put((Object)"previousBlock", (Object)Long.toUnsignedString(block.getPreviousBlockId()));
        }
        if (block.getNextBlockId() != 0L) {
            jSONObject.put((Object)"nextBlock", (Object)Long.toUnsignedString(block.getNextBlockId()));
        }
        jSONObject.put((Object)"payloadHash", (Object)Convert.toHexString(block.getPayloadHash()));
        jSONObject.put((Object)"generationSignature", (Object)Convert.toHexString(block.getGenerationSignature()));
        jSONObject.put((Object)"previousBlockHash", (Object)Convert.toHexString(block.getPreviousBlockHash()));
        jSONObject.put((Object)"blockSignature", (Object)Convert.toHexString(block.getBlockSignature()));
        JSONArray jSONArray = new JSONArray();
        if (bl) {
            block.getFxtTransactions().forEach(fxtTransaction -> jSONArray.add((Object)JSONData.transaction(fxtTransaction)));
        } else {
            block.getFxtTransactions().forEach(fxtTransaction -> jSONArray.add((Object)Convert.toHexString(fxtTransaction.getFullHash())));
        }
        jSONObject.put((Object)"transactions", (Object)jSONArray);
        if (bl2) {
            JSONArray jSONArray2 = new JSONArray();
            try (DbIterator<PhasingPollHome.PhasingPollResult> dbIterator = PhasingPollHome.getApproved(block.getHeight());){
                for (PhasingPollHome.PhasingPollResult phasingPollResult : dbIterator) {
                    if (bl) {
                        jSONArray2.add((Object)JSONData.transaction(Nxt.getBlockchain().getTransaction(phasingPollResult.getChildChain(), phasingPollResult.getFullHash())));
                        continue;
                    }
                    ChainTransactionId chainTransactionId = new ChainTransactionId(phasingPollResult.getChildChain().getId(), phasingPollResult.getFullHash());
                    jSONArray2.add((Object)chainTransactionId.getJSON());
                }
            }
            jSONObject.put((Object)"executedPhasedTransactions", (Object)jSONArray2);
        }
        return jSONObject;
    }

    static JSONObject encryptedData(EncryptedData encryptedData) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"data", (Object)Convert.toHexString(encryptedData.getData()));
        jSONObject.put((Object)"nonce", (Object)Convert.toHexString(encryptedData.getNonce()));
        return jSONObject;
    }

    static JSONObject goods(DigitalGoodsHome.Goods goods, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"goods", (Object)Long.toUnsignedString(goods.getId()));
        jSONObject.put((Object)"goodsFullHash", (Object)Convert.toHexString(goods.getFullHash()));
        jSONObject.put((Object)"name", (Object)goods.getName());
        jSONObject.put((Object)"description", (Object)goods.getDescription());
        jSONObject.put((Object)"quantity", (Object)goods.getQuantity());
        jSONObject.put((Object)"priceNQT", (Object)String.valueOf(goods.getPriceNQT()));
        JSONData.putAccount(jSONObject, "seller", goods.getSellerId());
        jSONObject.put((Object)"tags", (Object)goods.getTags());
        JSONArray jSONArray = new JSONArray();
        Collections.addAll(jSONArray, goods.getParsedTags());
        jSONObject.put((Object)"parsedTags", (Object)jSONArray);
        jSONObject.put((Object)"delisted", (Object)goods.isDelisted());
        jSONObject.put((Object)"timestamp", (Object)goods.getTimestamp());
        jSONObject.put((Object)"hasImage", (Object)goods.hasImage());
        if (bl) {
            jSONObject.put((Object)"numberOfPurchases", (Object)goods.getDGSHome().getGoodsPurchaseCount(goods.getId(), false, true));
            jSONObject.put((Object)"numberOfPublicFeedbacks", (Object)goods.getDGSHome().getGoodsPurchaseCount(goods.getId(), true, true));
        }
        return jSONObject;
    }

    static JSONObject tag(DigitalGoodsHome.Tag tag) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"tag", (Object)tag.getTag());
        jSONObject.put((Object)"inStockCount", (Object)tag.getInStockCount());
        jSONObject.put((Object)"totalCount", (Object)tag.getTotalCount());
        return jSONObject;
    }

    static JSONObject token(Token token) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", Account.getId(token.getPublicKey()));
        jSONObject.put((Object)"timestamp", (Object)token.getTimestamp());
        jSONObject.put((Object)"valid", (Object)token.isValid());
        return jSONObject;
    }

    static JSONObject peer(Peer peer) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"address", (Object)peer.getHost());
        jSONObject.put((Object)"port", (Object)peer.getPort());
        jSONObject.put((Object)"state", (Object)peer.getState().ordinal());
        jSONObject.put((Object)"announcedAddress", (Object)peer.getAnnouncedAddress());
        jSONObject.put((Object)"shareAddress", (Object)peer.shareAddress());
        jSONObject.put((Object)"downloadedVolume", (Object)peer.getDownloadedVolume());
        jSONObject.put((Object)"uploadedVolume", (Object)peer.getUploadedVolume());
        jSONObject.put((Object)"application", (Object)peer.getApplication());
        jSONObject.put((Object)"version", (Object)peer.getVersion());
        jSONObject.put((Object)"platform", (Object)peer.getPlatform());
        if (peer.getApiPort() != 0) {
            jSONObject.put((Object)"apiPort", (Object)peer.getApiPort());
        }
        if (peer.getApiSSLPort() != 0) {
            jSONObject.put((Object)"apiSSLPort", (Object)peer.getApiSSLPort());
        }
        jSONObject.put((Object)"blacklisted", (Object)peer.isBlacklisted());
        jSONObject.put((Object)"lastUpdated", (Object)peer.getLastUpdated());
        jSONObject.put((Object)"lastConnectAttempt", (Object)peer.getLastConnectAttempt());
        jSONObject.put((Object)"inbound", (Object)peer.isInbound());
        if (peer.isBlacklisted()) {
            jSONObject.put((Object)"blacklistingCause", (Object)peer.getBlacklistingCause());
        }
        JSONArray jSONArray = new JSONArray();
        for (Peer.Service service : Peer.Service.values()) {
            if (!peer.providesService(service)) continue;
            jSONArray.add((Object)service.name());
        }
        jSONObject.put((Object)"services", (Object)jSONArray);
        jSONObject.put((Object)"blockchainState", (Object)peer.getBlockchainState());
        return jSONObject;
    }

    static JSONObject poll(PollHome.Poll poll) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", poll.getAccountId());
        jSONObject.put((Object)"poll", (Object)Long.toUnsignedString(poll.getId()));
        jSONObject.put((Object)"name", (Object)poll.getName());
        jSONObject.put((Object)"description", (Object)poll.getDescription());
        JSONArray jSONArray = new JSONArray();
        Collections.addAll(jSONArray, poll.getOptions());
        jSONObject.put((Object)"options", (Object)jSONArray);
        jSONObject.put((Object)"finishHeight", (Object)poll.getFinishHeight());
        jSONObject.put((Object)"minNumberOfOptions", (Object)poll.getMinNumberOfOptions());
        jSONObject.put((Object)"maxNumberOfOptions", (Object)poll.getMaxNumberOfOptions());
        jSONObject.put((Object)"minRangeValue", (Object)poll.getMinRangeValue());
        jSONObject.put((Object)"maxRangeValue", (Object)poll.getMaxRangeValue());
        JSONData.putVoteWeighting(jSONObject, poll.getVoteWeighting());
        jSONObject.put((Object)"finished", (Object)poll.isFinished());
        jSONObject.put((Object)"timestamp", (Object)poll.getTimestamp());
        return jSONObject;
    }

    static JSONObject pollResults(PollHome.Poll poll, List<PollHome.OptionResult> list, VoteWeighting voteWeighting) {
        Currency currency;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"poll", (Object)Long.toUnsignedString(poll.getId()));
        if (voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.ASSET) {
            jSONObject.put((Object)"decimals", (Object)Asset.getAsset(voteWeighting.getHoldingId()).getDecimals());
        } else if (voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.CURRENCY) {
            currency = Currency.getCurrency(voteWeighting.getHoldingId(), true);
            jSONObject.put((Object)"decimals", (Object)currency.getDecimals());
        }
        JSONData.putVoteWeighting(jSONObject, voteWeighting);
        jSONObject.put((Object)"finished", (Object)poll.isFinished());
        currency = new JSONArray();
        Collections.addAll(currency, poll.getOptions());
        jSONObject.put((Object)"options", (Object)currency);
        JSONArray jSONArray = new JSONArray();
        for (PollHome.OptionResult optionResult : list) {
            JSONObject jSONObject2 = new JSONObject();
            if (optionResult != null) {
                jSONObject2.put((Object)"result", (Object)String.valueOf(optionResult.getResult()));
                jSONObject2.put((Object)"weight", (Object)String.valueOf(optionResult.getWeight()));
            } else {
                jSONObject2.put((Object)"result", (Object)"");
                jSONObject2.put((Object)"weight", (Object)"0");
            }
            jSONArray.add((Object)jSONObject2);
        }
        jSONObject.put((Object)"results", (Object)jSONArray);
        return jSONObject;
    }

    static JSONObject vote(VoteHome.Vote vote, VoteWeighter voteWeighter) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "voter", vote.getVoterId());
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(vote.getFullHash()));
        JSONArray jSONArray = new JSONArray();
        for (byte by : vote.getVoteBytes()) {
            if (by == -128) {
                jSONArray.add((Object)"");
                continue;
            }
            jSONArray.add((Object)Byte.toString(by));
        }
        jSONObject.put((Object)"votes", (Object)jSONArray);
        if (voteWeighter != null) {
            jSONObject.put((Object)"weight", (Object)String.valueOf(voteWeighter.calcWeight(vote.getVoterId())));
        }
        return jSONObject;
    }

    static JSONObject phasingPoll(PhasingPollHome.PhasingPoll phasingPoll, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(phasingPoll.getFullHash()));
        jSONObject.put((Object)"finishHeight", (Object)phasingPoll.getFinishHeight());
        jSONObject.put((Object)"quorum", (Object)String.valueOf(phasingPoll.getQuorum()));
        JSONData.putAccount(jSONObject, "account", phasingPoll.getAccountId());
        JSONArray jSONArray = new JSONArray();
        for (long l : phasingPoll.getWhitelist()) {
            JSONObject jSONObject2 = new JSONObject();
            JSONData.putAccount(jSONObject2, "whitelisted", l);
            jSONArray.add((Object)jSONObject2);
        }
        jSONObject.put((Object)"whitelist", (Object)jSONArray);
        Object object = phasingPoll.getLinkedTransactions();
        if (object.size() > 0) {
            JSONArray jSONArray2 = new JSONArray();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ChainTransactionId chainTransactionId = (ChainTransactionId)iterator.next();
                jSONArray2.add((Object)chainTransactionId.getJSON());
            }
            jSONObject.put((Object)"linkedTransactions", (Object)jSONArray2);
        }
        if (phasingPoll.getHashedSecret() != null) {
            jSONObject.put((Object)"hashedSecret", (Object)Convert.toHexString(phasingPoll.getHashedSecret()));
            jSONObject.put((Object)"hashedSecretAlgorithm", (Object)phasingPoll.getAlgorithm());
        }
        JSONData.putVoteWeighting(jSONObject, phasingPoll.getVoteWeighting());
        PhasingPollHome.PhasingPollResult phasingPollResult = PhasingPollHome.getResult(phasingPoll.getFullHash());
        jSONObject.put((Object)"finished", (Object)(phasingPollResult != null ? 1 : 0));
        if (phasingPollResult != null) {
            jSONObject.put((Object)"approved", (Object)phasingPollResult.isApproved());
            jSONObject.put((Object)"result", (Object)String.valueOf(phasingPollResult.getResult()));
            jSONObject.put((Object)"executionHeight", (Object)phasingPollResult.getHeight());
        } else if (bl) {
            jSONObject.put((Object)"result", (Object)String.valueOf(phasingPoll.countVotes()));
        }
        jSONObject.put((Object)"canFinishEarly", (Object)phasingPoll.getParams().allowEarlyFinish());
        return jSONObject;
    }

    static JSONObject phasingPollResult(PhasingPollHome.PhasingPollResult phasingPollResult) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(phasingPollResult.getFullHash()));
        jSONObject.put((Object)"approved", (Object)phasingPollResult.isApproved());
        jSONObject.put((Object)"result", (Object)String.valueOf(phasingPollResult.getResult()));
        jSONObject.put((Object)"executionHeight", (Object)phasingPollResult.getHeight());
        return jSONObject;
    }

    static JSONObject phasingPollVote(PhasingVoteHome.PhasingVote phasingVote) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "voter", phasingVote.getVoterId());
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(phasingVote.getVoteFullHash()));
        return jSONObject;
    }

    private static void putVoteWeighting(JSONObject jSONObject, VoteWeighting voteWeighting) {
        jSONObject.put((Object)"votingModel", (Object)voteWeighting.getVotingModel().getCode());
        jSONObject.put((Object)"minBalance", (Object)String.valueOf(voteWeighting.getMinBalance()));
        jSONObject.put((Object)"minBalanceModel", (Object)voteWeighting.getMinBalanceModel().getCode());
        if (voteWeighting.getHoldingId() != 0L) {
            jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(voteWeighting.getHoldingId()));
        }
    }

    public static JSONObject phasingOnly(AccountRestrictions.PhasingOnly phasingOnly) {
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "account", phasingOnly.getAccountId());
        JSONObject jSONObject2 = new JSONObject();
        phasingOnly.getPhasingParams().putMyJSON(jSONObject2);
        jSONObject.put((Object)"controlParams", (Object)jSONObject2);
        Map<Integer, Long> map = phasingOnly.getMaxFees();
        JSONObject jSONObject3 = new JSONObject();
        map.entrySet().forEach(entry -> jSONObject3.put(entry.getKey(), (Object)String.valueOf(entry.getValue())));
        jSONObject.put((Object)"maxFees", (Object)jSONObject3);
        jSONObject.put((Object)"minDuration", (Object)phasingOnly.getMinDuration());
        jSONObject.put((Object)"maxDuration", (Object)phasingOnly.getMaxDuration());
        jSONObject.put((Object)"canFinishEarly", (Object)phasingOnly.getPhasingParams().allowEarlyFinish());
        return jSONObject;
    }

    static JSONObject purchase(DigitalGoodsHome.Purchase purchase) {
        JSONArray jSONArray;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"purchase", (Object)Long.toUnsignedString(purchase.getId()));
        jSONObject.put((Object)"goods", (Object)Long.toUnsignedString(purchase.getGoodsId()));
        DigitalGoodsHome.Goods goods = purchase.getDGSHome().getGoods(purchase.getGoodsId());
        jSONObject.put((Object)"name", (Object)goods.getName());
        jSONObject.put((Object)"hasImage", (Object)goods.hasImage());
        jSONObject.put((Object)"goodsFullHash", (Object)Convert.toHexString(goods.getFullHash()));
        JSONData.putAccount(jSONObject, "seller", purchase.getSellerId());
        jSONObject.put((Object)"priceNQT", (Object)String.valueOf(purchase.getPriceNQT()));
        jSONObject.put((Object)"quantity", (Object)purchase.getQuantity());
        JSONData.putAccount(jSONObject, "buyer", purchase.getBuyerId());
        jSONObject.put((Object)"timestamp", (Object)purchase.getTimestamp());
        jSONObject.put((Object)"deliveryDeadlineTimestamp", (Object)purchase.getDeliveryDeadlineTimestamp());
        if (purchase.getNote() != null) {
            jSONObject.put((Object)"note", (Object)JSONData.encryptedData(purchase.getNote()));
        }
        jSONObject.put((Object)"pending", (Object)purchase.isPending());
        if (purchase.getEncryptedGoods() != null) {
            jSONObject.put((Object)"goodsData", (Object)JSONData.encryptedData(purchase.getEncryptedGoods()));
            jSONObject.put((Object)"goodsIsText", (Object)purchase.goodsIsText());
        }
        if (purchase.getFeedbackNotes() != null) {
            jSONArray = new JSONArray();
            for (EncryptedData object : purchase.getFeedbackNotes()) {
                jSONArray.add(0, (Object)JSONData.encryptedData(object));
            }
            jSONObject.put((Object)"feedbackNotes", (Object)jSONArray);
        }
        if (purchase.getPublicFeedbacks() != null) {
            jSONArray = new JSONArray();
            for (String string : purchase.getPublicFeedbacks()) {
                jSONArray.add(0, (Object)string);
            }
            jSONObject.put((Object)"publicFeedbacks", (Object)jSONArray);
        }
        if (purchase.getRefundNote() != null) {
            jSONObject.put((Object)"refundNote", (Object)JSONData.encryptedData(purchase.getRefundNote()));
        }
        if (purchase.getDiscountNQT() > 0L) {
            jSONObject.put((Object)"discountNQT", (Object)String.valueOf(purchase.getDiscountNQT()));
        }
        if (purchase.getRefundNQT() > 0L) {
            jSONObject.put((Object)"refundNQT", (Object)String.valueOf(purchase.getRefundNQT()));
        }
        return jSONObject;
    }

    static JSONObject trade(TradeHome.Trade trade, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"timestamp", (Object)trade.getTimestamp());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(trade.getQuantityQNT()));
        jSONObject.put((Object)"priceNQTPerShare", (Object)String.valueOf(trade.getPriceNQT()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(trade.getAssetId()));
        jSONObject.put((Object)"askOrderFullHash", (Object)Convert.toHexString(trade.getAskOrderFullHash()));
        jSONObject.put((Object)"bidOrderFullHash", (Object)Convert.toHexString(trade.getBidOrderFullHash()));
        jSONObject.put((Object)"askOrderHeight", (Object)trade.getAskOrderHeight());
        jSONObject.put((Object)"bidOrderHeight", (Object)trade.getBidOrderHeight());
        JSONData.putAccount(jSONObject, "seller", trade.getSellerId());
        JSONData.putAccount(jSONObject, "buyer", trade.getBuyerId());
        jSONObject.put((Object)"block", (Object)Long.toUnsignedString(trade.getBlockId()));
        jSONObject.put((Object)"height", (Object)trade.getHeight());
        jSONObject.put((Object)"tradeType", (Object)(trade.isBuy() ? "buy" : "sell"));
        if (bl) {
            JSONData.putAssetInfo(jSONObject, trade.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject assetTransfer(AssetTransfer assetTransfer, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"assetTransferFullHash", (Object)Convert.toHexString(assetTransfer.getFullHash()));
        jSONObject.put((Object)"chain", (Object)assetTransfer.getChainId());
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetTransfer.getAssetId()));
        JSONData.putAccount(jSONObject, "sender", assetTransfer.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", assetTransfer.getRecipientId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(assetTransfer.getQuantityQNT()));
        jSONObject.put((Object)"height", (Object)assetTransfer.getHeight());
        jSONObject.put((Object)"timestamp", (Object)assetTransfer.getTimestamp());
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetTransfer.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject expectedAssetTransfer(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        AssetTransferAttachment assetTransferAttachment = (AssetTransferAttachment)transaction.getAttachment();
        jSONObject.put((Object)"assetTransferFullHash", (Object)Convert.toHexString(transaction.getFullHash()));
        jSONObject.put((Object)"chain", (Object)transaction.getChain().getId());
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetTransferAttachment.getAssetId()));
        JSONData.putAccount(jSONObject, "sender", transaction.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", transaction.getRecipientId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(assetTransferAttachment.getQuantityQNT()));
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetTransferAttachment.getAssetId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject assetHistory(AssetHistory assetHistory, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"assetHistoryFullHash", (Object)Convert.toHexString(assetHistory.getFullHash()));
        jSONObject.put((Object)"chain", (Object)assetHistory.getChainId());
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetHistory.getAssetId()));
        JSONData.putAccount(jSONObject, "account", assetHistory.getAccountId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(assetHistory.getQuantityQNT()));
        jSONObject.put((Object)"height", (Object)assetHistory.getHeight());
        jSONObject.put((Object)"timestamp", (Object)assetHistory.getTimestamp());
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetHistory.getAssetId());
        }
        return jSONObject;
    }

    static JSONObject expectedAssetDelete(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        AssetDeleteAttachment assetDeleteAttachment = (AssetDeleteAttachment)transaction.getAttachment();
        jSONObject.put((Object)"assetDeleteFullHash", (Object)Convert.toHexString(transaction.getFullHash()));
        jSONObject.put((Object)"chain", (Object)transaction.getChain().getId());
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetDeleteAttachment.getAssetId()));
        JSONData.putAccount(jSONObject, "account", transaction.getSenderId());
        jSONObject.put((Object)"quantityQNT", (Object)String.valueOf(assetDeleteAttachment.getQuantityQNT()));
        if (bl) {
            JSONData.putAssetInfo(jSONObject, assetDeleteAttachment.getAssetId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject assetDividend(AssetDividendHome.AssetDividend assetDividend, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"assetDividendFullHash", (Object)Convert.toHexString(assetDividend.getFullHash()));
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(assetDividend.getAssetId()));
        jSONObject.put((Object)"amountNQTPerShare", (Object)String.valueOf(assetDividend.getAmountNQT()));
        jSONObject.put((Object)"totalDividend", (Object)String.valueOf(assetDividend.getTotalDividend()));
        jSONObject.put((Object)"dividendHeight", (Object)assetDividend.getDividendHeight());
        jSONObject.put((Object)"numberOfAccounts", (Object)assetDividend.getNumAccounts());
        jSONObject.put((Object)"height", (Object)assetDividend.getHeight());
        jSONObject.put((Object)"timestamp", (Object)assetDividend.getTimestamp());
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(assetDividend.getHoldingId()));
        HoldingType holdingType = assetDividend.getHoldingType();
        jSONObject.put((Object)"holdingType", (Object)holdingType.getCode());
        if (bl) {
            jSONObject.put((Object)"holdingInfo", (Object)JSONData.holdingInfoJson(holdingType, assetDividend.getHoldingId()));
        }
        return jSONObject;
    }

    static JSONObject currencyTransfer(CurrencyTransfer currencyTransfer, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transferFullHash", (Object)Convert.toHexString(currencyTransfer.getFullHash()));
        jSONObject.put((Object)"chain", (Object)currencyTransfer.getChainId());
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(currencyTransfer.getCurrencyId()));
        JSONData.putAccount(jSONObject, "sender", currencyTransfer.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", currencyTransfer.getRecipientId());
        jSONObject.put((Object)"unitsQNT", (Object)String.valueOf(currencyTransfer.getUnitsQNT()));
        jSONObject.put((Object)"height", (Object)currencyTransfer.getHeight());
        jSONObject.put((Object)"timestamp", (Object)currencyTransfer.getTimestamp());
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, currencyTransfer.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject expectedCurrencyTransfer(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        CurrencyTransferAttachment currencyTransferAttachment = (CurrencyTransferAttachment)transaction.getAttachment();
        jSONObject.put((Object)"transferFullHash", (Object)Convert.toHexString(transaction.getFullHash()));
        jSONObject.put((Object)"chain", (Object)transaction.getChain().getId());
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(currencyTransferAttachment.getCurrencyId()));
        JSONData.putAccount(jSONObject, "sender", transaction.getSenderId());
        JSONData.putAccount(jSONObject, "recipient", transaction.getRecipientId());
        jSONObject.put((Object)"unitsQNT", (Object)String.valueOf(currencyTransferAttachment.getUnitsQNT()));
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, currencyTransferAttachment.getCurrencyId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    static JSONObject exchange(ExchangeHome.Exchange exchange, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(exchange.getTransactionFullHash()));
        jSONObject.put((Object)"timestamp", (Object)exchange.getTimestamp());
        jSONObject.put((Object)"unitsQNT", (Object)String.valueOf(exchange.getUnitsQNT()));
        jSONObject.put((Object)"rateNQTPerUnit", (Object)String.valueOf(exchange.getRateNQT()));
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(exchange.getCurrencyId()));
        jSONObject.put((Object)"offer", (Object)Long.toUnsignedString(exchange.getOfferId()));
        jSONObject.put((Object)"offerFullHash", (Object)Convert.toHexString(exchange.getOfferFullHash()));
        JSONData.putAccount(jSONObject, "seller", exchange.getSellerId());
        JSONData.putAccount(jSONObject, "buyer", exchange.getBuyerId());
        jSONObject.put((Object)"block", (Object)Long.toUnsignedString(exchange.getBlockId()));
        jSONObject.put((Object)"height", (Object)exchange.getHeight());
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, exchange.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject exchangeRequest(ExchangeRequestHome.ExchangeRequest exchangeRequest, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(exchangeRequest.getFullHash()));
        jSONObject.put((Object)"subtype", (Object)(exchangeRequest.isBuy() ? MonetarySystemTransactionType.EXCHANGE_BUY.getSubtype() : MonetarySystemTransactionType.EXCHANGE_SELL.getSubtype()));
        jSONObject.put((Object)"timestamp", (Object)exchangeRequest.getTimestamp());
        jSONObject.put((Object)"unitsQNT", (Object)String.valueOf(exchangeRequest.getUnitsQNT()));
        jSONObject.put((Object)"rateNQTPerUnit", (Object)String.valueOf(exchangeRequest.getRateNQT()));
        jSONObject.put((Object)"height", (Object)exchangeRequest.getHeight());
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, exchangeRequest.getCurrencyId());
        }
        return jSONObject;
    }

    static JSONObject expectedExchangeRequest(Transaction transaction, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(transaction.getFullHash()));
        jSONObject.put((Object)"subtype", (Object)transaction.getType().getSubtype());
        ExchangeAttachment exchangeAttachment = (ExchangeAttachment)transaction.getAttachment();
        jSONObject.put((Object)"unitsQNT", (Object)String.valueOf(exchangeAttachment.getUnitsQNT()));
        jSONObject.put((Object)"rateNQTPerUnit", (Object)String.valueOf(exchangeAttachment.getRateNQT()));
        if (bl) {
            JSONData.putCurrencyInfo(jSONObject, exchangeAttachment.getCurrencyId());
        }
        JSONData.putExpectedTransaction(jSONObject, transaction);
        return jSONObject;
    }

    public static JSONObject unconfirmedTransaction(Transaction transaction) {
        return JSONData.unconfirmedTransaction(transaction, null);
    }

    static JSONObject unconfirmedTransaction(Transaction transaction, Filter<Appendix> filter) {
        Object object;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"type", (Object)transaction.getType().getType());
        jSONObject.put((Object)"subtype", (Object)transaction.getType().getSubtype());
        jSONObject.put((Object)"chain", (Object)transaction.getChain().getId());
        jSONObject.put((Object)"phased", (Object)transaction.isPhased());
        jSONObject.put((Object)"timestamp", (Object)transaction.getTimestamp());
        jSONObject.put((Object)"deadline", (Object)transaction.getDeadline());
        jSONObject.put((Object)"senderPublicKey", (Object)Convert.toHexString(transaction.getSenderPublicKey()));
        if (transaction.getRecipientId() != 0L) {
            JSONData.putAccount(jSONObject, "recipient", transaction.getRecipientId());
        }
        jSONObject.put((Object)"amountNQT", (Object)String.valueOf(transaction.getAmount()));
        jSONObject.put((Object)"feeNQT", (Object)String.valueOf(transaction.getFee()));
        if (transaction instanceof ChildTransaction) {
            object = ((ChildTransaction)transaction).getReferencedTransactionId();
            if (object != null) {
                jSONObject.put((Object)"referencedTransaction", (Object)((ChainTransactionId)object).getJSON());
            }
            jSONObject.put((Object)"fxtTransaction", (Object)Long.toUnsignedString(((ChildTransaction)transaction).getFxtTransactionId()));
            if (transaction instanceof UnconfirmedTransaction) {
                jSONObject.put((Object)"isBundled", (Object)((UnconfirmedTransaction)transaction).isBundled());
            }
        }
        if ((object = (Object)Convert.emptyToNull(transaction.getSignature())) != null) {
            jSONObject.put((Object)"signature", (Object)Convert.toHexString((byte[])object));
            jSONObject.put((Object)"signatureHash", (Object)Convert.toHexString(Crypto.sha256().digest((byte[])object)));
            jSONObject.put((Object)"fullHash", (Object)Convert.toHexString(transaction.getFullHash()));
            if (transaction instanceof FxtTransaction) {
                jSONObject.put((Object)"transaction", (Object)Long.toUnsignedString(transaction.getId()));
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        if (filter == null) {
            for (Appendix object2 : transaction.getAppendages(true)) {
                jSONObject2.putAll((Map)object2.getJSONObject());
            }
        } else {
            for (Appendix appendix : transaction.getAppendages(filter, true)) {
                jSONObject2.putAll((Map)appendix.getJSONObject());
            }
        }
        if (!jSONObject2.isEmpty()) {
            for (Map.Entry entry : jSONObject2.entrySet()) {
                if (!(entry.getValue() instanceof Long)) continue;
                entry.setValue(String.valueOf(entry.getValue()));
            }
            jSONObject.put((Object)"attachment", (Object)jSONObject2);
        }
        JSONData.putAccount(jSONObject, "sender", transaction.getSenderId());
        jSONObject.put((Object)"height", (Object)transaction.getHeight());
        jSONObject.put((Object)"version", (Object)transaction.getVersion());
        jSONObject.put((Object)"ecBlockId", (Object)Long.toUnsignedString(transaction.getECBlockId()));
        jSONObject.put((Object)"ecBlockHeight", (Object)transaction.getECBlockHeight());
        return jSONObject;
    }

    public static JSONObject transaction(Transaction transaction) {
        return JSONData.transaction(transaction, false);
    }

    static JSONObject transaction(Transaction transaction, boolean bl) {
        PhasingPollHome.PhasingPollResult phasingPollResult;
        JSONObject jSONObject = JSONData.transaction(transaction, null);
        if (bl && transaction.isPhased() && (phasingPollResult = PhasingPollHome.getResult(transaction)) != null) {
            jSONObject.put((Object)"approved", (Object)phasingPollResult.isApproved());
            jSONObject.put((Object)"result", (Object)String.valueOf(phasingPollResult.getResult()));
            jSONObject.put((Object)"executionHeight", (Object)phasingPollResult.getHeight());
        }
        return jSONObject;
    }

    static JSONObject transaction(Transaction transaction, Filter<Appendix> filter) {
        JSONObject jSONObject = JSONData.unconfirmedTransaction(transaction, filter);
        jSONObject.put((Object)"block", (Object)Long.toUnsignedString(transaction.getBlockId()));
        jSONObject.put((Object)"confirmations", (Object)(Nxt.getBlockchain().getHeight() - transaction.getHeight()));
        jSONObject.put((Object)"blockTimestamp", (Object)transaction.getBlockTimestamp());
        jSONObject.put((Object)"transactionIndex", (Object)transaction.getIndex());
        return jSONObject;
    }

    static JSONObject fxtTransaction(FxtTransaction fxtTransaction, boolean bl) {
        JSONObject jSONObject = JSONData.transaction(fxtTransaction);
        if (bl) {
            JSONArray jSONArray = new JSONArray();
            fxtTransaction.getChildTransactions().forEach(childTransaction -> jSONArray.add((Object)JSONData.transaction(childTransaction)));
            jSONObject.put((Object)"childTransactions", (Object)jSONArray);
        }
        return jSONObject;
    }

    static JSONObject unconfirmedFxtTransaction(FxtTransaction fxtTransaction, boolean bl) {
        JSONObject jSONObject = JSONData.unconfirmedTransaction(fxtTransaction);
        if (bl) {
            JSONArray jSONArray = new JSONArray();
            fxtTransaction.getChildTransactions().forEach(childTransaction -> jSONArray.add((Object)JSONData.unconfirmedTransaction(childTransaction)));
            jSONObject.put((Object)"childTransactions", (Object)jSONArray);
        }
        return jSONObject;
    }

    static JSONObject generator(Generator generator, int n) {
        JSONObject jSONObject = new JSONObject();
        long l = generator.getDeadline();
        JSONData.putAccount(jSONObject, "account", generator.getAccountId());
        jSONObject.put((Object)"deadline", (Object)l);
        jSONObject.put((Object)"hitTime", (Object)generator.getHitTime());
        jSONObject.put((Object)"remaining", (Object)Math.max(l - (long)n, 0L));
        return jSONObject;
    }

    public static JSONObject accountMonitor(FundingMonitor fundingMonitor, boolean bl, boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"chain", (Object)fundingMonitor.getChain().getId());
        jSONObject.put((Object)"holdingType", (Object)fundingMonitor.getHoldingType().getCode());
        jSONObject.put((Object)"account", (Object)Long.toUnsignedString(fundingMonitor.getAccountId()));
        jSONObject.put((Object)"accountRS", (Object)fundingMonitor.getAccountName());
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(fundingMonitor.getHoldingId()));
        jSONObject.put((Object)"property", (Object)fundingMonitor.getProperty());
        jSONObject.put((Object)"amount", (Object)String.valueOf(fundingMonitor.getAmount()));
        jSONObject.put((Object)"threshold", (Object)String.valueOf(fundingMonitor.getThreshold()));
        jSONObject.put((Object)"interval", (Object)fundingMonitor.getInterval());
        jSONObject.put((Object)"feeRateNQTPerFXT", (Object)String.valueOf(fundingMonitor.getFeeRateNQTPerFXT()));
        if (bl) {
            JSONArray jSONArray = new JSONArray();
            List<FundingMonitor.MonitoredAccount> list = FundingMonitor.getMonitoredAccounts(fundingMonitor);
            list.forEach(monitoredAccount -> jSONArray.add((Object)JSONData.monitoredAccount(monitoredAccount)));
            jSONObject.put((Object)"monitoredAccounts", (Object)jSONArray);
        }
        if (bl2) {
            jSONObject.put((Object)"holdingInfo", (Object)JSONData.holdingInfoJson(fundingMonitor.getHoldingType(), fundingMonitor.getHoldingId()));
        }
        return jSONObject;
    }

    public static JSONObject monitoredAccount(FundingMonitor.MonitoredAccount monitoredAccount) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"account", (Object)Long.toUnsignedString(monitoredAccount.getAccountId()));
        jSONObject.put((Object)"accountRS", (Object)monitoredAccount.getAccountName());
        jSONObject.put((Object)"amount", (Object)String.valueOf(monitoredAccount.getAmount()));
        jSONObject.put((Object)"threshold", (Object)String.valueOf(monitoredAccount.getThreshold()));
        jSONObject.put((Object)"interval", (Object)monitoredAccount.getInterval());
        return jSONObject;
    }

    static JSONObject prunableMessage(PrunableMessageHome.PrunableMessage prunableMessage, String string, byte[] byArray) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(prunableMessage.getFullHash()));
        if (prunableMessage.getMessage() == null || prunableMessage.getEncryptedData() == null) {
            jSONObject.put((Object)"isText", (Object)(prunableMessage.getMessage() != null ? prunableMessage.messageIsText() : prunableMessage.encryptedMessageIsText()));
        }
        JSONData.putAccount(jSONObject, "sender", prunableMessage.getSenderId());
        if (prunableMessage.getRecipientId() != 0L) {
            JSONData.putAccount(jSONObject, "recipient", prunableMessage.getRecipientId());
        }
        jSONObject.put((Object)"transactionTimestamp", (Object)prunableMessage.getTransactionTimestamp());
        jSONObject.put((Object)"blockTimestamp", (Object)prunableMessage.getBlockTimestamp());
        EncryptedData encryptedData = prunableMessage.getEncryptedData();
        if (encryptedData != null) {
            jSONObject.put((Object)"encryptedMessage", (Object)JSONData.encryptedData(prunableMessage.getEncryptedData()));
            jSONObject.put((Object)"encryptedMessageIsText", (Object)prunableMessage.encryptedMessageIsText());
            byte[] byArray2 = null;
            try {
                if (string != null) {
                    byArray2 = prunableMessage.decrypt(string);
                } else if (byArray != null && byArray.length > 0) {
                    byArray2 = prunableMessage.decrypt(byArray);
                }
                if (byArray2 != null) {
                    jSONObject.put((Object)"decryptedMessage", (Object)Convert.toString(byArray2, prunableMessage.encryptedMessageIsText()));
                }
            }
            catch (RuntimeException runtimeException) {
                JSONData.putException(jSONObject, runtimeException, "Decryption failed");
            }
            jSONObject.put((Object)"isCompressed", (Object)prunableMessage.isCompressed());
        }
        if (prunableMessage.getMessage() != null) {
            jSONObject.put((Object)"message", (Object)Convert.toString(prunableMessage.getMessage(), prunableMessage.messageIsText()));
            jSONObject.put((Object)"messageIsText", (Object)prunableMessage.messageIsText());
        }
        return jSONObject;
    }

    static JSONObject taggedData(TaggedDataHome.TaggedData taggedData, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(taggedData.getTransactionFullHash()));
        JSONData.putAccount(jSONObject, "account", taggedData.getAccountId());
        jSONObject.put((Object)"name", (Object)taggedData.getName());
        jSONObject.put((Object)"description", (Object)taggedData.getDescription());
        jSONObject.put((Object)"tags", (Object)taggedData.getTags());
        JSONArray jSONArray = new JSONArray();
        Collections.addAll(jSONArray, taggedData.getParsedTags());
        jSONObject.put((Object)"parsedTags", (Object)jSONArray);
        jSONObject.put((Object)"type", (Object)taggedData.getType());
        jSONObject.put((Object)"channel", (Object)taggedData.getChannel());
        jSONObject.put((Object)"filename", (Object)taggedData.getFilename());
        jSONObject.put((Object)"isText", (Object)taggedData.isText());
        if (bl) {
            jSONObject.put((Object)"data", (Object)(taggedData.isText() ? Convert.toString(taggedData.getData()) : Convert.toHexString(taggedData.getData())));
        }
        jSONObject.put((Object)"transactionTimestamp", (Object)taggedData.getTransactionTimestamp());
        jSONObject.put((Object)"blockTimestamp", (Object)taggedData.getBlockTimestamp());
        return jSONObject;
    }

    static JSONObject dataTag(TaggedDataHome.Tag tag) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"tag", (Object)tag.getTag());
        jSONObject.put((Object)"count", (Object)tag.getCount());
        return jSONObject;
    }

    static JSONObject apiRequestHandler(APIServlet.APIRequestHandler aPIRequestHandler) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"allowRequiredBlockParameters", (Object)aPIRequestHandler.allowRequiredBlockParameters());
        if (aPIRequestHandler.getFileParameter() != null) {
            jSONObject.put((Object)"fileParameter", (Object)aPIRequestHandler.getFileParameter());
        }
        jSONObject.put((Object)"requireBlockchain", (Object)aPIRequestHandler.requireBlockchain());
        jSONObject.put((Object)"requirePost", (Object)aPIRequestHandler.requirePost());
        jSONObject.put((Object)"requirePassword", (Object)aPIRequestHandler.requirePassword());
        jSONObject.put((Object)"requireFullClient", (Object)aPIRequestHandler.requireFullClient());
        return jSONObject;
    }

    public static JSONObject bundler(Bundler bundler) {
        BundlerRate bundlerRate;
        JSONObject jSONObject = new JSONObject();
        JSONData.putAccount(jSONObject, "bundler", bundler.getAccountId());
        jSONObject.put((Object)"chain", (Object)bundler.getChildChain().getId());
        jSONObject.put((Object)"totalFeesLimitFQT", (Object)String.valueOf(bundler.getTotalFeesLimitFQT()));
        jSONObject.put((Object)"currentTotalFeesFQT", (Object)String.valueOf(bundler.getCurrentTotalFeesFQT()));
        List<Bundler.Rule> list = bundler.getBundlingRules();
        if (list.size() == 1) {
            jSONObject.put((Object)"minRateNQTPerFXT", (Object)String.valueOf(list.get(0).getMinRateNQTPerFXT()));
            jSONObject.put((Object)"overpayFQTPerFXT", (Object)String.valueOf(list.get(0).getOverpayFQTPerFXT()));
        }
        if ((bundlerRate = bundler.getBundlerRate()) != null) {
            jSONObject.put((Object)"announcedMinRateNQTPerFXT", (Object)String.valueOf(bundlerRate.getRate()));
        }
        JSONArray jSONArray = new JSONArray();
        for (Bundler.Rule rule : list) {
            jSONArray.add((Object)JSONData.bundlingRule(rule));
        }
        jSONObject.put((Object)"bundlingRules", (Object)jSONArray);
        return jSONObject;
    }

    static JSONObject bundlingRule(Bundler.Rule rule) {
        List<Bundler.Filter> list;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"minRateNQTPerFXT", (Object)String.valueOf(rule.getMinRateNQTPerFXT()));
        jSONObject.put((Object)"feeCalculatorName", (Object)rule.getFeeCalculator().getName());
        if (rule.getOverpayFQTPerFXT() != 0L) {
            jSONObject.put((Object)"overpayFQTPerFXT", (Object)String.valueOf(rule.getOverpayFQTPerFXT()));
        }
        if (!(list = rule.getFilters()).isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            list.forEach(filter -> jSONArray.add((Object)JSONData.bundlingFilter(filter)));
            jSONObject.put((Object)"filters", (Object)jSONArray);
        }
        return jSONObject;
    }

    static JSONObject bundlingFilter(Bundler.Filter filter) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"name", (Object)filter.getName());
        if (filter.getParameter() != null) {
            jSONObject.put((Object)"parameter", (Object)filter.getParameter());
        }
        return jSONObject;
    }

    public static JSONObject contractReference(ContractReference contractReference, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"name", (Object)contractReference.getContractName());
        if (contractReference.getContractParams() != null) {
            jSONObject.put((Object)"setupParameters", (Object)contractReference.getContractParams());
        } else {
            jSONObject.put((Object)"setupParameters", (Object)"");
        }
        if (bl) {
            ContractAndSetupParameters contractAndSetupParameters = ContractLoader.loadContractAndSetupParameters(contractReference);
            jSONObject.put((Object)"contract", (Object)JSONData.contract(contractAndSetupParameters.getContract()));
        } else {
            jSONObject.put((Object)"contract", (Object)contractReference.getContractId().getJSON());
        }
        jSONObject.put((Object)"id", (Object)Long.toUnsignedString(contractReference.getId()));
        return jSONObject;
    }

    public static JSONObject contract(Contract contract) {
        Object object;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"contractClass", (Object)contract.getClass().getCanonicalName());
        JA jA = new JA();
        Arrays.stream(contract.getClass().getDeclaredMethods()).flatMap(method -> ContractRunner.INVOCATION_TYPE.getByMethodName(method.getName()).map(Stream::of).orElseGet(Stream::empty)).forEach(iNVOCATION_TYPE -> {
            JO jO = new JO();
            jO.put("type", iNVOCATION_TYPE.name());
            JO jO2 = new JO();
            JSONObject jSONObject = JSONData.stat(iNVOCATION_TYPE.getStatNormal(contract.getClass().getCanonicalName()));
            jO2.put("normal", jSONObject);
            JSONObject jSONObject2 = JSONData.stat(iNVOCATION_TYPE.getStatErr(contract.getClass().getCanonicalName()));
            jO2.put("error", jSONObject2);
            jO.put("stat", jO2);
            jA.add(jO);
        });
        jSONObject.put((Object)"invocationTypes", (Object)jA);
        JA jA2 = new JA();
        Class<?> clazz = ContractLoader.getParametersProvider(contract);
        if (clazz != null) {
            object = clazz.getDeclaredMethods();
            jA2.addAllJO(Arrays.stream(object).filter(method -> method.getDeclaredAnnotation(ContractInvocationParameter.class) != null).map(method -> {
                JO jO = new JO();
                jO.put("name", method.getName());
                jO.put("type", method.getReturnType().getCanonicalName());
                return jO;
            }).collect(Collectors.toList()));
        }
        jSONObject.put((Object)"supportedInvocationParams", (Object)jA2);
        object = new JA();
        for (Method method2 : contract.getClass().getDeclaredMethods()) {
            block1: for (Annotation annotation : method2.getDeclaredAnnotations()) {
                for (Annotation annotation2 : annotation.annotationType().getDeclaredAnnotations()) {
                    if (!annotation2.annotationType().equals(ValidationAnnotation.class)) continue;
                    JO jO = JSONData.getAnnotationData(annotation);
                    jO.put("forMethod", method2.getName());
                    ((JA)object).add(jO);
                    continue block1;
                }
            }
        }
        jSONObject.put((Object)"validityChecks", object);
        return jSONObject;
    }

    private static JSONObject stat(StatisticalSummary statisticalSummary) {
        JO jO = new JO();
        jO.put("max", String.format(Locale.ROOT, "%.3f", statisticalSummary.getMax() / 1.0E9));
        jO.put("min", String.format(Locale.ROOT, "%.3f", statisticalSummary.getMin() / 1.0E9));
        jO.put("average", String.format(Locale.ROOT, "%.3f", statisticalSummary.getMean() / 1.0E9));
        jO.put("count", (Object)statisticalSummary.getN());
        jO.put("std", String.format(Locale.ROOT, "%.3f", statisticalSummary.getStandardDeviation() / 1.0E9));
        jO.put("sum", String.format(Locale.ROOT, "%.3f", statisticalSummary.getSum() / 1.0E9));
        jO.put("variance", String.format(Locale.ROOT, "%.3f", statisticalSummary.getVariance() / 1.0E18));
        return jO.toJSONObject();
    }

    private static JO getAnnotationData(Annotation annotation) {
        JO jO = new JO();
        jO.put("name", annotation.annotationType().getSimpleName());
        if (annotation.annotationType() == ValidateTransactionType.class) {
            ValidateTransactionType validateTransactionType = (ValidateTransactionType)annotation;
            try {
                jO.put("accept", Arrays.stream(validateTransactionType.accept()).map(Enum::name).collect(Collectors.joining(",")));
                jO.put("reject", Arrays.stream(validateTransactionType.reject()).map(Enum::name).collect(Collectors.joining(",")));
            }
            catch (Exception exception) {
                Logger.logInfoMessage("Cannot parse validation transaction type for old contract");
            }
        } else if (annotation.annotationType() == ValidateChain.class) {
            ValidateChain validateChain = (ValidateChain)annotation;
            jO.put("accept", Arrays.toString(validateChain.accept()));
            jO.put("reject", Arrays.toString(validateChain.reject()));
        }
        return jO;
    }

    static void putPrunableAttachment(JSONObject jSONObject, Transaction transaction) {
        JSONObject jSONObject2 = transaction.getPrunableAttachmentJSON();
        if (jSONObject2 != null) {
            jSONObject.put((Object)"prunableAttachmentJSON", (Object)jSONObject2);
        }
    }

    static void putException(JSONObject jSONObject, Exception exception) {
        JSONData.putException(jSONObject, exception, "");
    }

    static void putException(JSONObject jSONObject, Exception exception, String string) {
        jSONObject.put((Object)"errorCode", (Object)4);
        if (string.length() > 0) {
            string = string + ": ";
        }
        jSONObject.put((Object)"error", (Object)exception.toString());
        jSONObject.put((Object)"errorDescription", (Object)(string + exception.getMessage()));
    }

    public static void putAccount(JSONObject jSONObject, String string, long l) {
        jSONObject.put((Object)string, (Object)Long.toUnsignedString(l));
        jSONObject.put((Object)(string + "RS"), (Object)Convert.rsAccount(l));
    }

    private static void putCurrencyInfo(JSONObject jSONObject, long l) {
        Currency currency = Currency.getCurrency(l, true);
        jSONObject.put((Object)"name", (Object)currency.getName());
        jSONObject.put((Object)"code", (Object)currency.getCode());
        jSONObject.put((Object)"type", (Object)currency.getType());
        jSONObject.put((Object)"decimals", (Object)currency.getDecimals());
        jSONObject.put((Object)"issuanceHeight", (Object)currency.getIssuanceHeight());
        jSONObject.put((Object)"chain", (Object)currency.getChildChain().getId());
        JSONData.putAccount(jSONObject, "issuerAccount", currency.getAccountId());
    }

    private static void putAssetInfo(JSONObject jSONObject, long l) {
        Asset asset = Asset.getAsset(l);
        jSONObject.put((Object)"name", (Object)asset.getName());
        jSONObject.put((Object)"decimals", (Object)asset.getDecimals());
    }

    private static void putChainInfo(JSONObject jSONObject, long l) {
        Chain chain = Chain.getChain((int)l);
        jSONObject.put((Object)"name", (Object)chain.getName());
        jSONObject.put((Object)"decimals", (Object)chain.getDecimals());
    }

    private static void putExpectedTransaction(JSONObject jSONObject, Transaction transaction) {
        jSONObject.put((Object)"height", (Object)(Nxt.getBlockchain().getHeight() + 1));
        jSONObject.put((Object)"phased", (Object)transaction.isPhased());
        if (transaction.getBlockId() != 0L) {
            jSONObject.put((Object)"transactionHeight", (Object)transaction.getHeight());
            jSONObject.put((Object)"confirmations", (Object)(Nxt.getBlockchain().getHeight() - transaction.getHeight()));
        }
        if (!jSONObject.containsKey((Object)"chain")) {
            jSONObject.put((Object)"chain", (Object)transaction.getChain().getId());
        }
    }

    static void ledgerEntry(JSONObject jSONObject, AccountLedger.LedgerEntry ledgerEntry, boolean bl, boolean bl2) {
        Object object;
        JSONData.putAccount(jSONObject, "account", ledgerEntry.getAccountId());
        jSONObject.put((Object)"ledgerId", (Object)Long.toUnsignedString(ledgerEntry.getLedgerId()));
        jSONObject.put((Object)"block", (Object)Long.toUnsignedString(ledgerEntry.getBlockId()));
        jSONObject.put((Object)"height", (Object)ledgerEntry.getHeight());
        jSONObject.put((Object)"timestamp", (Object)ledgerEntry.getTimestamp());
        jSONObject.put((Object)"eventType", (Object)ledgerEntry.getEvent().name());
        jSONObject.put((Object)"event", (Object)Long.toUnsignedString(ledgerEntry.getEventId()));
        byte[] byArray = ledgerEntry.getEventHash();
        if (byArray != null) {
            jSONObject.put((Object)"eventHash", (Object)Convert.toHexString(byArray));
        }
        jSONObject.put((Object)"chain", (Object)ledgerEntry.getChainId());
        jSONObject.put((Object)"isTransactionEvent", (Object)ledgerEntry.getEvent().isTransaction());
        jSONObject.put((Object)"change", (Object)String.valueOf(ledgerEntry.getChange()));
        jSONObject.put((Object)"balance", (Object)String.valueOf(ledgerEntry.getBalance()));
        AccountLedger.LedgerHolding ledgerHolding = ledgerEntry.getHolding();
        jSONObject.put((Object)"holdingType", (Object)ledgerHolding.name());
        jSONObject.put((Object)"holdingTypeCode", (Object)ledgerHolding.getCode());
        jSONObject.put((Object)"holdingTypeIsUnconfirmed", (Object)ledgerHolding.isUnconfirmed());
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(ledgerEntry.getHoldingId()));
        if (bl2) {
            object = null;
            if (ledgerHolding == AccountLedger.LedgerHolding.ASSET_BALANCE || ledgerHolding == AccountLedger.LedgerHolding.UNCONFIRMED_ASSET_BALANCE) {
                object = new JSONObject();
                JSONData.putAssetInfo(object, ledgerEntry.getHoldingId());
            } else if (ledgerHolding == AccountLedger.LedgerHolding.CURRENCY_BALANCE || ledgerHolding == AccountLedger.LedgerHolding.UNCONFIRMED_CURRENCY_BALANCE) {
                object = new JSONObject();
                JSONData.putCurrencyInfo(object, ledgerEntry.getHoldingId());
            }
            if (object != null) {
                jSONObject.put((Object)"holdingInfo", object);
            }
        }
        if (bl && ledgerEntry.getEvent().isTransaction()) {
            object = Chain.getChain(ledgerEntry.getChainId());
            Transaction transaction = Nxt.getBlockchain().getTransaction((Chain)object, ledgerEntry.getEventHash());
            jSONObject.put((Object)"transaction", (Object)JSONData.transaction(transaction));
        }
    }

    public static JSONObject standbyShuffler(StandbyShuffler standbyShuffler, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"account", (Object)Long.toUnsignedString(standbyShuffler.getAccountId()));
        jSONObject.put((Object)"accountRS", (Object)Convert.rsAccount(standbyShuffler.getAccountId()));
        jSONObject.put((Object)"chain", (Object)standbyShuffler.getChain().getId());
        HoldingType holdingType = standbyShuffler.getHoldingType();
        jSONObject.put((Object)"holdingType", (Object)holdingType.getCode());
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(standbyShuffler.getHoldingId()));
        jSONObject.put((Object)"minAmount", (Object)String.valueOf(standbyShuffler.getMinAmount()));
        jSONObject.put((Object)"maxAmount", (Object)String.valueOf(standbyShuffler.getMaxAmount()));
        jSONObject.put((Object)"minParticipants", (Object)standbyShuffler.getMinParticipants());
        jSONObject.put((Object)"feeRateNQTPerFXT", (Object)standbyShuffler.getFeeRateNQTPerFXT());
        JSONArray jSONArray = new JSONArray();
        standbyShuffler.getRecipientPublicKeys().forEach(byArray -> jSONArray.add((Object)Convert.toHexString(byArray)));
        jSONObject.put((Object)"recipientPublicKeys", (Object)jSONArray);
        if (bl) {
            jSONObject.put((Object)"holdingInfo", (Object)JSONData.holdingInfoJson(holdingType, standbyShuffler.getHoldingId()));
        }
        jSONObject.put((Object)"reservedPublicKeysCount", (Object)standbyShuffler.getReservedPublicKeysCount());
        return jSONObject;
    }

    private JSONData() {
    }

    static interface VoteWeighter {
        public long calcWeight(long var1);
    }
}

