/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.HoldingType;
import nxt.ae.Asset;
import nxt.aliases.AliasHome;
import nxt.blockchain.Appendix;
import nxt.blockchain.Bundler;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.crypto.SecretSharingGenerator;
import nxt.dgs.DigitalGoodsHome;
import nxt.http.API;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.messaging.EncryptToSelfMessageAppendix;
import nxt.messaging.EncryptedMessageAppendix;
import nxt.messaging.MessageAppendix;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.messaging.UnencryptedEncryptToSelfMessageAppendix;
import nxt.messaging.UnencryptedEncryptedMessageAppendix;
import nxt.messaging.UnencryptedPrunableEncryptedMessageAppendix;
import nxt.ms.Currency;
import nxt.ms.ExchangeOfferHome;
import nxt.shuffling.ShufflingHome;
import nxt.taggeddata.TaggedDataAttachment;
import nxt.util.BooleanExpression;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Logger;
import nxt.util.Search;
import nxt.voting.PhasingParams;
import nxt.voting.PollHome;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public final class ParameterParser {
    public static byte getByte(HttpServletRequest httpServletRequest, String string, byte by, byte by2, boolean bl) throws ParameterException {
        return ParameterParser.getByte(httpServletRequest, string, by, by2, (byte)0, bl);
    }

    public static byte getByte(HttpServletRequest httpServletRequest, String string, byte by, byte by2, byte by3, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return by3;
        }
        try {
            byte by4 = Byte.parseByte(string2);
            if (by4 < by || by4 > by2) {
                throw new ParameterException(JSONResponses.incorrect(string, String.format("value %d not in range [%d-%d]", by4, by, by2)));
            }
            return by4;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string, String.format("value %s is not numeric", string2)));
        }
    }

    public static int getInt(HttpServletRequest httpServletRequest, String string, int n, int n2, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return 0;
        }
        return ParameterParser.getInt(string, string2, n, n2);
    }

    public static int getInt(HttpServletRequest httpServletRequest, String string, int n, int n2, int n3) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            return n3;
        }
        return ParameterParser.getInt(string, string2, n, n2);
    }

    private static int getInt(String string, String string2, int n, int n2) throws ParameterException {
        try {
            int n3 = Integer.parseInt(string2);
            if (n3 < n || n3 > n2) {
                throw new ParameterException(JSONResponses.incorrect(string, String.format("value %d not in range [%d-%d]", n3, n, n2)));
            }
            return n3;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string, String.format("value %s is not numeric", string2)));
        }
    }

    public static long getLong(HttpServletRequest httpServletRequest, String string, long l, long l2, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return 0L;
        }
        return ParameterParser.getLong(string, string2, l, l2);
    }

    public static long getLong(HttpServletRequest httpServletRequest, String string, long l, long l2, long l3) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            return l3;
        }
        return ParameterParser.getLong(string, string2, l, l2);
    }

    private static long getLong(String string, String string2, long l, long l2) throws ParameterException {
        try {
            long l3 = Long.parseLong(string2);
            if (l3 < l || l3 > l2) {
                throw new ParameterException(JSONResponses.incorrect(string, String.format("value %d not in range [%d-%d]", l3, l, l2)));
            }
            return l3;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string, String.format("value %s is not numeric", string2)));
        }
    }

    public static long getUnsignedLong(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return 0L;
        }
        try {
            long l = Convert.parseUnsignedLong(string2);
            if (l == 0L) {
                throw new ParameterException(JSONResponses.incorrect(string));
            }
            return l;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string));
        }
    }

    public static long[] getUnsignedLongs(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        String[] stringArray = httpServletRequest.getParameterValues(string);
        if (stringArray == null || stringArray.length == 0) {
            throw new ParameterException(JSONResponses.missing(string));
        }
        long[] lArray = new long[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].isEmpty()) {
                    throw new ParameterException(JSONResponses.incorrect(string));
                }
                lArray[i] = Long.parseUnsignedLong(stringArray[i]);
                if (lArray[i] != 0L) continue;
                throw new ParameterException(JSONResponses.incorrect(string));
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string));
        }
        return lArray;
    }

    public static BigInteger getBigInteger(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return BigInteger.ZERO;
        }
        return new BigInteger(string2);
    }

    public static byte[] getBytes(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return Convert.EMPTY_BYTE;
        }
        return Convert.parseHexString(string2);
    }

    public static JSONObject getJson(HttpServletRequest httpServletRequest, String string) {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            return null;
        }
        return (JSONObject)JSONValue.parse((String)string2);
    }

    public static JSONArray getJsonArray(HttpServletRequest httpServletRequest, String string) {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            return null;
        }
        return (JSONArray)JSONValue.parse((String)string2);
    }

    public static String getParameter(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            throw new ParameterException(JSONResponses.missing(string));
        }
        return string2;
    }

    public static long getAccountId(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        return ParameterParser.getAccountId(httpServletRequest, "account", bl);
    }

    public static long getAccountId(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            if (bl) {
                throw new ParameterException(JSONResponses.missing(string));
            }
            return 0L;
        }
        try {
            long l = Convert.parseAccountId(string2);
            if (l == 0L) {
                throw new ParameterException(JSONResponses.incorrect(string));
            }
            return l;
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string));
        }
    }

    public static long[] getAccountIds(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        String[] stringArray = httpServletRequest.getParameterValues("account");
        if (stringArray == null || stringArray.length == 0) {
            if (bl) {
                throw new ParameterException(JSONResponses.MISSING_ACCOUNT);
            }
            return Convert.EMPTY_LONG;
        }
        long[] lArray = new long[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].isEmpty()) {
                    throw new ParameterException(JSONResponses.INCORRECT_ACCOUNT);
                }
                lArray[i] = Convert.parseAccountId(stringArray[i]);
                if (lArray[i] != 0L) continue;
                throw new ParameterException(JSONResponses.INCORRECT_ACCOUNT);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.INCORRECT_ACCOUNT);
        }
        return lArray;
    }

    public static AliasHome.Alias getAlias(HttpServletRequest httpServletRequest) throws ParameterException {
        AliasHome.Alias alias;
        long l;
        try {
            l = Convert.parseUnsignedLong(Convert.emptyToNull(httpServletRequest.getParameter("alias")));
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.INCORRECT_ALIAS);
        }
        String string = Convert.emptyToNull(httpServletRequest.getParameter("aliasName"));
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        if (l != 0L) {
            alias = childChain.getAliasHome().getAlias(l);
        } else if (string != null) {
            alias = childChain.getAliasHome().getAlias(string);
        } else {
            throw new ParameterException(JSONResponses.MISSING_ALIAS_OR_ALIAS_NAME);
        }
        if (alias == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_ALIAS);
        }
        return alias;
    }

    public static long getAmountNQT(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "amountNQT", 1L, 100000000000000000L, true);
    }

    public static long getAmountNQTPerShare(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "amountNQTPerShare", 1L, 100000000000000000L, true);
    }

    public static long getPriceNQT(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "priceNQT", 1L, 100000000000000000L, true);
    }

    public static long getPriceNQTPerShare(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "priceNQTPerShare", 1L, 100000000000000000L, true);
    }

    public static long getPriceNQTPerCoin(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "priceNQTPerCoin", 1L, 100000000000000000L, true);
    }

    public static long getRateNQTPerUnit(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "rateNQTPerUnit", 1L, 100000000000000000L, true);
    }

    public static PollHome.Poll getPoll(HttpServletRequest httpServletRequest) throws ParameterException {
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        PollHome.Poll poll = childChain.getPollHome().getPoll(ParameterParser.getUnsignedLong(httpServletRequest, "poll", true));
        if (poll == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_POLL);
        }
        return poll;
    }

    public static Asset getAsset(HttpServletRequest httpServletRequest) throws ParameterException {
        Asset asset = Asset.getAsset(ParameterParser.getUnsignedLong(httpServletRequest, "asset", true));
        if (asset == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_ASSET);
        }
        return asset;
    }

    public static Currency getCurrency(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getCurrency(httpServletRequest, true);
    }

    public static Currency getCurrency(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        Currency currency = Currency.getCurrency(ParameterParser.getUnsignedLong(httpServletRequest, "currency", bl));
        if (bl && currency == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_CURRENCY);
        }
        return currency;
    }

    public static ExchangeOfferHome.BuyOffer getBuyOffer(HttpServletRequest httpServletRequest) throws ParameterException {
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        ExchangeOfferHome.BuyOffer buyOffer = childChain.getExchangeOfferHome().getBuyOffer(ParameterParser.getUnsignedLong(httpServletRequest, "offer", true));
        if (buyOffer == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_OFFER);
        }
        return buyOffer;
    }

    public static ExchangeOfferHome.SellOffer getSellOffer(HttpServletRequest httpServletRequest) throws ParameterException {
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        ExchangeOfferHome.SellOffer sellOffer = childChain.getExchangeOfferHome().getSellOffer(ParameterParser.getUnsignedLong(httpServletRequest, "offer", true));
        if (sellOffer == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_OFFER);
        }
        return sellOffer;
    }

    public static ShufflingHome.Shuffling getShuffling(HttpServletRequest httpServletRequest) throws ParameterException {
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        ShufflingHome.Shuffling shuffling = childChain.getShufflingHome().getShuffling(ParameterParser.getBytes(httpServletRequest, "shufflingFullHash", true));
        if (shuffling == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_SHUFFLING);
        }
        return shuffling;
    }

    public static long getQuantityQNT(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "quantityQNT", 1L, 100000000000000000L, true);
    }

    public static long getUnitsQNT(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getLong(httpServletRequest, "unitsQNT", 1L, 100000000000000000L, true);
    }

    public static DigitalGoodsHome.Goods getGoods(HttpServletRequest httpServletRequest) throws ParameterException {
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        DigitalGoodsHome.Goods goods = childChain.getDigitalGoodsHome().getGoods(ParameterParser.getUnsignedLong(httpServletRequest, "goods", true));
        if (goods == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_GOODS);
        }
        return goods;
    }

    public static int getGoodsQuantity(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getInt(httpServletRequest, "quantity", 0, 1000000000, true);
    }

    public static EncryptedData getEncryptedData(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        byte[] byArray;
        byte[] byArray2;
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string + "Data"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter(string + "Nonce"));
        if (string3 == null) {
            return null;
        }
        try {
            byArray2 = Convert.parseHexString(string3);
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.incorrect(string + "Nonce"));
        }
        if (string2 != null) {
            try {
                byArray = Convert.parseHexString(string2);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.incorrect(string + "Data"));
            }
        } else {
            FileData fileData = ParameterParser.getFileData(httpServletRequest, string + "File", false);
            if (fileData == null) {
                return null;
            }
            byArray = fileData.getData();
        }
        return new EncryptedData(byArray, byArray2);
    }

    public static EncryptToSelfMessageAppendix getEncryptToSelfMessage(HttpServletRequest httpServletRequest) throws ParameterException {
        boolean bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("messageToEncryptToSelfIsText"));
        boolean bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("compressMessageToEncryptToSelf"));
        byte[] byArray = null;
        EncryptedData encryptedData = ParameterParser.getEncryptedData(httpServletRequest, "encryptToSelfMessage");
        if (encryptedData == null) {
            String string = Convert.emptyToNull(httpServletRequest.getParameter("messageToEncryptToSelf"));
            if (string == null) {
                return null;
            }
            try {
                byArray = bl ? Convert.toBytes(string) : Convert.parseHexString(string);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.INCORRECT_MESSAGE_TO_ENCRYPT);
            }
            String string2 = ParameterParser.getSecretPhrase(httpServletRequest, false);
            if (string2 != null) {
                byte[] byArray2 = Crypto.getPublicKey(string2);
                encryptedData = Account.encryptTo(byArray2, byArray, string2, bl2);
            }
        }
        if (encryptedData != null) {
            return new EncryptToSelfMessageAppendix(encryptedData, bl, bl2);
        }
        return new UnencryptedEncryptToSelfMessageAppendix(byArray, bl, bl2);
    }

    public static DigitalGoodsHome.Purchase getPurchase(HttpServletRequest httpServletRequest) throws ParameterException {
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        DigitalGoodsHome.Purchase purchase = childChain.getDigitalGoodsHome().getPurchase(ParameterParser.getUnsignedLong(httpServletRequest, "purchase", true));
        if (purchase == null) {
            throw new ParameterException(JSONResponses.INCORRECT_PURCHASE);
        }
        return purchase;
    }

    public static String getSecretPhrase(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        return ParameterParser.getSecretPhrase(httpServletRequest, null, bl);
    }

    public static String getSecretPhrase(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        String string2 = string == null ? "secretPhrase" : string + "SecretPhrase";
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter(string2));
        if (string3 != null) {
            return string3;
        }
        String[] stringArray = httpServletRequest.getParameterValues("sharedPiece");
        if (stringArray == null || string != null) {
            if (bl) {
                throw new ParameterException(JSONResponses.MISSING_SECRET_PHRASE);
            }
            return null;
        }
        List<String> list = Arrays.asList(stringArray);
        long l = ParameterParser.getAccountId(httpServletRequest, "sharedPieceAccount", false);
        String string4 = Convert.rsAccount(l);
        List<String> list2 = Nxt.getStringListProperty("nxt.secretPhrasePieces." + string4);
        List<String> list3 = Stream.concat(list.stream(), list2.stream()).distinct().collect(Collectors.toList());
        string3 = SecretSharingGenerator.combine(list3.toArray(new String[0]));
        if (l != 0L && Account.getId(Crypto.getPublicKey(string3)) != l) {
            throw new ParameterException(JSONResponses.error(String.format("Combined secret phrase does not reproduce secret phrase for account %s", string4)));
        }
        return string3;
    }

    public static byte[] getPublicKey(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getPublicKey(httpServletRequest, null);
    }

    public static byte[] getPublicKey(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        String string2 = string == null ? "secretPhrase" : string + "SecretPhrase";
        String string3 = string == null ? "publicKey" : string + "PublicKey";
        String string4 = ParameterParser.getSecretPhrase(httpServletRequest, string, false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("voucher"));
        if (string4 == null || bl) {
            try {
                byte[] byArray = Convert.parseHexString(Convert.emptyToNull(httpServletRequest.getParameter(string3)));
                if (byArray == null) {
                    throw new ParameterException(JSONResponses.missing(string2, string3));
                }
                if (!Crypto.isCanonicalPublicKey(byArray)) {
                    throw new ParameterException(JSONResponses.incorrect(string3));
                }
                return byArray;
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.incorrect(string3));
            }
        }
        return Crypto.getPublicKey(string4);
    }

    public static List<byte[]> getPublicKeys(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        String[] stringArray = httpServletRequest.getParameterValues(string);
        if (stringArray == null || stringArray.length == 0) {
            throw new ParameterException(JSONResponses.missing(string));
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (String string2 : stringArray) {
            for (String string3 : string2.split("\\n")) {
                byte[] byArray = Convert.parseHexString(string3.trim());
                if (byArray.length == 0) continue;
                if (!Crypto.isCanonicalPublicKey(byArray)) {
                    throw new ParameterException(JSONResponses.incorrect(string));
                }
                arrayList.add(byArray);
            }
        }
        return arrayList;
    }

    public static Account getSenderAccount(HttpServletRequest httpServletRequest) throws ParameterException {
        byte[] byArray = ParameterParser.getPublicKey(httpServletRequest);
        Account account = Account.getAccount(byArray);
        if (account == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_ACCOUNT);
        }
        return account;
    }

    public static long getSenderId(HttpServletRequest httpServletRequest) throws ParameterException {
        byte[] byArray = ParameterParser.getPublicKey(httpServletRequest);
        return Account.getId(byArray);
    }

    public static Account getAccount(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getAccount(httpServletRequest, true);
    }

    public static Account getAccount(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        long l = ParameterParser.getAccountId(httpServletRequest, "account", bl);
        if (l == 0L && !bl) {
            return null;
        }
        Account account = Account.getAccount(l);
        if (account == null) {
            throw new ParameterException(JSONResponses.unknownAccount(l));
        }
        return account;
    }

    public static List<Account> getAccounts(HttpServletRequest httpServletRequest) throws ParameterException {
        String[] stringArray = httpServletRequest.getParameterValues("account");
        if (stringArray == null || stringArray.length == 0) {
            throw new ParameterException(JSONResponses.MISSING_ACCOUNT);
        }
        ArrayList<Account> arrayList = new ArrayList<Account>();
        for (String string : stringArray) {
            if (string == null || string.equals("")) continue;
            try {
                Account account = Account.getAccount(Convert.parseAccountId(string));
                if (account == null) {
                    throw new ParameterException(JSONResponses.UNKNOWN_ACCOUNT);
                }
                arrayList.add(account);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.INCORRECT_ACCOUNT);
            }
        }
        return arrayList;
    }

    public static int getTimestamp(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getInt(httpServletRequest, "timestamp", 0, Integer.MAX_VALUE, false);
    }

    public static int getFirstIndex(HttpServletRequest httpServletRequest) {
        try {
            int n = Integer.parseInt(httpServletRequest.getParameter("firstIndex"));
            if (n < 0) {
                return 0;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int getLastIndex(HttpServletRequest httpServletRequest) {
        int n = Integer.MAX_VALUE;
        try {
            n = Integer.parseInt(httpServletRequest.getParameter("lastIndex"));
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!API.checkPassword(httpServletRequest)) {
            int n2 = Math.min(ParameterParser.getFirstIndex(httpServletRequest), Integer.MAX_VALUE - API.maxRecords + 1);
            n = Math.min(n, n2 + API.maxRecords - 1);
        }
        return n;
    }

    public static int getNumberOfConfirmations(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getInt(httpServletRequest, "numberOfConfirmations", 0, Nxt.getBlockchain().getHeight(), false);
    }

    public static int getHeight(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getInt(httpServletRequest, "height", 0, Nxt.getBlockchain().getHeight(), -1);
    }

    public static int getHeight(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        return bl ? ParameterParser.getInt(httpServletRequest, "height", 0, Nxt.getBlockchain().getHeight(), true) : ParameterParser.getInt(httpServletRequest, "height", 0, Nxt.getBlockchain().getHeight(), -1);
    }

    public static HoldingType getHoldingType(HttpServletRequest httpServletRequest) throws ParameterException {
        return HoldingType.get(ParameterParser.getByte(httpServletRequest, "holdingType", (byte)0, (byte)2, false));
    }

    public static long getHoldingId(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getUnsignedLong(httpServletRequest, "holding", true);
    }

    public static String getAccountProperty(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("property"));
        if (string == null && bl) {
            throw new ParameterException(JSONResponses.MISSING_PROPERTY);
        }
        return string;
    }

    public static ChainTransactionId getChainTransactionId(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 == null) {
            return null;
        }
        return ParameterParser.getChainTransactionId(string2);
    }

    public static List<ChainTransactionId> getChainTransactionIds(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        String[] stringArray = httpServletRequest.getParameterValues(string);
        if (stringArray == null) {
            return Collections.emptyList();
        }
        ArrayList<ChainTransactionId> arrayList = new ArrayList<ChainTransactionId>();
        for (String string2 : stringArray) {
            arrayList.add(ParameterParser.getChainTransactionId(string2));
        }
        return arrayList;
    }

    public static ChainTransactionId getChainTransactionId(String string) throws ParameterException {
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            throw new ParameterException(JSONResponses.incorrect(string, "must be in chainId:fullHash format"));
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            Chain chain = Chain.getChain(n);
            if (chain == null) {
                throw new ParameterException(JSONResponses.UNKNOWN_CHAIN);
            }
            byte[] byArray = Convert.parseHexString(stringArray[1]);
            if (byArray == null || byArray.length != 32) {
                throw new ParameterException(JSONResponses.incorrect(string, "invalid fullHash length"));
            }
            return new ChainTransactionId(n, byArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterException(JSONResponses.incorrect(string, "must be in chainId:fullHash format"));
        }
    }

    public static String getSearchQuery(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("query")).trim();
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("tag")).trim();
        if (string.isEmpty() && string2.isEmpty()) {
            throw new ParameterException(JSONResponses.missing("query", "tag"));
        }
        if (!string2.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(" AND TAGS:", "TAGS:", "");
            for (String string3 : Search.parseTags(string2, 0, Integer.MAX_VALUE, Integer.MAX_VALUE)) {
                stringJoiner.add(string3);
            }
            string = stringJoiner.toString() + (string.isEmpty() ? "" : " AND (" + string + ")");
        }
        return string;
    }

    public static Transaction.Builder parseTransaction(String string, String string2, String string3) throws ParameterException {
        if (string2 == null && string == null) {
            throw new ParameterException(JSONResponses.MISSING_TRANSACTION_BYTES_OR_JSON);
        }
        if (string2 != null && string != null) {
            throw new ParameterException(JSONResponses.either("transactionBytes", "transactionJSON"));
        }
        if (string3 != null && string2 == null) {
            throw new ParameterException(JSONResponses.missing("transactionBytes"));
        }
        if (string != null) {
            try {
                JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((String)string);
                return Nxt.newTransactionBuilder(jSONObject);
            }
            catch (RuntimeException | NxtException.ValidationException | ParseException throwable) {
                Logger.logDebugMessage(throwable.getMessage(), throwable);
                JSONObject jSONObject = new JSONObject();
                JSONData.putException(jSONObject, (Exception)throwable, "Incorrect transactionJSON");
                throw new ParameterException((JSONStreamAware)jSONObject);
            }
        }
        try {
            byte[] byArray = Convert.parseHexString(string2);
            JSONObject jSONObject = string3 == null ? null : (JSONObject)JSONValue.parseWithException((String)string3);
            return Nxt.newTransactionBuilder(byArray, jSONObject);
        }
        catch (RuntimeException | NxtException.ValidationException | ParseException throwable) {
            Logger.logDebugMessage(throwable.getMessage(), throwable);
            JSONObject jSONObject = new JSONObject();
            JSONData.putException(jSONObject, (Exception)throwable, "Incorrect transactionBytes");
            throw new ParameterException((JSONStreamAware)jSONObject);
        }
    }

    public static Appendix getPlainMessage(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        boolean bl2;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("message"));
        boolean bl3 = bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("messageIsText"));
        if (string != null) {
            try {
                if (bl) {
                    return new PrunablePlainMessageAppendix(string, bl2);
                }
                return new MessageAppendix(string, bl2);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.INCORRECT_ARBITRARY_MESSAGE);
            }
        }
        if (httpServletRequest.getContentType() == null || !httpServletRequest.getContentType().startsWith("multipart/form-data")) {
            return null;
        }
        FileData fileData = ParameterParser.getFileData(httpServletRequest, "messageFile", false);
        if (fileData == null) {
            return null;
        }
        byte[] byArray = fileData.getData();
        String string2 = Search.detectMimeType(byArray);
        if (string2 != null) {
            bl2 = string2.startsWith("text/");
        }
        if (bl2 && !Arrays.equals(byArray, Convert.toBytes(Convert.toString(byArray)))) {
            bl2 = false;
        }
        if (bl) {
            return new PrunablePlainMessageAppendix(byArray, bl2);
        }
        return new MessageAppendix(byArray, bl2);
    }

    public static Appendix getEncryptedMessage(HttpServletRequest httpServletRequest, Account account, boolean bl) throws ParameterException {
        boolean bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("messageToEncryptIsText"));
        boolean bl3 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("compressMessageToEncrypt"));
        byte[] byArray = null;
        byte[] byArray2 = null;
        EncryptedData encryptedData = ParameterParser.getEncryptedData(httpServletRequest, "encryptedMessage");
        if (encryptedData == null) {
            Object object;
            String string = Convert.emptyToNull(httpServletRequest.getParameter("messageToEncrypt"));
            if (string == null) {
                if (httpServletRequest.getContentType() == null || !httpServletRequest.getContentType().startsWith("multipart/form-data")) {
                    return null;
                }
                object = ParameterParser.getFileData(httpServletRequest, "messageToEncryptFile", false);
                if (object == null) {
                    return null;
                }
                byArray = ((FileData)object).getData();
                String string2 = Search.detectMimeType(byArray);
                if (string2 != null) {
                    bl2 = string2.startsWith("text/");
                }
                if (bl2 && !Arrays.equals(byArray, Convert.toBytes(Convert.toString(byArray)))) {
                    bl2 = false;
                }
            } else {
                try {
                    byArray = bl2 ? Convert.toBytes(string) : Convert.parseHexString(string);
                }
                catch (RuntimeException runtimeException) {
                    throw new ParameterException(JSONResponses.INCORRECT_MESSAGE_TO_ENCRYPT);
                }
            }
            if (account != null) {
                byArray2 = Account.getPublicKey(account.getId());
            }
            if (byArray2 == null) {
                byArray2 = Convert.parseHexString(Convert.emptyToNull(httpServletRequest.getParameter("recipientPublicKey")));
            }
            if (byArray2 == null) {
                throw new ParameterException(JSONResponses.MISSING_RECIPIENT_PUBLIC_KEY);
            }
            object = ParameterParser.getSecretPhrase(httpServletRequest, false);
            if (object != null) {
                encryptedData = Account.encryptTo(byArray2, byArray, (String)object, bl3);
            }
        }
        if (encryptedData != null) {
            if (bl) {
                return new PrunableEncryptedMessageAppendix(encryptedData, bl2, bl3);
            }
            return new EncryptedMessageAppendix(encryptedData, bl2, bl3);
        }
        if (bl) {
            return new UnencryptedPrunableEncryptedMessageAppendix(byArray, bl2, bl3, byArray2);
        }
        return new UnencryptedEncryptedMessageAppendix(byArray, bl2, bl3, byArray2);
    }

    public static TaggedDataAttachment getTaggedData(HttpServletRequest httpServletRequest) throws ParameterException, NxtException.NotValidException {
        byte[] byArray;
        Object object;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("name"));
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("description"));
        String string3 = Convert.nullToEmpty(httpServletRequest.getParameter("tags"));
        String string4 = Convert.nullToEmpty(httpServletRequest.getParameter("type")).trim();
        String string5 = Convert.nullToEmpty(httpServletRequest.getParameter("channel"));
        boolean bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("isText"));
        String string6 = Convert.nullToEmpty(httpServletRequest.getParameter("filename")).trim();
        String string7 = Convert.emptyToNull(httpServletRequest.getParameter("data"));
        if (string7 == null) {
            object = ParameterParser.getFileData(httpServletRequest, "file", true);
            if (object == null) {
                throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_FILE);
            }
            byArray = ((FileData)object).getData();
            if (string6.isEmpty() && ((FileData)object).getFilename() != null) {
                string6 = ((FileData)object).getFilename().trim();
            }
            if (string == null) {
                string = string6;
            }
        } else {
            byArray = bl ? Convert.toBytes(string7) : Convert.parseHexString(string7);
        }
        object = Search.detectMimeType(byArray, string6);
        if (object != null) {
            bl = ((String)object).startsWith("text/");
            if (string4.isEmpty()) {
                string4 = ((String)object).substring(0, Math.min(((String)object).length(), 100));
            }
        }
        if (string == null) {
            throw new ParameterException(JSONResponses.MISSING_NAME);
        }
        if ((string = string.trim()).length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_NAME);
        }
        if (string2.length() > 1000) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_DESCRIPTION);
        }
        if (string3.length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_TAGS);
        }
        if ((string4 = string4.trim()).length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_TYPE);
        }
        if ((string5 = string5.trim()).length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_CHANNEL);
        }
        if (byArray.length == 0) {
            throw new ParameterException(JSONResponses.INCORRECT_DATA_ZERO_LENGTH);
        }
        if (byArray.length > 43008) {
            throw new ParameterException(JSONResponses.INCORRECT_DATA_TOO_LONG);
        }
        if (string6.length() > 100) {
            throw new ParameterException(JSONResponses.INCORRECT_TAGGED_DATA_FILENAME);
        }
        return new TaggedDataAttachment(string, string2, string3, string4, string5, bl, string6, byArray);
    }

    public static FileData getFileData(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        if (httpServletRequest.getContentType() == null || !httpServletRequest.getContentType().startsWith("multipart/form-data")) {
            if (bl) {
                throw new ParameterException(JSONResponses.INCORRECT_FILE);
            }
            return null;
        }
        try {
            Part part = httpServletRequest.getPart(string);
            if (part == null) {
                if (bl) {
                    throw new ParameterException(JSONResponses.INCORRECT_FILE);
                }
                return null;
            }
            return new FileData(part);
        }
        catch (IOException | ServletException throwable) {
            Logger.logDebugMessage("error in reading file data", throwable);
            throw new ParameterException(JSONResponses.INCORRECT_FILE);
        }
    }

    public static Chain getChain(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getChain(httpServletRequest, true);
    }

    public static Chain getChain(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("chain"));
        if (string != null) {
            Chain chain = Chain.getChain(string.toUpperCase(Locale.ROOT));
            if (chain == null) {
                try {
                    chain = Chain.getChain(Integer.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (chain == null) {
                    throw new ParameterException(JSONResponses.UNKNOWN_CHAIN);
                }
            }
            return chain;
        }
        if (bl) {
            throw new ParameterException(JSONResponses.MISSING_CHAIN);
        }
        return null;
    }

    public static Chain getChain(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter(string));
        if (string2 != null) {
            Chain chain = Chain.getChain(string2.toUpperCase(Locale.ROOT));
            if (chain == null) {
                try {
                    chain = Chain.getChain(Integer.valueOf(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (chain == null) {
                    throw new ParameterException(JSONResponses.unknown(string));
                }
            }
            return chain;
        }
        if (bl) {
            throw new ParameterException(JSONResponses.missing(string));
        }
        return null;
    }

    public static ChildChain getChildChain(HttpServletRequest httpServletRequest) throws ParameterException {
        return ParameterParser.getChildChain(httpServletRequest, true);
    }

    public static ChildChain getChildChain(HttpServletRequest httpServletRequest, boolean bl) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("chain"));
        if (string != null) {
            ChildChain childChain = ChildChain.getChildChain(string.toUpperCase(Locale.ROOT));
            if (childChain == null) {
                try {
                    childChain = ChildChain.getChildChain(Integer.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (childChain == null) {
                    throw new ParameterException(JSONResponses.UNKNOWN_CHAIN);
                }
            }
            return childChain;
        }
        if (bl) {
            throw new ParameterException(JSONResponses.MISSING_CHAIN);
        }
        return null;
    }

    private ParameterParser() {
    }

    public static JSONObject parseVoucher(byte[] byArray) throws ParameterException {
        try {
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((String)Convert.toString(byArray));
            return ParameterParser.parseVoucher(jSONObject);
        }
        catch (ParseException parseException) {
            return ParameterParser.voucherError("Incorrect voucher " + (Object)((Object)parseException), (Exception)((Object)parseException));
        }
    }

    public static JSONObject parseVoucher(JSONObject jSONObject) throws ParameterException {
        Transaction transaction;
        String string = (String)jSONObject.get((Object)"unsignedTransactionBytes");
        if (!Crypto.verify(Convert.parseHexString((String)jSONObject.get((Object)"signature")), Convert.parseHexString(string), Convert.parseHexString((String)jSONObject.get((Object)"publicKey")))) {
            return ParameterParser.voucherError("Cannot verify voucher signature", null);
        }
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        try {
            transaction = ParameterParser.parseTransaction(jSONObject2.toJSONString(), null, null).build();
            jSONObject2 = transaction.getJSONObject();
        }
        catch (NxtException.NotValidException notValidException) {
            return ParameterParser.voucherError("Invalid voucher JSON", notValidException);
        }
        try {
            Transaction transaction2 = ParameterParser.parseTransaction(null, string, ((JSONObject)jSONObject2.get((Object)"attachment")).toJSONString()).build();
            transaction = transaction2.getJSONObject();
        }
        catch (NxtException.NotValidException notValidException) {
            return ParameterParser.voucherError("Invalid voucher Bytes", notValidException);
        }
        if (!jSONObject2.equals((Object)transaction)) {
            return ParameterParser.voucherError(String.format("Voucher transaction bytes data %s differ from transaction json %s", transaction, jSONObject2), null);
        }
        return jSONObject;
    }

    private static JSONObject voucherError(String string, Exception exception) throws ParameterException {
        if (exception != null) {
            Logger.logErrorMessage(string, exception);
        } else {
            Logger.logErrorMessage(string);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"errorCode", (Object)4);
        jSONObject.put((Object)"errorDescription", (Object)string);
        throw new ParameterException((JSONStreamAware)jSONObject);
    }

    public static PhasingParams parsePhasingParams(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        return ParameterParser.parsePhasingParams(httpServletRequest, string, false);
    }

    private static PhasingParams parsePhasingParams(HttpServletRequest httpServletRequest, String string, boolean bl) throws ParameterException {
        PhasingParams.HashVoting hashVoting;
        Object object;
        List<ChainTransactionId> list;
        byte by = ParameterParser.getByte(httpServletRequest, string + "VotingModel", (byte)VoteWeighting.VotingModel.MIN_CODE, (byte)VoteWeighting.VotingModel.MAX_CODE, true);
        long l = ParameterParser.getLong(httpServletRequest, string + "Quorum", 0L, Long.MAX_VALUE, false);
        long l2 = ParameterParser.getLong(httpServletRequest, string + "MinBalance", 0L, Long.MAX_VALUE, false);
        byte by2 = ParameterParser.getByte(httpServletRequest, string + "MinBalanceModel", (byte)0, (byte)3, false);
        long l3 = ParameterParser.getUnsignedLong(httpServletRequest, string + "Holding", false);
        if (l3 == 0L && (by == VoteWeighting.VotingModel.COIN.getCode() || by2 == VoteWeighting.MinBalanceModel.COIN.getCode())) {
            l3 = ParameterParser.getChain(httpServletRequest).getId();
        }
        long[] lArray = null;
        String[] stringArray = httpServletRequest.getParameterValues(string + "Whitelisted");
        if (stringArray != null && stringArray.length > 0) {
            lArray = new long[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                lArray[i] = Convert.parseAccountId(stringArray[i]);
                if (lArray[i] != 0L) continue;
                throw new ParameterException(JSONResponses.INCORRECT_WHITELIST);
            }
        }
        VoteWeighting voteWeighting = new VoteWeighting(by, l3, l2, by2);
        if (string.startsWith("phasing")) {
            list = ParameterParser.getChainTransactionIds(httpServletRequest, string + "LinkedTransaction");
            object = Convert.parseHexString(Convert.emptyToNull(httpServletRequest.getParameter(string + "HashedSecret")));
            byte by3 = ParameterParser.getByte(httpServletRequest, string + "HashedSecretAlgorithm", (byte)0, (byte)127, false);
            hashVoting = new PhasingParams.HashVoting((byte[])object, by3);
        } else {
            list = Collections.emptyList();
            hashVoting = null;
        }
        object = ParameterParser.parsePropertyVoting(httpServletRequest, string + "Sender");
        PhasingParams.PropertyVoting propertyVoting = ParameterParser.parsePropertyVoting(httpServletRequest, string + "Recipient");
        PhasingParams.CompositeVoting compositeVoting = null;
        if (by == VoteWeighting.VotingModel.COMPOSITE.getCode()) {
            if (bl) {
                throw new ParameterException(JSONResponses.error("Sub-polls cannot have sub-polls"));
            }
            if (l != 1L) {
                throw new ParameterException(JSONResponses.incorrect("quorum"));
            }
            String string2 = string + "Expression";
            String string3 = Convert.emptyToNull(httpServletRequest.getParameter(string2));
            if (string3 == null) {
                throw new ParameterException(JSONResponses.missing(string2));
            }
            BooleanExpression booleanExpression = new BooleanExpression(string3);
            if (booleanExpression.hasErrors(true)) {
                throw new ParameterException(JSONResponses.booleanExpressionError(booleanExpression));
            }
            Set<String> set = booleanExpression.getVariables();
            TreeMap<String, PhasingParams> treeMap = new TreeMap<String, PhasingParams>();
            JSONObject jSONObject = ParameterParser.getJson(httpServletRequest, "phasingSubPolls");
            if (jSONObject != null) {
                for (String string4 : set) {
                    JSONObject jSONObject2 = (JSONObject)JSONValue.parse((String)((String)jSONObject.get((Object)string4)));
                    treeMap.put(string4, new PhasingParams(jSONObject2));
                }
            } else {
                for (String string5 : set) {
                    PhasingParams phasingParams;
                    string5 = string5.trim();
                    try {
                        phasingParams = ParameterParser.parsePhasingParams(httpServletRequest, string + string5, true);
                    }
                    catch (ParameterException parameterException) {
                        JSONStreamAware jSONStreamAware = parameterException.getErrorResponse();
                        StringWriter stringWriter = new StringWriter();
                        try {
                            jSONStreamAware.writeJSONString((Writer)stringWriter);
                            JSONObject jSONObject3 = (JSONObject)JSONValue.parse((String)stringWriter.toString());
                            jSONObject3.put((Object)"subPoll", (Object)string5);
                            throw new ParameterException(JSON.prepare(jSONObject3));
                        }
                        catch (IOException iOException) {
                            throw new IllegalStateException(iOException);
                        }
                    }
                    treeMap.put(string5, phasingParams);
                }
            }
            compositeVoting = new PhasingParams.CompositeVoting(string3, treeMap);
        }
        return new PhasingParams(voteWeighting, l, lArray, list, hashVoting, compositeVoting, (PhasingParams.PropertyVoting)object, propertyVoting);
    }

    private static PhasingParams.PropertyVoting parsePropertyVoting(HttpServletRequest httpServletRequest, String string) throws ParameterException {
        long l = ParameterParser.getAccountId(httpServletRequest, string + "PropertySetter", false);
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter(string + "PropertyName")).trim();
        String string3 = Convert.nullToEmpty(httpServletRequest.getParameter(string + "PropertyValue")).trim();
        return new PhasingParams.PropertyVoting(l, string2, string3);
    }

    public static List<Bundler.Filter> getBundlingFilters(HttpServletRequest httpServletRequest) {
        List<Bundler.Filter> list;
        String[] stringArray = httpServletRequest.getParameterValues("filter");
        if (stringArray != null) {
            list = new ArrayList<Bundler.Filter>(stringArray.length);
            for (String string : stringArray) {
                String[] stringArray2 = string.split(":", 2);
                String string2 = stringArray2[0];
                String string3 = null;
                if (stringArray2.length == 2) {
                    string3 = stringArray2[1];
                }
                list.add(Bundler.createBundlingFilter(string2, string3));
            }
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public static class FileData {
        private String filename;
        private byte[] data;

        public FileData(Part part) throws ParameterException {
            try {
                try (InputStream inputStream = part.getInputStream();){
                    int n;
                    byte[] byArray = new byte[1024];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    this.data = byteArrayOutputStream.toByteArray();
                }
                this.filename = part.getSubmittedFileName();
            }
            catch (IOException iOException) {
                Logger.logDebugMessage("error in reading file data " + part.getSubmittedFileName(), iOException);
                throw new ParameterException(JSONResponses.INCORRECT_FILE);
            }
        }

        public String getFilename() {
            return this.filename;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

