/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.account.Account;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.messaging.EncryptToSelfMessageAppendix;
import nxt.messaging.EncryptedMessageAppendix;
import nxt.messaging.MessageAppendix;
import nxt.messaging.PrunableMessageHome;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class ReadMessage
extends APIServlet.APIRequestHandler {
    static final ReadMessage instance = new ReadMessage();

    private ReadMessage() {
        super(new APITag[]{APITag.MESSAGES}, "transactionFullHash", "secretPhrase", "sharedKey", "retrieve");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        EncryptToSelfMessageAppendix encryptToSelfMessageAppendix;
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "transactionFullHash", true);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("retrieve"));
        Chain chain = ParameterParser.getChain(httpServletRequest);
        Transaction transaction = Nxt.getBlockchain().getTransaction(chain, byArray);
        if (transaction == null) {
            return JSONResponses.UNKNOWN_TRANSACTION;
        }
        PrunableMessageHome prunableMessageHome = chain.getPrunableMessageHome();
        PrunableMessageHome.PrunableMessage prunableMessage = prunableMessageHome.getPrunableMessage(byArray);
        if (prunableMessage == null && (transaction.getPrunablePlainMessage() != null || transaction.getPrunableEncryptedMessage() != null) && bl) {
            if (Nxt.getBlockchainProcessor().restorePrunedTransaction(chain, byArray) == null) {
                return JSONResponses.PRUNED_TRANSACTION;
            }
            prunableMessage = prunableMessageHome.getPrunableMessage(byArray);
        }
        JSONObject jSONObject = new JSONObject();
        MessageAppendix messageAppendix = transaction instanceof ChildTransaction ? ((ChildTransaction)transaction).getMessage() : null;
        EncryptedMessageAppendix encryptedMessageAppendix = transaction instanceof ChildTransaction ? ((ChildTransaction)transaction).getEncryptedMessage() : null;
        EncryptToSelfMessageAppendix encryptToSelfMessageAppendix2 = encryptToSelfMessageAppendix = transaction instanceof ChildTransaction ? ((ChildTransaction)transaction).getEncryptToSelfMessage() : null;
        if (messageAppendix == null && encryptedMessageAppendix == null && encryptToSelfMessageAppendix == null && prunableMessage == null) {
            return JSONResponses.NO_MESSAGE;
        }
        if (messageAppendix != null) {
            jSONObject.put((Object)"message", (Object)Convert.toString(messageAppendix.getMessage(), messageAppendix.isText()));
            jSONObject.put((Object)"messageIsPrunable", (Object)false);
        } else if (prunableMessage != null && prunableMessage.getMessage() != null) {
            jSONObject.put((Object)"message", (Object)Convert.toString(prunableMessage.getMessage(), prunableMessage.messageIsText()));
            jSONObject.put((Object)"messageIsPrunable", (Object)true);
        }
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        byte[] byArray2 = ParameterParser.getBytes(httpServletRequest, "sharedKey", false);
        if (byArray2.length != 0 && string != null) {
            return JSONResponses.either("secretPhrase", "sharedKey");
        }
        if (string != null || byArray2.length > 0) {
            byte[] byArray3;
            byte[] byArray4;
            EncryptedData encryptedData = null;
            boolean bl2 = false;
            boolean bl3 = true;
            if (encryptedMessageAppendix != null) {
                encryptedData = encryptedMessageAppendix.getEncryptedData();
                bl2 = encryptedMessageAppendix.isText();
                bl3 = encryptedMessageAppendix.isCompressed();
                jSONObject.put((Object)"encryptedMessageIsPrunable", (Object)false);
            } else if (prunableMessage != null && prunableMessage.getEncryptedData() != null) {
                encryptedData = prunableMessage.getEncryptedData();
                bl2 = prunableMessage.encryptedMessageIsText();
                bl3 = prunableMessage.isCompressed();
                jSONObject.put((Object)"encryptedMessageIsPrunable", (Object)true);
            }
            if (encryptedData != null) {
                try {
                    byArray4 = null;
                    if (string != null) {
                        byte[] byArray5;
                        byArray3 = Crypto.getPublicKey(string);
                        byte[] byArray6 = Account.getPublicKey(transaction.getSenderId());
                        byte[] byArray7 = Account.getPublicKey(transaction.getRecipientId());
                        byte[] byArray8 = byArray5 = Arrays.equals(byArray6, byArray3) ? byArray7 : byArray6;
                        if (byArray5 != null) {
                            byArray4 = Account.decryptFrom(byArray5, encryptedData, string, bl3);
                        }
                    } else {
                        byArray4 = Crypto.aesDecrypt(encryptedData.getData(), byArray2);
                        if (bl3) {
                            byArray4 = Convert.uncompress(byArray4);
                        }
                    }
                    jSONObject.put((Object)"decryptedMessage", (Object)Convert.toString(byArray4, bl2));
                }
                catch (RuntimeException runtimeException) {
                    Logger.logDebugMessage("Decryption of message to recipient failed: " + runtimeException.toString());
                    JSONData.putException(jSONObject, runtimeException, "Wrong secretPhrase or sharedKey");
                }
            }
            if (encryptToSelfMessageAppendix != null && string != null) {
                byArray4 = Crypto.getPublicKey(string);
                try {
                    byArray3 = Account.decryptFrom(byArray4, encryptToSelfMessageAppendix.getEncryptedData(), string, encryptToSelfMessageAppendix.isCompressed());
                    jSONObject.put((Object)"decryptedMessageToSelf", (Object)Convert.toString(byArray3, encryptToSelfMessageAppendix.isText()));
                }
                catch (RuntimeException runtimeException) {
                    Logger.logDebugMessage("Decryption of message to self failed: " + runtimeException.toString());
                }
            }
        }
        return jSONObject;
    }
}

