/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class RetrievePrunedData
extends APIServlet.APIRequestHandler {
    static final RetrievePrunedData instance = new RetrievePrunedData();

    private RetrievePrunedData() {
        super(new APITag[]{APITag.DEBUG}, new String[0]);
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        try {
            int n = Nxt.getBlockchainProcessor().restorePrunedData(childChain);
            jSONObject.put((Object)"done", (Object)true);
            jSONObject.put((Object)"numberOfPrunedData", (Object)n);
        }
        catch (RuntimeException runtimeException) {
            JSONData.putException(jSONObject, runtimeException);
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean requirePassword() {
        return true;
    }

    @Override
    protected final boolean allowRequiredBlockParameters() {
        return false;
    }
}

