/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.ae.Asset;
import nxt.ae.AssetPropertyAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class SetAssetProperty
extends CreateTransaction {
    static final SetAssetProperty instance = new SetAssetProperty();

    private SetAssetProperty() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "asset", "property", "value");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("property")).trim();
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("value")).trim();
        if (string.length() > 32 || string.length() == 0) {
            return JSONResponses.INCORRECT_ASSET_PROPERTY_NAME_LENGTH;
        }
        if (string2.length() > 160) {
            return JSONResponses.INCORRECT_ASSET_PROPERTY_VALUE_LENGTH;
        }
        AssetPropertyAttachment assetPropertyAttachment = new AssetPropertyAttachment(asset.getId(), string, string2);
        return this.transactionParameters(httpServletRequest, account, assetPropertyAttachment).setRecipientId(asset.getAccountId()).createTransaction();
    }

    @Override
    public boolean isIgnisOnly() {
        return true;
    }
}

