/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.ChildChain;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.shuffling.ShufflingHome;
import nxt.shuffling.ShufflingRegistrationAttachment;
import org.json.simple.JSONStreamAware;

public final class ShufflingRegister
extends CreateTransaction {
    static final ShufflingRegister instance = new ShufflingRegister();

    private ShufflingRegister() {
        super(new APITag[]{APITag.SHUFFLING, APITag.CREATE_TRANSACTION}, "shufflingFullHash");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "shufflingFullHash", true);
        ShufflingRegistrationAttachment shufflingRegistrationAttachment = new ShufflingRegistrationAttachment(byArray);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        if (account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return JSONResponses.error("Accounts under phasing only control cannot join a shuffling");
        }
        try {
            return this.createTransaction(httpServletRequest, account, shufflingRegistrationAttachment);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
            ShufflingHome.Shuffling shuffling = childChain.getShufflingHome().getShuffling(byArray);
            if (shuffling == null) {
                return JSONResponses.NOT_ENOUGH_FUNDS;
            }
            return JSONResponses.notEnoughHolding(shuffling.getHoldingType());
        }
    }
}

