/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SignTransaction
extends APIServlet.APIRequestHandler {
    static final SignTransaction instance = new SignTransaction();

    private SignTransaction() {
        super(new APITag[]{APITag.TRANSACTIONS}, "unsignedTransactionJSON", "unsignedTransactionBytes", "prunableAttachmentJSON", "secretPhrase", "validate");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("unsignedTransactionJSON"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("unsignedTransactionBytes"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("prunableAttachmentJSON"));
        Transaction.Builder builder = ParameterParser.parseTransaction(string, string2, string3);
        String string4 = ParameterParser.getSecretPhrase(httpServletRequest, true);
        boolean bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("validate"));
        JSONObject jSONObject = new JSONObject();
        try {
            Transaction transaction = builder.build(string4);
            JSONObject jSONObject2 = JSONData.unconfirmedTransaction(transaction);
            if (bl) {
                transaction.validate();
                jSONObject.put((Object)"verify", (Object)transaction.verifySignature());
            }
            jSONObject.put((Object)"transactionJSON", (Object)jSONObject2);
            jSONObject.put((Object)"fullHash", jSONObject2.get((Object)"fullHash"));
            jSONObject.put((Object)"signatureHash", jSONObject2.get((Object)"signatureHash"));
            jSONObject.put((Object)"transactionBytes", (Object)Convert.toHexString(transaction.getBytes()));
            JSONData.putPrunableAttachment(jSONObject, transaction);
        }
        catch (RuntimeException | NxtException.ValidationException exception) {
            Logger.logErrorMessage("Incorrect unsigned transaction json or bytes", exception);
            JSONData.putException(jSONObject, exception, "Incorrect unsigned transaction json or bytes");
        }
        return jSONObject;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

