/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.math.BigInteger;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.crypto.SecretSharingGenerator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SplitSecret
extends APIServlet.APIRequestHandler {
    static final SplitSecret instance = new SplitSecret();

    private SplitSecret() {
        super(new APITag[]{APITag.UTILS}, "secretPhrase", "totalPieces", "minimumPieces", "primeFieldSize");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        int n = ParameterParser.getInt(httpServletRequest, "totalPieces", 2, 9, true);
        int n2 = ParameterParser.getInt(httpServletRequest, "minimumPieces", 1, 9, true);
        BigInteger bigInteger = ParameterParser.getBigInteger(httpServletRequest, "primeFieldSize", false);
        try {
            String[] stringArray = SecretSharingGenerator.split(string, n, n2, bigInteger);
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            jSONArray.addAll(Arrays.asList(stringArray));
            jSONObject.put((Object)"pieces", (Object)jSONArray);
            jSONObject.put((Object)"totalPieces", (Object)n);
            jSONObject.put((Object)"minimumPieces", (Object)n2);
            if (bigInteger.equals(BigInteger.ZERO)) {
                jSONObject.put((Object)"actualPrimeFieldSize", (Object)SecretSharingGenerator.getModPrime(string).toString());
            } else {
                jSONObject.put((Object)"actualPrimeFieldSize", (Object)bigInteger.toString());
            }
            return JSON.prepare(jSONObject);
        }
        catch (RuntimeException runtimeException) {
            Logger.logInfoMessage("Failed to split secretPhrase", runtimeException);
            return JSONResponses.error(runtimeException.toString());
        }
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

