/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Bundler;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.crypto.Crypto;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.peer.Peers;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class StartBundler
extends APIServlet.APIRequestHandler {
    static final StartBundler instance = new StartBundler();

    private StartBundler() {
        super(new APITag[]{APITag.FORGING}, "secretPhrase", "minRateNQTPerFXT", "totalFeesLimitFQT", "overpayFQTPerFXT", "feeCalculatorName", "filter", "filter", "filter", "bundlingRulesJSON");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        ArrayList<Bundler.Rule> arrayList;
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONArray jSONArray = ParameterParser.getJsonArray(httpServletRequest, "bundlingRulesJSON");
        long l = ParameterParser.getLong(httpServletRequest, "totalFeesLimitFQT", 0L, 100000000000000000L, false);
        if (jSONArray != null) {
            arrayList = new ArrayList(jSONArray.size());
            for (Object e : jSONArray) {
                List<Bundler.Filter> list;
                JSONObject jSONObject = (JSONObject)e;
                long l2 = Convert.parseLong(jSONObject.get((Object)"minRateNQTPerFXT"));
                long l3 = Convert.parseLong(jSONObject.get((Object)"overpayFQTPerFXT"));
                String string2 = Convert.emptyToNull((String)jSONObject.get((Object)"feeCalculatorName"));
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"filters");
                if (jSONArray2 != null) {
                    list = new ArrayList(jSONArray2.size());
                    jSONArray2.forEach(object -> {
                        JSONObject jSONObject = (JSONObject)object;
                        String string = Convert.emptyToNull((String)jSONObject.get((Object)"name"));
                        String string2 = Convert.emptyToNull((String)jSONObject.get((Object)"parameter"));
                        list.add(Bundler.createBundlingFilter(string, string2));
                    });
                } else {
                    list = Collections.emptyList();
                }
                arrayList.add(Bundler.createBundlingRule(l2, l3, string2, list));
            }
        } else {
            long l4 = ParameterParser.getLong(httpServletRequest, "minRateNQTPerFXT", 0L, 100000000000000000L, true);
            long l5 = ParameterParser.getLong(httpServletRequest, "overpayFQTPerFXT", 0L, 100000000000000000L, false);
            String string3 = httpServletRequest.getParameter("feeCalculatorName");
            List<Bundler.Filter> list = ParameterParser.getBundlingFilters(httpServletRequest);
            arrayList = Collections.singletonList(Bundler.createBundlingRule(l4, l5, string3, list));
        }
        long l6 = Account.getId(Crypto.getPublicKey(string));
        if (l > FxtChain.FXT.getBalanceHome().getBalance(l6).getUnconfirmedBalance()) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
        Account account = Account.getAccount(l6);
        if (account != null && account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return JSONResponses.error("Accounts under phasing only control cannot run a bundler");
        }
        Bundler bundler = Bundler.addOrChangeBundler(childChain, string, l, arrayList);
        Peers.broadcastBundlerRates();
        return JSONData.bundler(bundler);
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

